/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.threshold.apply;

import java.util.ArrayList;
import net.imagej.ops.Ops;
import net.imagej.ops.map.neighborhood.CenterAwareIntegralComputerOp;
import net.imagej.ops.special.computer.AbstractUnaryComputerOp;
import net.imagej.ops.special.computer.BinaryComputerOp;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.outofbounds.OutOfBoundsBorderFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import net.imglib2.view.composite.Composite;
import net.imglib2.view.composite.CompositeIntervalView;
import org.scijava.plugin.Parameter;

public abstract class LocalThresholdIntegral<I extends RealType<I>>
extends AbstractUnaryComputerOp<RandomAccessibleInterval<I>, IterableInterval<BitType>> {
    @Parameter
    protected RectangleShape shape;
    @Parameter(required=false)
    private OutOfBoundsFactory<I, RandomAccessibleInterval<I>> outOfBoundsFactory = new OutOfBoundsBorderFactory();
    private CenterAwareIntegralComputerOp<I, BitType> filterOp;
    private AbstractUnaryHybridCF<RandomAccessibleInterval<I>, RandomAccessibleInterval<RealType<?>>> integralImgOp;
    private AbstractUnaryHybridCF<RandomAccessibleInterval<I>, RandomAccessibleInterval<RealType<?>>> squareIntegralImgOp;
    private BinaryComputerOp<RandomAccessibleInterval<I>, RectangleShape.NeighborhoodsIterableInterval<? extends Composite<RealType>>, IterableInterval<BitType>> map;

    @Override
    public void initialize() {
        this.shape = new RectangleShape(this.shape.getSpan() + 1, false);
        this.filterOp = this.unaryComputer();
        this.integralImgOp = (AbstractUnaryHybridCF)((Object)this.ops().op(Ops.Image.Integral.class, this.in()));
        this.squareIntegralImgOp = (AbstractUnaryHybridCF)((Object)this.ops().op(Ops.Image.SquareIntegral.class, this.in()));
    }

    @Override
    public void compute(RandomAccessibleInterval<I> input, IterableInterval<BitType> output) {
        ArrayList<RandomAccessibleInterval<RealType>> listOfIntegralImages = new ArrayList<RandomAccessibleInterval<RealType>>();
        for (int order : this.requiredIntegralImages()) {
            RandomAccessibleInterval<RealType> requiredIntegralImg = this.getIntegralImage(input, order);
            listOfIntegralImages.add(requiredIntegralImg);
        }
        RandomAccessibleInterval stacked = Views.stack(listOfIntegralImages);
        CompositeIntervalView compositeRAI = Views.collapse((RandomAccessibleInterval)stacked);
        RandomAccessibleInterval extendedCompositeRAI = this.removeLeadingZeros((RandomAccessibleInterval)compositeRAI);
        RectangleShape.NeighborhoodsIterableInterval neighborhoods = this.shape.neighborhoodsSafe(extendedCompositeRAI);
        if (this.map == null) {
            this.map = (BinaryComputerOp)((Object)this.ops().op(Ops.Map.class, this.out(), this.in(), neighborhoods, this.filterOp));
        }
        this.map.compute(input, (RectangleShape.NeighborhoodsIterableInterval<? extends Composite<RealType>>)neighborhoods, output);
    }

    private RandomAccessibleInterval<RealType> getIntegralImage(RandomAccessibleInterval<I> input, int order) {
        ExtendedRandomAccessibleInterval extendedInput = Views.extend(input, this.outOfBoundsFactory);
        FinalInterval expandedInterval = Intervals.expand(input, (long)(this.shape.getSpan() - 1));
        IntervalView offsetInterval2 = Views.offsetInterval((RandomAccessible)extendedInput, (Interval)expandedInterval);
        RandomAccessibleInterval img = null;
        switch (order) {
            case 1: {
                img = (RandomAccessibleInterval)this.integralImgOp.calculate(offsetInterval2);
                break;
            }
            case 2: {
                img = (RandomAccessibleInterval)this.squareIntegralImgOp.calculate(offsetInterval2);
            }
        }
        img = this.addLeadingZeros(img);
        return img;
    }

    private <T extends RealType<T>> RandomAccessibleInterval<T> addLeadingZeros(RandomAccessibleInterval<T> input) {
        long[] min = Intervals.minAsLongArray(input);
        long[] max = Intervals.maxAsLongArray(input);
        int i = 0;
        while (i < max.length) {
            int n = i++;
            min[n] = min[n] - 1L;
        }
        RealType realZero = (RealType)((RealType)Util.getTypeFromInterval(input)).copy();
        realZero.setZero();
        ExtendedRandomAccessibleInterval extendedImg = Views.extendValue(input, (Type)realZero);
        IntervalView offsetInterval = Views.interval((RandomAccessible)extendedImg, (long[])min, (long[])max);
        return Views.zeroMin((RandomAccessibleInterval)offsetInterval);
    }

    private <T> RandomAccessibleInterval<T> removeLeadingZeros(RandomAccessibleInterval<T> input) {
        long[] min = Intervals.minAsLongArray(input);
        long[] max = Intervals.maxAsLongArray(input);
        int d = 0;
        while (d < input.numDimensions()) {
            int correctedSpan = this.getShape().getSpan() - 1;
            int n = d;
            min[n] = min[n] + (long)(1 + correctedSpan);
            int n2 = d++;
            max[n2] = max[n2] - (long)correctedSpan;
        }
        FinalInterval interval = new FinalInterval(min, max);
        IntervalView extendedImg = Views.offsetInterval((RandomAccessible)Views.extendBorder(input), (Interval)interval);
        return extendedImg;
    }

    public RectangleShape getShape() {
        return this.shape;
    }

    protected abstract CenterAwareIntegralComputerOp<I, BitType> unaryComputer();

    protected abstract int[] requiredIntegralImages();
}

