/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.threshold.minimum;

import net.imagej.ops.Ops;
import net.imagej.ops.threshold.AbstractComputeThresholdHistogram;
import net.imagej.ops.threshold.Thresholds;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.type.numeric.RealType;
import org.scijava.ItemIO;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Threshold.Minimum.class, priority=100.0)
public class ComputeMinimumThreshold<T extends RealType<T>>
extends AbstractComputeThresholdHistogram<T>
implements Ops.Threshold.Minimum {
    @Parameter(type=ItemIO.OUTPUT)
    private String errMsg;

    @Override
    public long computeBin(Histogram1d<T> hist) {
        long[] histogram = hist.toLongArray();
        if (histogram.length < 2) {
            return 0L;
        }
        int iter = 0;
        int max = -1;
        double[] iHisto = new double[histogram.length];
        for (int i = 0; i < histogram.length; ++i) {
            iHisto[i] = histogram[i];
            if (histogram[i] <= 0L) continue;
            max = i;
        }
        double[] tHisto = new double[iHisto.length];
        while (!Thresholds.bimodalTest(iHisto)) {
            for (int i = 1; i < histogram.length - 1; ++i) {
                tHisto[i] = (iHisto[i - 1] + iHisto[i] + iHisto[i + 1]) / 3.0;
            }
            tHisto[0] = (iHisto[0] + iHisto[1]) / 3.0;
            tHisto[histogram.length - 1] = (iHisto[histogram.length - 2] + iHisto[histogram.length - 1]) / 3.0;
            System.arraycopy(tHisto, 0, iHisto, 0, iHisto.length);
            if (++iter <= 10000) continue;
            this.errMsg = "Minimum Threshold not found after 10000 iterations.";
            return -1L;
        }
        double[] y = iHisto;
        for (int k = 1; k < max; ++k) {
            if (!(y[k - 1] > y[k]) || !(y[k + 1] >= y[k])) continue;
            return k;
        }
        return -1L;
    }
}

