/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.topology.eulerCharacteristic;

import java.util.ArrayList;
import java.util.Arrays;
import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Topology.EulerCharacteristic26NFloating.class)
public class EulerCharacteristic26NFloating<B extends BooleanType<B>>
extends AbstractUnaryHybridCF<RandomAccessibleInterval<B>, DoubleType>
implements Ops.Topology.EulerCharacteristic26NFloating,
Contingent {
    private static final int[] EULER_LUT = new int[256];

    @Override
    public boolean conforms() {
        return ((RandomAccessibleInterval)this.in()).numDimensions() == 3;
    }

    @Override
    public void compute(RandomAccessibleInterval<B> rai, DoubleType output) {
        IntervalView ival = Views.expandZero(rai, (long[])new long[]{1L, 1L, 1L});
        long w = ival.dimension(0);
        long h = ival.dimension(1);
        long d = ival.dimension(2);
        int nThreads = this.ops().getMaxThreads();
        long nPixels = w * h * d;
        long taskSize = Math.max(nPixels / (long)Math.max(nThreads - 1, 1), 100000L);
        int sumDeltaEuler = 0;
        int[] threadSumDeltaEuler = new int[nThreads];
        int thread = 0;
        ArrayList<Thread> taskList = new ArrayList<Thread>();
        for (long s = 0L; s < nPixels; s += taskSize) {
            int n = thread++;
            long start = s;
            long stop = Math.min(start + taskSize, nPixels);
            int steps = (int)(stop - start);
            Runnable task = new Runnable((RandomAccessibleInterval)ival, start, w, h, steps, threadSumDeltaEuler, n){
                final /* synthetic */ RandomAccessibleInterval val$ival;
                final /* synthetic */ long val$start;
                final /* synthetic */ long val$w;
                final /* synthetic */ long val$h;
                final /* synthetic */ int val$steps;
                final /* synthetic */ int[] val$threadSumDeltaEuler;
                final /* synthetic */ int val$n;
                {
                    this.val$ival = randomAccessibleInterval;
                    this.val$start = l;
                    this.val$w = l2;
                    this.val$h = l3;
                    this.val$steps = n;
                    this.val$threadSumDeltaEuler = nArray;
                    this.val$n = n2;
                }

                @Override
                public void run() {
                    RandomAccessibleInterval interval = this.val$ival;
                    Cursor octantCursor1 = Views.flatIterable((RandomAccessibleInterval)interval).cursor();
                    Cursor octantCursor2 = Views.flatIterable((RandomAccessibleInterval)interval).cursor();
                    Cursor octantCursor3 = Views.flatIterable((RandomAccessibleInterval)interval).cursor();
                    Cursor octantCursor4 = Views.flatIterable((RandomAccessibleInterval)interval).cursor();
                    Cursor octantCursor5 = Views.flatIterable((RandomAccessibleInterval)interval).cursor();
                    Cursor octantCursor6 = Views.flatIterable((RandomAccessibleInterval)interval).cursor();
                    Cursor octantCursor7 = Views.flatIterable((RandomAccessibleInterval)interval).cursor();
                    Cursor octantCursor8 = Views.flatIterable((RandomAccessibleInterval)interval).cursor();
                    octantCursor1.jumpFwd(this.val$start);
                    octantCursor2.jumpFwd(this.val$start + this.val$w);
                    octantCursor3.jumpFwd(this.val$start + 1L);
                    octantCursor4.jumpFwd(this.val$start + this.val$w + 1L);
                    octantCursor5.jumpFwd(this.val$start + this.val$w * this.val$h);
                    octantCursor6.jumpFwd(this.val$start + this.val$w * this.val$h + this.val$w);
                    octantCursor7.jumpFwd(this.val$start + this.val$w * this.val$h + 1L);
                    octantCursor8.jumpFwd(this.val$start + this.val$w * this.val$h + this.val$w + 1L);
                    for (int i = 0; i < this.val$steps; ++i) {
                        boolean o1 = ((BooleanType)octantCursor1.next()).get();
                        boolean o2 = ((BooleanType)octantCursor2.next()).get();
                        boolean o3 = ((BooleanType)octantCursor3.next()).get();
                        boolean o4 = ((BooleanType)octantCursor4.next()).get();
                        boolean o5 = ((BooleanType)octantCursor5.next()).get();
                        boolean o6 = ((BooleanType)octantCursor6.next()).get();
                        boolean o7 = ((BooleanType)octantCursor7.next()).get();
                        boolean o8 = ((BooleanType)octantCursor8.next()).get();
                        if (!o1 && !o2 && !o3 && !o4 && !o5 && !o6 && !o7 && !o8) continue;
                        int n = this.val$n;
                        this.val$threadSumDeltaEuler[n] = this.val$threadSumDeltaEuler[n] + EulerCharacteristic26NFloating.getDeltaEuler(o1, o2, o3, o4, o5, o6, o7, o8);
                    }
                }
            };
            taskList.add(new Thread(task));
        }
        for (Thread t : taskList) {
            t.setPriority(5);
            t.start();
        }
        try {
            for (Thread t : taskList) {
                t.join();
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        sumDeltaEuler = Arrays.stream(threadSumDeltaEuler).sum();
        output.set((double)sumDeltaEuler / 8.0);
    }

    private static int getDeltaEuler(boolean o1, boolean o2, boolean o3, boolean o4, boolean o5, boolean o6, boolean o7, boolean o8) {
        int index = 1;
        if (o8) {
            if (o1) {
                index |= 0x80;
            }
            if (o2) {
                index |= 0x40;
            }
            if (o3) {
                index |= 0x20;
            }
            if (o4) {
                index |= 0x10;
            }
            if (o5) {
                index |= 8;
            }
            if (o6) {
                index |= 4;
            }
            if (o7) {
                index |= 2;
            }
        } else if (o7) {
            if (o2) {
                index |= 0x80;
            }
            if (o4) {
                index |= 0x40;
            }
            if (o1) {
                index |= 0x20;
            }
            if (o3) {
                index |= 0x10;
            }
            if (o6) {
                index |= 8;
            }
            if (o5) {
                index |= 2;
            }
        } else if (o6) {
            if (o3) {
                index |= 0x80;
            }
            if (o1) {
                index |= 0x40;
            }
            if (o4) {
                index |= 0x20;
            }
            if (o2) {
                index |= 0x10;
            }
            if (o5) {
                index |= 4;
            }
        } else if (o5) {
            if (o4) {
                index |= 0x80;
            }
            if (o3) {
                index |= 0x40;
            }
            if (o2) {
                index |= 0x20;
            }
            if (o1) {
                index |= 0x10;
            }
        } else if (o4) {
            if (o1) {
                index |= 8;
            }
            if (o3) {
                index |= 4;
            }
            if (o2) {
                index |= 2;
            }
        } else if (o3) {
            if (o2) {
                index |= 8;
            }
            if (o1) {
                index |= 4;
            }
        } else if (o2) {
            if (o1) {
                index |= 2;
            }
        } else {
            return 1;
        }
        return EULER_LUT[index];
    }

    @Override
    public DoubleType createOutput(RandomAccessibleInterval<B> input) {
        return new DoubleType(0.0);
    }

    static {
        EulerCharacteristic26NFloating.EULER_LUT[1] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[3] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[5] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[7] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[9] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[11] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[13] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[15] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[17] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[19] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[21] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[23] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[25] = -3;
        EulerCharacteristic26NFloating.EULER_LUT[27] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[29] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[31] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[33] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[35] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[37] = -3;
        EulerCharacteristic26NFloating.EULER_LUT[39] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[41] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[43] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[45] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[47] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[49] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[51] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[53] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[55] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[57] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[59] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[61] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[63] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[65] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[67] = -3;
        EulerCharacteristic26NFloating.EULER_LUT[69] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[71] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[73] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[75] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[77] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[79] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[81] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[83] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[85] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[87] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[89] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[91] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[93] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[95] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[97] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[99] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[101] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[103] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[105] = 4;
        EulerCharacteristic26NFloating.EULER_LUT[107] = 3;
        EulerCharacteristic26NFloating.EULER_LUT[109] = 3;
        EulerCharacteristic26NFloating.EULER_LUT[111] = 2;
        EulerCharacteristic26NFloating.EULER_LUT[113] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[115] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[117] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[119] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[121] = 3;
        EulerCharacteristic26NFloating.EULER_LUT[123] = 2;
        EulerCharacteristic26NFloating.EULER_LUT[125] = 2;
        EulerCharacteristic26NFloating.EULER_LUT[127] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[129] = -6;
        EulerCharacteristic26NFloating.EULER_LUT[131] = -3;
        EulerCharacteristic26NFloating.EULER_LUT[133] = -3;
        EulerCharacteristic26NFloating.EULER_LUT[135] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[137] = -3;
        EulerCharacteristic26NFloating.EULER_LUT[139] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[141] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[143] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[145] = -3;
        EulerCharacteristic26NFloating.EULER_LUT[147] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[149] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[151] = 3;
        EulerCharacteristic26NFloating.EULER_LUT[153] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[155] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[157] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[159] = 2;
        EulerCharacteristic26NFloating.EULER_LUT[161] = -3;
        EulerCharacteristic26NFloating.EULER_LUT[163] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[165] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[167] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[169] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[171] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[173] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[175] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[177] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[179] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[181] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[183] = 2;
        EulerCharacteristic26NFloating.EULER_LUT[185] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[187] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[189] = 2;
        EulerCharacteristic26NFloating.EULER_LUT[191] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[193] = -3;
        EulerCharacteristic26NFloating.EULER_LUT[195] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[197] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[199] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[201] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[203] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[205] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[207] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[209] = -2;
        EulerCharacteristic26NFloating.EULER_LUT[211] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[213] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[215] = 2;
        EulerCharacteristic26NFloating.EULER_LUT[217] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[219] = 2;
        EulerCharacteristic26NFloating.EULER_LUT[221] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[223] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[225] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[227] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[229] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[231] = 2;
        EulerCharacteristic26NFloating.EULER_LUT[233] = 3;
        EulerCharacteristic26NFloating.EULER_LUT[235] = 2;
        EulerCharacteristic26NFloating.EULER_LUT[237] = 2;
        EulerCharacteristic26NFloating.EULER_LUT[239] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[241] = -1;
        EulerCharacteristic26NFloating.EULER_LUT[243] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[245] = 0;
        EulerCharacteristic26NFloating.EULER_LUT[247] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[249] = 2;
        EulerCharacteristic26NFloating.EULER_LUT[251] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[253] = 1;
        EulerCharacteristic26NFloating.EULER_LUT[255] = 0;
    }
}

