/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.topology.eulerCharacteristic;

import java.util.stream.LongStream;
import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Topology.EulerCorrection.class)
public class EulerCorrection<B extends BooleanType<B>>
extends AbstractUnaryHybridCF<RandomAccessibleInterval<B>, DoubleType>
implements Ops.Topology.EulerCorrection,
Contingent {
    @Override
    public boolean conforms() {
        return ((RandomAccessibleInterval)this.in()).numDimensions() == 3;
    }

    @Override
    public void compute(RandomAccessibleInterval<B> interval, DoubleType output) {
        Traverser<B> traverser = new Traverser<B>(interval);
        long chiZero = EulerCorrection.stackCorners(traverser);
        long e = EulerCorrection.stackEdges(traverser) + 3L * chiZero;
        long d = EulerCorrection.voxelEdgeIntersections(traverser) + chiZero;
        long c = (long)EulerCorrection.stackFaces(traverser) + 2L * e - 3L * chiZero;
        long b = EulerCorrection.voxelEdgeFaceIntersections(traverser);
        long a = EulerCorrection.voxelFaceIntersections(traverser);
        long chiOne = d - e;
        long chiTwo = a - b + c;
        output.set((double)chiTwo / 2.0 + (double)chiOne / 4.0 + (double)chiZero / 8.0);
    }

    @Override
    public DoubleType createOutput(RandomAccessibleInterval<B> input) {
        return new DoubleType(0.0);
    }

    public static <B extends BooleanType<B>> int stackCorners(Traverser<B> traverser) {
        int foregroundVoxels = 0;
        traverser.getClass();
        traverser.getClass();
        traverser.getClass();
        foregroundVoxels += EulerCorrection.getAtLocation(traverser, 0L, 0L, 0L);
        long l = traverser.x1;
        traverser.getClass();
        traverser.getClass();
        foregroundVoxels += EulerCorrection.getAtLocation(traverser, l, 0L, 0L);
        long l2 = traverser.x1;
        long l3 = traverser.y1;
        traverser.getClass();
        foregroundVoxels += EulerCorrection.getAtLocation(traverser, l2, l3, 0L);
        traverser.getClass();
        long l4 = traverser.y1;
        traverser.getClass();
        foregroundVoxels += EulerCorrection.getAtLocation(traverser, 0L, l4, 0L);
        traverser.getClass();
        traverser.getClass();
        foregroundVoxels += EulerCorrection.getAtLocation(traverser, 0L, 0L, traverser.z1);
        long l5 = traverser.x1;
        traverser.getClass();
        foregroundVoxels += EulerCorrection.getAtLocation(traverser, l5, 0L, traverser.z1);
        foregroundVoxels += EulerCorrection.getAtLocation(traverser, traverser.x1, traverser.y1, traverser.z1);
        traverser.getClass();
        return foregroundVoxels += EulerCorrection.getAtLocation(traverser, 0L, traverser.y1, traverser.z1);
    }

    public static <B extends BooleanType<B>> long stackEdges(Traverser<B> traverser) {
        long[] foregroundVoxels = new long[]{0L};
        long[] lArray = new long[2];
        traverser.getClass();
        lArray[0] = 0L;
        lArray[1] = traverser.z1;
        LongStream.of(lArray).forEach(z -> {
            long[] lArray = new long[2];
            traverser.getClass();
            lArray[0] = 0L;
            lArray[1] = traverser.y1;
            LongStream.of(lArray).forEach(y -> {
                for (long x = 1L; x < traverser.x1; ++x) {
                    foregroundVoxels[0] = foregroundVoxels[0] + (long)EulerCorrection.getAtLocation(traverser, x, y, z);
                }
            });
        });
        long[] lArray2 = new long[2];
        traverser.getClass();
        lArray2[0] = 0L;
        lArray2[1] = traverser.z1;
        LongStream.of(lArray2).forEach(z -> {
            long[] lArray = new long[2];
            traverser.getClass();
            lArray[0] = 0L;
            lArray[1] = traverser.x1;
            LongStream.of(lArray).forEach(x -> {
                for (long y = 1L; y < traverser.y1; ++y) {
                    foregroundVoxels[0] = foregroundVoxels[0] + (long)EulerCorrection.getAtLocation(traverser, x, y, z);
                }
            });
        });
        long[] lArray3 = new long[2];
        traverser.getClass();
        lArray3[0] = 0L;
        lArray3[1] = traverser.y1;
        LongStream.of(lArray3).forEach(y -> {
            long[] lArray = new long[2];
            traverser.getClass();
            lArray[0] = 0L;
            lArray[1] = traverser.x1;
            LongStream.of(lArray).forEach(x -> {
                for (long z = 1L; z < traverser.z1; ++z) {
                    foregroundVoxels[0] = foregroundVoxels[0] + (long)EulerCorrection.getAtLocation(traverser, x, y, z);
                }
            });
        });
        return foregroundVoxels[0];
    }

    public static <B extends BooleanType<B>> int stackFaces(Traverser<B> traverser) {
        int[] foregroundVoxels = new int[]{0};
        long[] lArray = new long[2];
        traverser.getClass();
        lArray[0] = 0L;
        lArray[1] = traverser.z1;
        LongStream.of(lArray).forEach(z -> {
            Cursor cursor = Views.hyperSlice(traverser.rai, (int)2, (long)z).localizingCursor();
            while (cursor.hasNext()) {
                cursor.fwd();
                long x = cursor.getLongPosition(0);
                long y = cursor.getLongPosition(1);
                if (x == 0L || y == 0L || x == traverser.x1 || y == traverser.y1) continue;
                foregroundVoxels[0] = (int)((double)foregroundVoxels[0] + ((BooleanType)cursor.get()).getRealDouble());
            }
        });
        long[] lArray2 = new long[2];
        traverser.getClass();
        lArray2[0] = 0L;
        lArray2[1] = traverser.y1;
        LongStream.of(lArray2).forEach(y -> {
            Cursor cursor = Views.hyperSlice(traverser.rai, (int)1, (long)y).localizingCursor();
            while (cursor.hasNext()) {
                cursor.fwd();
                long x = cursor.getLongPosition(0);
                long z = cursor.getLongPosition(1);
                if (x == 0L || z == 0L || x == traverser.x1 || z == traverser.z1) continue;
                foregroundVoxels[0] = (int)((double)foregroundVoxels[0] + ((BooleanType)cursor.get()).getRealDouble());
            }
        });
        long[] lArray3 = new long[2];
        traverser.getClass();
        lArray3[0] = 0L;
        lArray3[1] = traverser.x1;
        LongStream.of(lArray3).forEach(x -> {
            Cursor cursor = Views.hyperSlice(traverser.rai, (int)0, (long)x).localizingCursor();
            while (cursor.hasNext()) {
                cursor.fwd();
                long y = cursor.getLongPosition(0);
                long z = cursor.getLongPosition(1);
                if (y == 0L || z == 0L || y == traverser.y1 || z == traverser.z1) continue;
                foregroundVoxels[0] = (int)((double)foregroundVoxels[0] + ((BooleanType)cursor.get()).getRealDouble());
            }
        });
        return foregroundVoxels[0];
    }

    public static <B extends BooleanType<B>> long voxelEdgeIntersections(Traverser<B> traverser) {
        int[] voxelVertices = new int[]{0};
        long[] lArray = new long[2];
        traverser.getClass();
        lArray[0] = 0L;
        lArray[1] = traverser.z1;
        LongStream.of(lArray).forEach(z -> {
            traverser.access.setPosition(z, 2);
            long[] lArray = new long[2];
            traverser.getClass();
            lArray[0] = 0L;
            lArray[1] = traverser.y1;
            LongStream.of(lArray).forEach(y -> {
                traverser.access.setPosition(y, 1);
                for (long x = 1L; x < traverser.xSize; ++x) {
                    int voxelA = EulerCorrection.getAtLocation(traverser, x, y, z);
                    int voxelB = EulerCorrection.getAtLocation(traverser, x - 1L, y, z);
                    voxelVertices[0] = voxelVertices[0] + (voxelA | voxelB);
                }
            });
        });
        long[] lArray2 = new long[2];
        traverser.getClass();
        lArray2[0] = 0L;
        lArray2[1] = traverser.z1;
        LongStream.of(lArray2).forEach(z -> {
            traverser.access.setPosition(z, 2);
            long[] lArray = new long[2];
            traverser.getClass();
            lArray[0] = 0L;
            lArray[1] = traverser.x1;
            LongStream.of(lArray).forEach(x -> {
                traverser.access.setPosition(x, 0);
                for (long y = 1L; y < traverser.ySize; ++y) {
                    int voxelA = EulerCorrection.getAtLocation(traverser, x, y, z);
                    int voxelB = EulerCorrection.getAtLocation(traverser, x, y - 1L, z);
                    voxelVertices[0] = voxelVertices[0] + (voxelA | voxelB);
                }
            });
        });
        long[] lArray3 = new long[2];
        traverser.getClass();
        lArray3[0] = 0L;
        lArray3[1] = traverser.y1;
        LongStream.of(lArray3).forEach(y -> {
            traverser.access.setPosition(y, 1);
            long[] lArray = new long[2];
            traverser.getClass();
            lArray[0] = 0L;
            lArray[1] = traverser.x1;
            LongStream.of(lArray).forEach(x -> {
                traverser.access.setPosition(x, 0);
                for (long z = 1L; z < traverser.zSize; ++z) {
                    int voxelA = EulerCorrection.getAtLocation(traverser, x, y, z);
                    int voxelB = EulerCorrection.getAtLocation(traverser, x, y, z - 1L);
                    voxelVertices[0] = voxelVertices[0] + (voxelA | voxelB);
                }
            });
        });
        return voxelVertices[0];
    }

    public static <B extends BooleanType<B>> long voxelEdgeFaceIntersections(Traverser<B> traverser) {
        long[] voxelEdges = new long[]{0L};
        long[] iterations = new long[]{0L};
        long[] lArray = new long[2];
        traverser.getClass();
        lArray[0] = 0L;
        lArray[1] = traverser.z1;
        LongStream.of(lArray).forEach(z -> {
            IntervalView sliceRai = Views.hyperSlice(traverser.rai, (int)2, (long)z);
            sliceRai = Views.expandZero((RandomAccessibleInterval)sliceRai, (long[])new long[]{1L, 1L});
            long w = sliceRai.dimension(0);
            Cursor cursorA = Views.flatIterable((RandomAccessibleInterval)sliceRai).cursor();
            Cursor cursorB = Views.flatIterable((RandomAccessibleInterval)sliceRai).cursor();
            Cursor cursorC = Views.flatIterable((RandomAccessibleInterval)sliceRai).cursor();
            cursorA.jumpFwd(w + 1L);
            cursorB.jumpFwd(1L);
            cursorC.jumpFwd(w);
            while (cursorA.hasNext()) {
                cursorA.next();
                cursorB.next();
                cursorC.next();
                boolean voxel = ((BooleanType)cursorA.get()).get();
                if (voxel) {
                    iterations[0] = iterations[0] + 1L;
                    voxelEdges[0] = voxelEdges[0] + 2L;
                    continue;
                }
                voxelEdges[0] = (long)((double)voxelEdges[0] + ((BooleanType)cursorB.get()).getRealDouble());
                voxelEdges[0] = (long)((double)voxelEdges[0] + ((BooleanType)cursorC.get()).getRealDouble());
            }
        });
        long[] lArray2 = new long[2];
        traverser.getClass();
        lArray2[0] = 0L;
        lArray2[1] = traverser.y1;
        LongStream.of(lArray2).forEach(y -> {
            IntervalView sliceRai = Views.hyperSlice(traverser.rai, (int)1, (long)y);
            long w = sliceRai.dimension(0);
            Cursor cursorA = Views.flatIterable((RandomAccessibleInterval)sliceRai).cursor();
            Cursor cursorB = Views.flatIterable((RandomAccessibleInterval)sliceRai).cursor();
            cursorA.jumpFwd(w);
            cursorB.jumpFwd(0L);
            while (cursorA.hasNext()) {
                cursorA.next();
                cursorB.next();
                if (!((BooleanType)cursorA.get()).get() && !((BooleanType)cursorB.get()).get()) continue;
                voxelEdges[0] = voxelEdges[0] + 1L;
            }
        });
        long[] lArray3 = new long[2];
        traverser.getClass();
        lArray3[0] = 0L;
        lArray3[1] = traverser.y1;
        LongStream.of(lArray3).forEach(y -> {
            IntervalView sliceRai = Views.hyperSlice(traverser.rai, (int)1, (long)y);
            sliceRai = Views.expandZero((RandomAccessibleInterval)sliceRai, (long[])new long[]{1L, 1L});
            long w = sliceRai.dimension(0);
            Cursor cursorA = Views.flatIterable((RandomAccessibleInterval)sliceRai).cursor();
            Cursor cursorB = Views.flatIterable((RandomAccessibleInterval)sliceRai).cursor();
            cursorA.jumpFwd(w + 1L);
            cursorB.jumpFwd(w);
            while (cursorA.hasNext()) {
                cursorA.next();
                cursorB.next();
                if (!((BooleanType)cursorA.get()).get() && !((BooleanType)cursorB.get()).get()) continue;
                voxelEdges[0] = voxelEdges[0] + 1L;
            }
        });
        long[] lArray4 = new long[2];
        traverser.getClass();
        lArray4[0] = 0L;
        lArray4[1] = traverser.x1;
        LongStream.of(lArray4).forEach(x -> {
            IntervalView sliceRai = Views.hyperSlice(traverser.rai, (int)0, (long)x);
            long w = sliceRai.dimension(0);
            Cursor cursorA = Views.flatIterable((RandomAccessibleInterval)sliceRai).cursor();
            Cursor cursorB = Views.flatIterable((RandomAccessibleInterval)sliceRai).cursor();
            cursorA.jumpFwd(w);
            cursorB.jumpFwd(0L);
            while (cursorA.hasNext()) {
                cursorA.next();
                cursorB.next();
                if (!((BooleanType)cursorA.get()).get() && !((BooleanType)cursorB.get()).get()) continue;
                voxelEdges[0] = voxelEdges[0] + 1L;
            }
        });
        long[] lArray5 = new long[2];
        traverser.getClass();
        lArray5[0] = 0L;
        lArray5[1] = traverser.x1;
        LongStream.of(lArray5).forEach(x -> {
            IntervalView sliceRai = Views.hyperSlice(traverser.rai, (int)0, (long)x);
            sliceRai = Views.expandZero((RandomAccessibleInterval)sliceRai, (long[])new long[]{1L, 1L});
            long w = sliceRai.dimension(0);
            Cursor cursorA = Views.flatIterable((RandomAccessibleInterval)sliceRai).localizingCursor();
            Cursor cursorB = Views.flatIterable((RandomAccessibleInterval)sliceRai).cursor();
            cursorA.jumpFwd(w + 1L);
            cursorB.jumpFwd(w);
            while (cursorA.hasNext()) {
                cursorA.next();
                cursorB.next();
                long y = cursorA.getLongPosition(0);
                long z = cursorA.getLongPosition(1);
                if (y == 0L || y > traverser.y1 || z > traverser.z1 || !((BooleanType)cursorA.get()).get() && !((BooleanType)cursorB.get()).get()) continue;
                voxelEdges[0] = voxelEdges[0] + 1L;
            }
        });
        return voxelEdges[0];
    }

    public static <B extends BooleanType<B>> long voxelFaceIntersections(Traverser<B> traverser) {
        long[] pixelFaces = new long[]{0L};
        long[] lArray = new long[2];
        traverser.getClass();
        lArray[0] = 0L;
        lArray[1] = traverser.z1;
        LongStream.of(lArray).forEach(z -> {
            IntervalView sliceRai = Views.hyperSlice(traverser.rai, (int)2, (long)z);
            sliceRai = Views.expandZero((RandomAccessibleInterval)sliceRai, (long[])new long[]{1L, 1L});
            long w = sliceRai.dimension(0);
            Cursor cursorA = Views.flatIterable((RandomAccessibleInterval)sliceRai).cursor();
            Cursor cursorB = Views.flatIterable((RandomAccessibleInterval)sliceRai).cursor();
            Cursor cursorC = Views.flatIterable((RandomAccessibleInterval)sliceRai).cursor();
            Cursor cursorD = Views.flatIterable((RandomAccessibleInterval)sliceRai).cursor();
            cursorA.jumpFwd(w + 1L);
            cursorB.jumpFwd(w);
            cursorC.jumpFwd(1L);
            cursorD.jumpFwd(0L);
            while (cursorA.hasNext()) {
                int pixelA = (int)((BooleanType)cursorA.next()).getRealDouble();
                int pixelB = (int)((BooleanType)cursorB.next()).getRealDouble();
                int pixelC = (int)((BooleanType)cursorC.next()).getRealDouble();
                int pixelD = (int)((BooleanType)cursorD.next()).getRealDouble();
                pixelFaces[0] = pixelFaces[0] + (long)(pixelA | pixelB | pixelC | pixelD);
            }
        });
        long[] lArray2 = new long[2];
        traverser.getClass();
        lArray2[0] = 0L;
        lArray2[1] = traverser.x1;
        LongStream.of(lArray2).forEach(x -> {
            IntervalView sliceRai = Views.hyperSlice(traverser.rai, (int)0, (long)x);
            sliceRai = Views.expandZero((RandomAccessibleInterval)sliceRai, (long[])new long[]{1L, 0L});
            long w = sliceRai.dimension(0);
            Cursor cursorA = Views.flatIterable((RandomAccessibleInterval)sliceRai).cursor();
            Cursor cursorB = Views.flatIterable((RandomAccessibleInterval)sliceRai).cursor();
            Cursor cursorC = Views.flatIterable((RandomAccessibleInterval)sliceRai).cursor();
            Cursor cursorD = Views.flatIterable((RandomAccessibleInterval)sliceRai).cursor();
            cursorA.jumpFwd(w + 1L);
            cursorB.jumpFwd(w);
            cursorC.jumpFwd(1L);
            cursorD.jumpFwd(0L);
            while (cursorA.hasNext()) {
                int pixelA = (int)((BooleanType)cursorA.next()).getRealDouble();
                int pixelB = (int)((BooleanType)cursorB.next()).getRealDouble();
                int pixelC = (int)((BooleanType)cursorC.next()).getRealDouble();
                int pixelD = (int)((BooleanType)cursorD.next()).getRealDouble();
                pixelFaces[0] = pixelFaces[0] + (long)(pixelA | pixelB | pixelC | pixelD);
            }
        });
        long[] lArray3 = new long[2];
        traverser.getClass();
        lArray3[0] = 0L;
        lArray3[1] = traverser.y1;
        LongStream.of(lArray3).forEach(y -> {
            IntervalView sliceRai = Views.hyperSlice(traverser.rai, (int)1, (long)y);
            long w = sliceRai.dimension(0);
            Cursor cursorA = Views.flatIterable((RandomAccessibleInterval)sliceRai).localizingCursor();
            Cursor cursorB = Views.flatIterable((RandomAccessibleInterval)sliceRai).cursor();
            Cursor cursorC = Views.flatIterable((RandomAccessibleInterval)sliceRai).cursor();
            Cursor cursorD = Views.flatIterable((RandomAccessibleInterval)sliceRai).cursor();
            cursorA.jumpFwd(w + 1L);
            cursorB.jumpFwd(w);
            cursorC.jumpFwd(1L);
            cursorD.jumpFwd(0L);
            while (cursorA.hasNext()) {
                int pixelA = (int)((BooleanType)cursorA.next()).getRealDouble();
                int pixelB = (int)((BooleanType)cursorB.next()).getRealDouble();
                int pixelC = (int)((BooleanType)cursorC.next()).getRealDouble();
                int pixelD = (int)((BooleanType)cursorD.next()).getRealDouble();
                if (cursorA.getLongPosition(0) == 0L) continue;
                pixelFaces[0] = pixelFaces[0] + (long)(pixelA | pixelB | pixelC | pixelD);
            }
        });
        return pixelFaces[0];
    }

    private static <B extends BooleanType<B>> int getAtLocation(Traverser<B> traverser, long x, long y, long z) {
        traverser.access.setPosition(x, 0);
        traverser.access.setPosition(y, 1);
        traverser.access.setPosition(z, 2);
        double realDouble = ((BooleanType)traverser.access.get()).getRealDouble();
        return (int)realDouble;
    }

    public static class Traverser<B extends BooleanType<B>> {
        public final long x0 = 0L;
        public final long y0 = 0L;
        public final long z0 = 0L;
        public final long x1;
        public final long y1;
        public final long z1;
        public final long xSize;
        public final long ySize;
        public final long zSize;
        public final RandomAccess<B> access;
        public final RandomAccessibleInterval<B> rai;

        public Traverser(RandomAccessibleInterval<B> interval) {
            this.xSize = interval.dimension(0);
            this.ySize = interval.dimension(1);
            this.zSize = interval.dimension(2);
            this.x1 = this.xSize - 1L;
            this.y1 = this.ySize - 1L;
            this.z1 = this.zSize - 1L;
            this.access = Views.extendZero(interval).randomAccess();
            this.rai = interval;
        }
    }
}

