/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.commands.debug;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Plugins", weight=5.0, mnemonic=117), @Menu(label="Debug"), @Menu(label="Dump Stack", accelerator="shift back_slash")}, headless=true)
public class DumpStack
implements Command {
    private static final String NL = System.getProperty("line.separator");
    @Parameter(label="Stack Dump", type=ItemIO.OUTPUT)
    private String stackDump;

    public void run() {
        StringBuilder sb = new StringBuilder();
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        ArrayList<Thread> threads = new ArrayList<Thread>(stackTraces.keySet());
        Collections.sort(threads, new Comparator<Thread>(){

            @Override
            public int compare(Thread t1, Thread t2) {
                return t1.getName().compareTo(t2.getName());
            }
        });
        for (Thread t : threads) {
            this.dumpThread(t, stackTraces.get(t), sb);
        }
        this.stackDump = sb.toString();
    }

    private void dumpThread(Thread t, StackTraceElement[] trace, StringBuilder sb) {
        this.threadInfo(t, sb);
        for (StackTraceElement element : trace) {
            sb.append("\tat ");
            sb.append(element);
            sb.append(NL);
        }
        sb.append(NL);
    }

    private void threadInfo(Thread t, StringBuilder sb) {
        sb.append("\"");
        sb.append(t.getName());
        sb.append("\"");
        if (!t.isAlive()) {
            sb.append(" DEAD");
        }
        if (t.isInterrupted()) {
            sb.append(" INTERRUPTED");
        }
        if (t.isDaemon()) {
            sb.append(" daemon");
        }
        sb.append(" prio=");
        sb.append(t.getPriority());
        sb.append(" id=");
        sb.append(t.getId());
        sb.append(" group=");
        sb.append(t.getThreadGroup().getName());
        sb.append(NL);
        sb.append("   java.lang.Thread.State: ");
        sb.append((Object)t.getState());
        sb.append(NL);
    }
}

