/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.blocks;

import java.util.ArrayList;
import java.util.List;
import net.imglib2.blocks.Ranges;

class RangesImpl {
    static Ranges FIND_RANGES_CONSTANT = RangesImpl::findRanges_constant;
    static Ranges FIND_RANGES_MIRROR_SINGLE = RangesImpl::findRanges_mirror_single;
    static Ranges FIND_RANGES_MIRROR_DOUBLE = RangesImpl::findRanges_mirror_double;
    static Ranges FIND_RANGES_BORDER = RangesImpl::findRanges_border;

    RangesImpl() {
    }

    static List<Ranges.Range> findRanges_constant(long bx, int bw, long iw, int cw) {
        ArrayList<Ranges.Range> ranges = new ArrayList<Ranges.Range>();
        if (bw <= 0) {
            return ranges;
        }
        int x = 0;
        if (bx < 0L) {
            int w = (int)Math.min((long)bw, -bx);
            ranges.add(new Ranges.Range(-1, -1, w, Ranges.Direction.CONSTANT, x));
            bw -= w;
            bx += (long)w;
            x += w;
        }
        if (bw <= 0) {
            return ranges;
        }
        int gx = (int)(bx / (long)cw);
        int cx = (int)(bx - (long)gx * (long)cw);
        while (bw > 0 && bx < iw) {
            int w = Math.min(bw, RangesImpl.cellWidth(gx, cw, iw) - cx);
            ranges.add(new Ranges.Range(gx, cx, w, Ranges.Direction.FORWARD, x));
            bw -= w;
            bx += (long)w;
            x += w;
            ++gx;
            cx = 0;
        }
        if (bw > 0) {
            ranges.add(new Ranges.Range(-1, -1, bw, Ranges.Direction.CONSTANT, x));
        }
        return ranges;
    }

    static List<Ranges.Range> findRanges_border(long bx, int bw, long iw, int cw) {
        ArrayList<Ranges.Range> ranges = new ArrayList<Ranges.Range>();
        if (bw <= 0) {
            return ranges;
        }
        int x = 0;
        if (bx < 0L) {
            int w = (int)Math.min((long)bw, -bx);
            ranges.add(new Ranges.Range(0, 0, w, Ranges.Direction.STAY, x));
            bw -= w;
            bx += (long)w;
            x += w;
        }
        if (bw <= 0) {
            return ranges;
        }
        int gx = (int)(bx / (long)cw);
        int cx = (int)(bx - (long)gx * (long)cw);
        while (bw > 0 && bx < iw) {
            int w = Math.min(bw, RangesImpl.cellWidth(gx, cw, iw) - cx);
            ranges.add(new Ranges.Range(gx, cx, w, Ranges.Direction.FORWARD, x));
            bw -= w;
            bx += (long)w;
            x += w;
            ++gx;
            cx = 0;
        }
        if (bw <= 0) {
            return ranges;
        }
        gx = (int)((iw - 1L) / (long)cw);
        cx = RangesImpl.cellWidth(gx, cw, iw) - 1;
        ranges.add(new Ranges.Range(gx, cx, bw, Ranges.Direction.STAY, x));
        return ranges;
    }

    static List<Ranges.Range> findRanges_mirror_double(long bx, int bw, long iw, int cw) {
        ArrayList<Ranges.Range> ranges = new ArrayList<Ranges.Range>();
        long pi = 2L * iw;
        bx = bx < 0L ? (bx + 1L) % pi + pi - 1L : bx % pi;
        Ranges.Direction dir = Ranges.Direction.FORWARD;
        if (bx >= iw) {
            bx = pi - 1L - bx;
            dir = Ranges.Direction.BACKWARD;
        }
        int gx = (int)(bx / (long)cw);
        int cx = (int)(bx - (long)gx * (long)cw);
        int x = 0;
        while (bw > 0) {
            if (dir == Ranges.Direction.FORWARD) {
                int gxw = RangesImpl.cellWidth(gx, cw, iw);
                int w = Math.min(bw, gxw - cx);
                Ranges.Range range = new Ranges.Range(gx, cx, w, Ranges.Direction.FORWARD, x);
                ranges.add(range);
                bw -= w;
                x += w;
                if ((long)(++gx) * (long)cw >= iw) {
                    --gx;
                    cx = gxw - 1;
                    dir = Ranges.Direction.BACKWARD;
                    continue;
                }
                cx = 0;
                continue;
            }
            int w = Math.min(bw, cx + 1);
            Ranges.Range range = new Ranges.Range(gx, cx, w, Ranges.Direction.BACKWARD, x);
            ranges.add(range);
            bw -= w;
            x += w;
            if (gx == 0) {
                cx = 0;
                dir = Ranges.Direction.FORWARD;
                continue;
            }
            cx = RangesImpl.cellWidth(--gx, cw, iw) - 1;
        }
        return ranges;
    }

    static List<Ranges.Range> findRanges_mirror_single(long bx, int bw, long iw, int cw) {
        ArrayList<Ranges.Range> ranges = new ArrayList<Ranges.Range>();
        long pi = 2L * iw - 2L;
        bx = bx < 0L ? (bx + 1L) % pi + pi - 1L : bx % pi;
        Ranges.Direction dir = Ranges.Direction.FORWARD;
        if (bx >= iw) {
            bx = pi - bx;
            dir = Ranges.Direction.BACKWARD;
        }
        int gx = (int)(bx / (long)cw);
        int cx = (int)(bx - (long)gx * (long)cw);
        int x = 0;
        while (bw > 0) {
            if (dir == Ranges.Direction.FORWARD) {
                int gxw = RangesImpl.cellWidth(gx, cw, iw);
                int w = Math.min(bw, gxw - cx);
                Ranges.Range range = new Ranges.Range(gx, cx, w, Ranges.Direction.FORWARD, x);
                ranges.add(range);
                bw -= w;
                x += w;
                if ((long)(++gx) * (long)cw >= iw) {
                    --gx;
                    cx = gxw - 2;
                    dir = Ranges.Direction.BACKWARD;
                    continue;
                }
                cx = 0;
                continue;
            }
            int w = Math.min(bw, gx == 0 ? cx : cx + 1);
            Ranges.Range range = new Ranges.Range(gx, cx, w, Ranges.Direction.BACKWARD, x);
            ranges.add(range);
            bw -= w;
            x += w;
            if (gx == 0) {
                cx = 0;
                dir = Ranges.Direction.FORWARD;
                continue;
            }
            cx = RangesImpl.cellWidth(--gx, cw, iw) - 1;
        }
        return ranges;
    }

    private static int cellWidth(int gx, int cw, long iw) {
        int gw = (int)(iw / (long)cw);
        if (gx < gw) {
            return cw;
        }
        if (gx == gw) {
            return (int)(iw - (long)(cw * gw));
        }
        throw new IllegalArgumentException();
    }
}

