/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.basictypeaccess.nio;

import java.nio.ByteBuffer;
import net.imglib2.img.basictypeaccess.array.AbstractByteArray;
import net.imglib2.img.basictypeaccess.nio.AbstractBufferAccess;
import net.imglib2.img.basictypeaccess.volatiles.VolatileByteAccess;

public class ByteBufferAccess
extends AbstractBufferAccess<ByteBufferAccess, ByteBuffer>
implements VolatileByteAccess {
    private static final long serialVersionUID = -7265085228179236189L;
    private static final int NUM_BYTES_PER_ENTITY = 1;

    public ByteBufferAccess(ByteBuffer buffer, boolean isValid) {
        super(buffer, isValid);
    }

    public ByteBufferAccess(int numEntities, boolean isValid) {
        super(ByteBuffer.allocate(numEntities), isValid);
    }

    public ByteBufferAccess(int numEntities) {
        this(numEntities, true);
    }

    public ByteBufferAccess() {
        this((ByteBuffer)null, false);
    }

    @Override
    public byte getValue(int index) {
        return ((ByteBuffer)this.buffer).get(index);
    }

    @Override
    public void setValue(int index, byte value) {
        ((ByteBuffer)this.buffer).put(index, value);
    }

    @Override
    public int getNumBytesPerEntity() {
        return 1;
    }

    @Override
    public ByteBufferAccess newInstance(ByteBuffer buffer, boolean isValid) {
        return ByteBufferAccess.fromByteBuffer(buffer, isValid);
    }

    @Override
    ByteBuffer duplicateBuffer(ByteBuffer buffer) {
        return buffer.duplicate();
    }

    public static ByteBufferAccess fromByteBuffer(ByteBuffer buffer, boolean isValid) {
        return new ByteBufferAccess(buffer, isValid);
    }

    public ByteBuffer getValues(AbstractByteArray<?> array) {
        return ((ByteBuffer)this.buffer).duplicate().get(array.getCurrentStorageArray());
    }

    public ByteBuffer getValues(AbstractByteArray<?> array, int offset, int length) {
        return ((ByteBuffer)this.buffer).duplicate().get(array.getCurrentStorageArray(), offset, length);
    }

    public ByteBuffer setValues(AbstractByteArray<?> array) {
        return ((ByteBuffer)this.buffer).duplicate().put(array.getCurrentStorageArray());
    }

    public ByteBuffer setValues(AbstractByteArray<?> array, int offset, int length) {
        return ((ByteBuffer)this.buffer).duplicate().put(array.getCurrentStorageArray(), offset, length);
    }

    public ByteBuffer setValues(ByteBufferAccess access) {
        return ((ByteBuffer)this.buffer).duplicate().put((ByteBuffer)access.getCurrentStorageArray());
    }
}

