/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.basictypeaccess.nio;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import net.imglib2.img.basictypeaccess.array.AbstractDoubleArray;
import net.imglib2.img.basictypeaccess.nio.AbstractBufferAccess;
import net.imglib2.img.basictypeaccess.volatiles.VolatileDoubleAccess;

public class DoubleBufferAccess
extends AbstractBufferAccess<DoubleBufferAccess, DoubleBuffer>
implements VolatileDoubleAccess {
    private static final long serialVersionUID = -7265085228179236189L;
    private static final int NUM_BYTES_PER_ENTITY = 8;

    public DoubleBufferAccess(DoubleBuffer buffer, boolean isValid) {
        super(buffer, isValid);
    }

    public DoubleBufferAccess(int numEntities, boolean isValid) {
        super(DoubleBuffer.allocate(numEntities), isValid);
    }

    public DoubleBufferAccess(ByteBuffer buffer, boolean isValid) {
        super(buffer.asDoubleBuffer(), isValid);
    }

    public DoubleBufferAccess(DoubleBuffer buffer) {
        this(buffer, true);
    }

    public DoubleBufferAccess(int numEntities) {
        this(numEntities, true);
    }

    public DoubleBufferAccess(ByteBuffer buffer) {
        this(buffer, true);
    }

    public DoubleBufferAccess() {
        this((DoubleBuffer)null, false);
    }

    @Override
    public double getValue(int index) {
        return ((DoubleBuffer)this.buffer).get(index);
    }

    @Override
    public void setValue(int index, double value) {
        ((DoubleBuffer)this.buffer).put(index, value);
    }

    @Override
    public int getNumBytesPerEntity() {
        return 8;
    }

    @Override
    public DoubleBufferAccess newInstance(ByteBuffer buffer, boolean isValid) {
        return DoubleBufferAccess.fromByteBuffer(buffer, isValid);
    }

    @Override
    public DoubleBufferAccess newInstance(DoubleBuffer buffer, boolean isValid) {
        return new DoubleBufferAccess(buffer, isValid);
    }

    @Override
    DoubleBuffer duplicateBuffer(DoubleBuffer buffer) {
        return buffer.duplicate();
    }

    @Override
    DoubleBufferAccess allocate(int numEntities, boolean isDirect, boolean isValid) {
        if (isDirect) {
            return (DoubleBufferAccess)super.allocate(numEntities, isDirect, isValid);
        }
        return new DoubleBufferAccess(numEntities, isValid);
    }

    public static DoubleBufferAccess fromByteBuffer(ByteBuffer buffer, boolean isValid) {
        return new DoubleBufferAccess(buffer, isValid);
    }

    public DoubleBuffer getValues(AbstractDoubleArray<?> array) {
        return ((DoubleBuffer)this.buffer).duplicate().get(array.getCurrentStorageArray());
    }

    public DoubleBuffer getValues(AbstractDoubleArray<?> array, int offset, int length) {
        return ((DoubleBuffer)this.buffer).duplicate().get(array.getCurrentStorageArray(), offset, length);
    }

    public DoubleBuffer setValues(AbstractDoubleArray<?> array) {
        return ((DoubleBuffer)this.buffer).duplicate().put(array.getCurrentStorageArray());
    }

    public DoubleBuffer setValues(AbstractDoubleArray<?> array, int offset, int length) {
        return ((DoubleBuffer)this.buffer).duplicate().put(array.getCurrentStorageArray(), offset, length);
    }

    public DoubleBuffer setValues(DoubleBufferAccess access) {
        return ((DoubleBuffer)this.buffer).duplicate().put((DoubleBuffer)access.getCurrentStorageArray());
    }
}

