/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.cell;

import java.io.Serializable;
import net.imglib2.Interval;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.util.IntervalIndexer;
import net.imglib2.util.Intervals;

public class Cell<A>
implements Interval,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final int n;
    protected final int[] dimensions;
    protected final int[] steps;
    protected final long[] min;
    private final int numPixels;
    private final A data;

    public Cell(int[] dimensions, long[] min, A data) {
        this.n = dimensions.length;
        this.dimensions = (int[])dimensions.clone();
        this.steps = new int[this.n];
        IntervalIndexer.createAllocationSteps(dimensions, this.steps);
        this.min = (long[])min.clone();
        this.numPixels = (int)Intervals.numElements(dimensions);
        this.data = data;
    }

    public Cell(CellGrid.CellDimensionsAndSteps dims, long[] min, A data) {
        this.n = dims.dimensions().length;
        this.dimensions = dims.dimensions();
        this.steps = dims.steps();
        this.min = min;
        this.numPixels = dims.numPixels();
        this.data = data;
    }

    public A getData() {
        return this.data;
    }

    public long size() {
        return this.numPixels;
    }

    public long indexToGlobalPosition(int index, int d) {
        return (long)IntervalIndexer.indexToPosition(index, this.dimensions, this.steps, d) + this.min[d];
    }

    public void indexToGlobalPosition(int index, long[] position) {
        IntervalIndexer.indexToPosition(index, this.dimensions, position);
        for (int d = 0; d < position.length; ++d) {
            int n = d;
            position[n] = position[n] + this.min[d];
        }
    }

    public int globalPositionToIndex(long[] position) {
        return IntervalIndexer.positionWithOffsetToIndex(position, this.dimensions, this.min);
    }

    @Override
    public int numDimensions() {
        return this.n;
    }

    @Override
    public long min(int d) {
        return this.min[d];
    }

    @Override
    public long max(int d) {
        return this.min[d] + (long)this.dimensions[d] - 1L;
    }

    @Override
    public long dimension(int d) {
        return this.dimensions[d];
    }

    public void dimensions(int[] dim) {
        for (int d = 0; d < this.n; ++d) {
            dim[d] = this.dimensions[d];
        }
    }
}

