/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.planar;

import net.imglib2.AbstractLocalizingCursorInt;
import net.imglib2.Interval;
import net.imglib2.img.planar.PlanarImg;
import net.imglib2.type.Index;
import net.imglib2.type.NativeType;

public class PlanarPlaneSubsetLocalizingCursor<T extends NativeType<T>>
extends AbstractLocalizingCursorInt<T>
implements PlanarImg.PlanarContainerSampler {
    private final T type;
    private final Index typeIndex;
    private final PlanarImg<T, ?> container;
    private final int sliceIndex;
    private final int lastIndexPlane;
    private final int maxX;
    private final int dimX;

    protected PlanarPlaneSubsetLocalizingCursor(PlanarPlaneSubsetLocalizingCursor<T> cursor) {
        super(cursor.numDimensions());
        this.container = cursor.container;
        this.type = this.container.createLinkedType();
        this.typeIndex = this.type.index();
        this.sliceIndex = cursor.sliceIndex;
        this.lastIndexPlane = cursor.lastIndexPlane;
        this.maxX = cursor.maxX;
        this.dimX = cursor.dimX;
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = cursor.position[d];
        }
        this.type.updateContainer(this);
        this.typeIndex.set(cursor.typeIndex.get());
    }

    public PlanarPlaneSubsetLocalizingCursor(PlanarImg<T, ?> container, Interval interval) {
        super(container.numDimensions());
        this.type = container.createLinkedType();
        this.typeIndex = this.type.index();
        this.container = container;
        int planeSize = (this.n > 1 ? (int)interval.dimension(1) : 1) * (int)interval.dimension(0);
        this.lastIndexPlane = planeSize - 1;
        this.sliceIndex = (int)(this.offset(interval) / (long)planeSize);
        this.maxX = (int)interval.max(0);
        this.dimX = (int)container.dimension(0);
        this.type.updateContainer(this);
        for (int d = 2; d < this.n; ++d) {
            this.position[d] = (int)interval.min(d);
        }
        this.reset();
    }

    @Override
    public final int getCurrentSliceIndex() {
        return this.sliceIndex;
    }

    @Override
    public final T get() {
        return this.type;
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    public PlanarPlaneSubsetLocalizingCursor<T> copy() {
        return new PlanarPlaneSubsetLocalizingCursor<T>(this);
    }

    @Override
    public final boolean hasNext() {
        return this.typeIndex.get() < this.lastIndexPlane;
    }

    @Override
    public final void fwd() {
        this.typeIndex.inc();
        this.position[0] = this.position[0] + 1;
        if (this.position[0] > this.maxX && this.n > 1) {
            this.position[0] = 0;
            this.position[1] = this.position[1] + 1;
        }
    }

    @Override
    public final void jumpFwd(long steps) {
        this.typeIndex.inc((int)steps);
        this.updatePositionFromIndex(this.typeIndex.get());
    }

    private void updatePositionFromIndex(int index) {
        if (this.n == 1) {
            this.position[0] = index;
        } else {
            int j = index / this.dimX;
            this.position[0] = index - j * this.dimX;
            this.position[1] = j;
        }
    }

    @Override
    public final void reset() {
        this.typeIndex.set(-1);
        this.updatePositionFromIndex(this.typeIndex.get());
    }

    public String toString() {
        return this.type.toString();
    }

    private long offset(Interval interval) {
        int maxDim = this.numDimensions() - 1;
        long i = interval.min(maxDim);
        for (int d = maxDim - 1; d >= 0; --d) {
            i = i * this.container.dimension(d) + interval.min(d);
        }
        return i;
    }
}

