/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.interpolation.randomaccess;

import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.interpolation.randomaccess.NLinearInterpolator;
import net.imglib2.type.numeric.RealType;

public class ClampingNLinearInterpolatorRealType<T extends RealType<T>>
extends NLinearInterpolator<T> {
    protected double acc;
    protected final double clampMin;
    protected final double clampMax;

    protected ClampingNLinearInterpolatorRealType(ClampingNLinearInterpolatorRealType<T> interpolator) {
        super(interpolator);
        this.clampMin = interpolator.clampMin;
        this.clampMax = interpolator.clampMax;
    }

    protected ClampingNLinearInterpolatorRealType(RandomAccessible<T> randomAccessible, T type) {
        super(randomAccessible, type);
        this.clampMin = type.getMinValue();
        this.clampMax = type.getMaxValue();
    }

    protected ClampingNLinearInterpolatorRealType(RandomAccessible<T> randomAccessible) {
        this(randomAccessible, (RealType)randomAccessible.randomAccess().get());
    }

    @Override
    public T get() {
        this.fillWeights();
        this.acc = ((RealType)((RandomAccess)this.target).get()).getRealDouble() * this.weights[0];
        this.code = 0;
        this.graycodeFwdRecursive(this.n - 1);
        ((RandomAccess)this.target).bck(this.n - 1);
        ((RealType)this.accumulator).setReal(Math.max(this.clampMin, Math.min(this.clampMax, this.acc)));
        return (T)((RealType)this.accumulator);
    }

    @Override
    public ClampingNLinearInterpolatorRealType<T> copy() {
        return new ClampingNLinearInterpolatorRealType<T>(this);
    }

    private final void graycodeFwdRecursive(int dimension) {
        if (dimension == 0) {
            ((RandomAccess)this.target).fwd(0);
            ++this.code;
            this.accumulate();
        } else {
            this.graycodeFwdRecursive(dimension - 1);
            ((RandomAccess)this.target).fwd(dimension);
            this.code += 1 << dimension;
            this.accumulate();
            this.graycodeBckRecursive(dimension - 1);
        }
    }

    private final void graycodeBckRecursive(int dimension) {
        if (dimension == 0) {
            ((RandomAccess)this.target).bck(0);
            --this.code;
            this.accumulate();
        } else {
            this.graycodeFwdRecursive(dimension - 1);
            ((RandomAccess)this.target).bck(dimension);
            this.code -= 1 << dimension;
            this.accumulate();
            this.graycodeBckRecursive(dimension - 1);
        }
    }

    private final void accumulate() {
        this.acc += ((RealType)((RandomAccess)this.target).get()).getRealDouble() * this.weights[this.code];
    }
}

