/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.kdtree;

import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.img.Img;
import net.imglib2.img.list.ListImg;
import net.imglib2.kdtree.KDTreePositions;
import net.imglib2.kdtree.KDTreeUtils;
import net.imglib2.type.NativeType;
import net.imglib2.util.Util;

public class KDTreeData<T> {
    private final KDTreePositions positions;
    private final RandomAccessibleInterval<T> valuesImg;
    private final Supplier<IntFunction<T>> valuesSupplier;
    private final T type;
    private volatile RealInterval boundingBox;

    public KDTreeData(KDTreePositions positions, List<T> values) {
        this.positions = positions;
        this.valuesImg = ListImg.wrap(values, this.positions().numPoints());
        this.valuesSupplier = () -> values::get;
        this.type = KDTreeUtils.getType(values);
    }

    public KDTreeData(KDTreePositions positions, List<T> values, RealInterval boundingBox) {
        this(positions, values);
        this.boundingBox = boundingBox;
    }

    public KDTreeData(KDTreePositions positions, RandomAccessibleInterval<T> values) {
        this.positions = positions;
        this.valuesImg = values;
        this.valuesSupplier = () -> arg_0 -> KDTreeData.lambda$null$1(this.valuesImg.randomAccess(), arg_0);
        this.type = Util.getTypeFromInterval(values);
    }

    public KDTreeData(KDTreePositions positions, RandomAccessibleInterval<T> values, RealInterval boundingBox) {
        this(positions, values);
        this.boundingBox = boundingBox;
    }

    public KDTreePositions positions() {
        return this.positions;
    }

    public T getType() {
        return this.type;
    }

    public RandomAccessibleInterval<T> values() {
        return this.valuesImg;
    }

    public Supplier<IntFunction<T>> valuesSupplier() {
        return this.valuesSupplier;
    }

    public RealInterval boundingBox() {
        if (this.boundingBox == null) {
            this.boundingBox = this.positions().createBoundingBox();
        }
        return this.boundingBox;
    }

    public static <L extends RealLocalizable, T> KDTreeData<T> create(int numPoints, Iterable<T> values, Iterable<L> positions, boolean storeValuesAsNativeImg) {
        boolean storeAsImg;
        if (numPoints <= 0) {
            throw new IllegalArgumentException("At least one point is required to construct a KDTree.");
        }
        int numDimensions = KDTreeUtils.getNumDimensions(positions);
        double[][] points = KDTreeUtils.initPositions(numDimensions, numPoints, positions);
        int[] tree = KDTreeUtils.makeTree(points);
        int[] invtree = KDTreeUtils.invert(tree);
        boolean useFlatLayout = (long)numDimensions * (long)numPoints <= 0x7FFFFFF7L;
        KDTreePositions treePositions = useFlatLayout ? KDTreePositions.createFlat(KDTreeUtils.reorderToFlatLayout(points, tree), numDimensions) : KDTreePositions.createNested(KDTreeUtils.reorder(points, tree));
        boolean bl = storeAsImg = storeValuesAsNativeImg && KDTreeUtils.getType(values) instanceof NativeType;
        if (storeAsImg) {
            Img<T> treeValues = KDTreeUtils.orderValuesImg(invtree, values);
            return new KDTreeData<T>(treePositions, treeValues);
        }
        List<T> treeValues = KDTreeUtils.orderValuesList(invtree, values);
        return new KDTreeData<T>(treePositions, treeValues);
    }

    private static /* synthetic */ Object lambda$null$1(RandomAccess rec$, int xva$0) {
        return rec$.setPositionAndGet(xva$0);
    }
}

