/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.kdtree;

import net.imglib2.RealLocalizable;
import net.imglib2.kdtree.KDTreePositions;
import net.imglib2.kdtree.KDTreeUtils;

public class KDTreeImpl {
    private final int numDimensions;
    private final int numPoints;
    private final KDTreePositions positions;

    public KDTreeImpl(KDTreePositions positions) {
        this.numDimensions = positions.numDimensions;
        this.numPoints = positions.numPoints;
        this.positions = positions;
    }

    public int root() {
        return 0;
    }

    public int left(int i) {
        return this.ifExists(KDTreeUtils.leftChildIndex(i));
    }

    public int right(int i) {
        return this.ifExists(KDTreeUtils.rightChildIndex(i));
    }

    public int parent(int i) {
        return i == this.root() ? -1 : KDTreeUtils.parentIndex(i);
    }

    private int ifExists(int i) {
        return i < this.numPoints ? i : -1;
    }

    public int splitDimension(int i) {
        return (31 - Integer.numberOfLeadingZeros(i + 1)) % this.numDimensions;
    }

    public double getDoublePosition(int i, int d) {
        return this.positions.get(i, d);
    }

    public float squDistance(int i, float[] pos) {
        float sum = 0.0f;
        for (int d = 0; d < this.numDimensions; ++d) {
            float diff = pos[d] - (float)this.positions.get(i, d);
            sum += diff * diff;
        }
        return sum;
    }

    public double squDistance(int i, double[] pos) {
        double sum = 0.0;
        for (int d = 0; d < this.numDimensions; ++d) {
            double diff = pos[d] - this.positions.get(i, d);
            sum += diff * diff;
        }
        return sum;
    }

    public double squDistance(int i, RealLocalizable pos) {
        double sum = 0.0;
        for (int d = 0; d < this.numDimensions; ++d) {
            double diff = pos.getDoublePosition(d) - this.positions.get(i, d);
            sum += diff * diff;
        }
        return sum;
    }

    public int numDimensions() {
        return this.numDimensions;
    }

    public int size() {
        return this.numPoints;
    }

    public int depth() {
        return 32 - Integer.numberOfLeadingZeros(this.numPoints);
    }
}

