/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.kdtree;

import java.util.Arrays;
import net.imglib2.RealLocalizable;
import net.imglib2.kdtree.KDTreeImpl;

public class KNearestNeighborSearchImpl {
    private final KDTreeImpl tree;
    private final int numDimensions;
    private final int numPoints;
    private final double[] pos;
    private final int k;
    private final double[] bestSquDistance;
    private final int[] bestIndex;
    private final double[] axisDiffs;
    private final int[] awayChilds;

    public KNearestNeighborSearchImpl(KDTreeImpl tree, int k) {
        this.tree = tree;
        this.numDimensions = tree.numDimensions();
        this.numPoints = tree.size();
        this.k = k;
        this.pos = new double[this.numDimensions];
        this.bestSquDistance = new double[k];
        this.bestIndex = new int[k];
        int depth = tree.depth();
        this.axisDiffs = new double[depth + 1];
        this.awayChilds = new int[depth + 1];
    }

    private void insert(double squDistance, int index) {
        if (squDistance < this.bestSquDistance[this.k - 1]) {
            for (int i = this.k - 1; i > 0 && squDistance < this.bestSquDistance[i - 1]; --i) {
                this.bestSquDistance[i] = this.bestSquDistance[i - 1];
                this.bestIndex[i] = this.bestIndex[i - 1];
            }
            this.bestSquDistance[i] = squDistance;
            this.bestIndex[i] = index;
        }
    }

    public void search(RealLocalizable p) {
        p.localize(this.pos);
        int current = this.tree.root();
        int depth = 0;
        Arrays.fill(this.bestSquDistance, Double.POSITIVE_INFINITY);
        Arrays.fill(this.bestIndex, -1);
        while (true) {
            this.insert(this.tree.squDistance(current, this.pos), current);
            int d = depth % this.numDimensions;
            double axisDiff = this.pos[d] - this.tree.getDoublePosition(current, d);
            boolean leftIsNearBranch = axisDiff < 0.0;
            int nearChild = 2 * current + (leftIsNearBranch ? 1 : 2);
            int awayChild = 2 * current + (leftIsNearBranch ? 2 : 1);
            this.awayChilds[++depth] = awayChild;
            this.axisDiffs[depth] = axisDiff * axisDiff;
            if (nearChild >= this.numPoints) {
                while (this.awayChilds[depth] >= this.numPoints || this.axisDiffs[depth] > this.bestSquDistance[this.k - 1]) {
                    if (--depth != 0) continue;
                    return;
                }
                current = this.awayChilds[depth];
                this.awayChilds[depth] = this.numPoints;
                continue;
            }
            current = nearChild;
        }
    }

    public int k() {
        return this.k;
    }

    public int bestIndex(int i) {
        return this.bestIndex[i];
    }

    public double bestSquDistance(int i) {
        return this.bestSquDistance[i];
    }

    public KNearestNeighborSearchImpl copy() {
        KNearestNeighborSearchImpl copy = new KNearestNeighborSearchImpl(this.tree, this.k);
        System.arraycopy(this.pos, 0, copy.pos, 0, this.pos.length);
        System.arraycopy(this.bestIndex, 0, copy.bestIndex, 0, this.bestIndex.length);
        System.arraycopy(this.bestSquDistance, 0, copy.bestSquDistance, 0, this.bestSquDistance.length);
        return copy;
    }
}

