/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.outofbounds;

import net.imglib2.AbstractLocalizable;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.outofbounds.OutOfBounds;
import net.imglib2.util.Util;

public class OutOfBoundsBorder<T>
extends AbstractLocalizable
implements OutOfBounds<T> {
    protected final RandomAccess<T> outOfBoundsRandomAccess;
    protected final long[] min = new long[this.n];
    protected final long[] beforeMin;
    protected final long[] max;
    protected final long[] pastMax;
    protected final boolean[] dimIsOutOfBounds;
    protected boolean isOutOfBounds = false;

    public OutOfBoundsBorder(OutOfBoundsBorder<T> outOfBounds) {
        super(outOfBounds.numDimensions());
        this.beforeMin = new long[this.n];
        this.max = new long[this.n];
        this.pastMax = new long[this.n];
        this.dimIsOutOfBounds = new boolean[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.min[d] = outOfBounds.min[d];
            this.beforeMin[d] = outOfBounds.beforeMin[d];
            this.max[d] = outOfBounds.max[d];
            this.pastMax[d] = outOfBounds.pastMax[d];
            this.position[d] = outOfBounds.position[d];
            this.dimIsOutOfBounds[d] = outOfBounds.dimIsOutOfBounds[d];
        }
        this.outOfBoundsRandomAccess = outOfBounds.outOfBoundsRandomAccess.copy();
    }

    public <F extends Interval & RandomAccessible<T>> OutOfBoundsBorder(F f) {
        super(f.numDimensions());
        f.min(this.min);
        this.max = new long[this.n];
        f.max(this.max);
        this.beforeMin = new long[this.n];
        this.pastMax = new long[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.beforeMin[d] = this.min[d] - 1L;
            this.pastMax[d] = this.max[d] + 1L;
        }
        this.dimIsOutOfBounds = new boolean[this.n];
        this.outOfBoundsRandomAccess = ((RandomAccessible<T>)f).randomAccess();
    }

    protected final void checkOutOfBounds() {
        for (int d = 0; d < this.n; ++d) {
            if (!this.dimIsOutOfBounds[d]) continue;
            this.isOutOfBounds = true;
            return;
        }
        this.isOutOfBounds = false;
    }

    @Override
    public boolean isOutOfBounds() {
        return this.isOutOfBounds;
    }

    @Override
    public T get() {
        return this.outOfBoundsRandomAccess.get();
    }

    @Override
    public T getType() {
        return this.outOfBoundsRandomAccess.getType();
    }

    @Override
    public final OutOfBoundsBorder<T> copy() {
        return new OutOfBoundsBorder<T>(this);
    }

    @Override
    public final void fwd(int d) {
        int n = d;
        this.position[n] = this.position[n] + 1L;
        long p = this.position[n];
        if (p == this.min[d]) {
            this.dimIsOutOfBounds[d] = false;
            this.checkOutOfBounds();
        } else if (p == this.pastMax[d]) {
            this.isOutOfBounds = true;
            this.dimIsOutOfBounds[d] = true;
        } else if (!this.dimIsOutOfBounds[d]) {
            this.outOfBoundsRandomAccess.fwd(d);
        }
    }

    @Override
    public final void bck(int d) {
        int n = d;
        this.position[n] = this.position[n] - 1L;
        long p = this.position[n];
        if (p == this.beforeMin[d]) {
            this.isOutOfBounds = true;
            this.dimIsOutOfBounds[d] = true;
        } else if (p == this.max[d]) {
            this.dimIsOutOfBounds[d] = false;
            this.checkOutOfBounds();
        } else if (!this.dimIsOutOfBounds[d]) {
            this.outOfBoundsRandomAccess.bck(d);
        }
    }

    @Override
    public final void setPosition(long position, int d) {
        this.position[d] = position;
        long minD = this.min[d];
        long maxD = this.max[d];
        if (position < minD) {
            this.outOfBoundsRandomAccess.setPosition(minD, d);
            this.isOutOfBounds = true;
            this.dimIsOutOfBounds[d] = true;
        } else if (position > maxD) {
            this.outOfBoundsRandomAccess.setPosition(maxD, d);
            this.isOutOfBounds = true;
            this.dimIsOutOfBounds[d] = true;
        } else {
            this.outOfBoundsRandomAccess.setPosition(position, d);
            if (this.isOutOfBounds) {
                this.dimIsOutOfBounds[d] = false;
                this.checkOutOfBounds();
            }
        }
    }

    @Override
    public void move(long distance, int d) {
        this.setPosition(this.getLongPosition(d) + distance, d);
    }

    @Override
    public void move(int distance, int d) {
        this.move((long)distance, d);
    }

    @Override
    public void move(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            this.move(localizable.getLongPosition(d), d);
        }
    }

    @Override
    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            this.move(distance[d], d);
        }
    }

    @Override
    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            this.move(distance[d], d);
        }
    }

    @Override
    public void setPosition(int position, int d) {
        this.setPosition((long)position, d);
    }

    @Override
    public void setPosition(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            this.setPosition(localizable.getLongPosition(d), d);
        }
    }

    @Override
    public void setPosition(int[] position) {
        for (int d = 0; d < position.length; ++d) {
            this.setPosition(position[d], d);
        }
    }

    @Override
    public void setPosition(long[] position) {
        for (int d = 0; d < position.length; ++d) {
            this.setPosition(position[d], d);
        }
    }

    public String toString() {
        return Util.printCoordinates(this.position) + " = " + this.get();
    }
}

