/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.parallel;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import net.imglib2.parallel.SequentialExecutorService;
import net.imglib2.parallel.TaskExecutor;

class SequentialTaskExecutor
implements TaskExecutor {
    private static final SequentialTaskExecutor INSTANCE = new SequentialTaskExecutor();
    private final ExecutorService executorService = new SequentialExecutorService();

    private SequentialTaskExecutor() {
    }

    public static TaskExecutor getInstance() {
        return INSTANCE;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public int suggestNumberOfTasks() {
        return 1;
    }

    @Override
    public int getParallelism() {
        return 1;
    }

    @Override
    public void runAll(List<Runnable> tasks) {
        for (Runnable task : tasks) {
            task.run();
        }
    }

    @Override
    public <T> void forEach(List<? extends T> parameters, Consumer<? super T> task) {
        for (T value : parameters) {
            task.accept(value);
        }
    }

    @Override
    public <T, R> List<R> forEachApply(List<? extends T> parameters, Function<? super T, ? extends R> task) {
        ArrayList<R> results = new ArrayList<R>(parameters.size());
        for (T value : parameters) {
            R result = task.apply(value);
            results.add(result);
        }
        return results;
    }

    @Override
    public void close() {
    }
}

