/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.transform.integer;

import net.imglib2.transform.integer.BoundingBox;
import net.imglib2.transform.integer.Mixed;

public abstract class AbstractMixedTransform
implements Mixed {
    protected final int numTargetDimensions;

    protected AbstractMixedTransform(int numTargetDimensions) {
        this.numTargetDimensions = numTargetDimensions;
    }

    @Override
    public int numSourceDimensions() {
        return this.numTargetDimensions;
    }

    @Override
    public int numTargetDimensions() {
        return this.numTargetDimensions;
    }

    @Override
    public void getTranslation(long[] translation) {
        assert (translation.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            translation[d] = 0L;
        }
    }

    @Override
    public long getTranslation(int d) {
        return 0L;
    }

    @Override
    public void getComponentZero(boolean[] zero) {
        assert (zero.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            zero[d] = false;
        }
    }

    @Override
    public boolean getComponentZero(int d) {
        return false;
    }

    @Override
    public void getComponentMapping(int[] component) {
        assert (component.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            component[d] = d;
        }
    }

    @Override
    public int getComponentMapping(int d) {
        return d;
    }

    @Override
    public void getComponentInversion(boolean[] invert) {
        assert (invert.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            invert[d] = false;
        }
    }

    @Override
    public boolean getComponentInversion(int d) {
        return false;
    }

    @Override
    public BoundingBox transform(BoundingBox boundingBox) {
        assert (boundingBox.numDimensions() == this.numSourceDimensions());
        if (this.numSourceDimensions() == this.numTargetDimensions) {
            long[] tmp = new long[this.numTargetDimensions];
            boundingBox.corner1(tmp);
            this.apply(tmp, boundingBox.corner1);
            boundingBox.corner2(tmp);
            this.apply(tmp, boundingBox.corner2);
            return boundingBox;
        }
        BoundingBox b = new BoundingBox(this.numTargetDimensions);
        this.apply(boundingBox.corner1, b.corner1);
        this.apply(boundingBox.corner2, b.corner2);
        return b;
    }
}

