/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import java.math.BigInteger;
import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.LongAccess;
import net.imglib2.type.AbstractBit64Type;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import net.imglib2.util.Util;

public class UnsignedVariableBitLengthType
extends AbstractBit64Type<UnsignedVariableBitLengthType>
implements IntegerType<UnsignedVariableBitLengthType> {
    private final NativeTypeFactory<UnsignedVariableBitLengthType, LongAccess> typeFactory = NativeTypeFactory.LONG(img -> new UnsignedVariableBitLengthType((NativeImg<?, ? extends LongAccess>)img, this.nBits));

    public UnsignedVariableBitLengthType(NativeImg<?, ? extends LongAccess> bitStorage, int nBits) {
        super(bitStorage, nBits);
    }

    public UnsignedVariableBitLengthType(long value, int nBits) {
        super(value, nBits);
    }

    public UnsignedVariableBitLengthType(LongAccess access, int nBits) {
        super(access, nBits);
    }

    public UnsignedVariableBitLengthType(int nBits) {
        super(nBits);
    }

    @Override
    public void set(long value) {
        this.setBits(value);
    }

    public long get() {
        return this.getBits();
    }

    @Override
    public void set(UnsignedVariableBitLengthType c) {
        this.setBits(c.getBits());
    }

    @Override
    public UnsignedVariableBitLengthType duplicateTypeOnSameNativeImg() {
        return new UnsignedVariableBitLengthType(this.img, this.nBits);
    }

    @Override
    public NativeTypeFactory<UnsignedVariableBitLengthType, LongAccess> getNativeTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public UnsignedVariableBitLengthType createVariable() {
        return new UnsignedVariableBitLengthType(this.nBits);
    }

    @Override
    public UnsignedVariableBitLengthType copy() {
        if (this.dataAccess != null) {
            return new UnsignedVariableBitLengthType(this.getBits(), this.nBits);
        }
        return this.createVariable();
    }

    @Override
    public void div(UnsignedVariableBitLengthType t) {
        this.setBits(UnsignedLongType.divide(this.getBits(), t.getBits()));
    }

    @Override
    public void mul(float c) {
        this.setReal(this.getRealDouble() * (double)c);
    }

    @Override
    public void mul(double c) {
        this.setReal(this.getRealDouble() * c);
    }

    @Override
    public float getRealFloat() {
        return this.getIntegerLong();
    }

    @Override
    public double getRealDouble() {
        return this.getIntegerLong();
    }

    @Override
    public void setReal(float real) {
        this.setInteger(Util.round(real));
    }

    @Override
    public void setReal(double real) {
        this.setInteger(Util.round(real));
    }

    @Override
    public void setZero() {
        this.setInteger(0);
    }

    @Override
    public void setOne() {
        this.setInteger(1);
    }

    @Override
    public int getBitsPerPixel() {
        return this.nBits;
    }

    @Override
    public double getMinIncrement() {
        return 1.0;
    }

    public String toString() {
        return "" + this.getIntegerLong();
    }

    @Override
    public int getInteger() {
        return (int)this.get();
    }

    @Override
    public long getIntegerLong() {
        return this.get();
    }

    @Override
    public BigInteger getBigInteger() {
        if (this.get() < 0L) {
            return BigInteger.valueOf(this.get()).add(new BigInteger("2", 10).pow(this.nBits));
        }
        return BigInteger.valueOf(this.get());
    }

    @Override
    public void setInteger(int f) {
        this.setBits(f);
    }

    @Override
    public void setInteger(long f) {
        this.setBits(f);
    }

    @Override
    public void setBigInteger(BigInteger b) {
        this.setBits(b.longValue());
    }

    @Override
    public double getMaxValue() {
        return Math.pow(2.0, this.getBitsPerPixel()) - 1.0;
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public void inc() {
        this.setBits(this.get() + 1L);
    }

    @Override
    public void dec() {
        this.set(this.get() - 1L);
    }

    @Override
    public void add(UnsignedVariableBitLengthType t) {
        this.set(this.get() + t.get());
    }

    @Override
    public void sub(UnsignedVariableBitLengthType t) {
        this.set(this.get() - t.get());
    }

    @Override
    public void mul(UnsignedVariableBitLengthType t) {
        this.set(this.get() * t.get());
    }

    @Override
    public void pow(UnsignedVariableBitLengthType c) {
        this.setReal(Math.pow(this.get(), c.get()));
    }

    @Override
    public void pow(double power) {
        this.setReal(Math.pow(this.get(), power));
    }

    @Override
    public float getImaginaryFloat() {
        return 0.0f;
    }

    @Override
    public double getImaginaryDouble() {
        return 0.0;
    }

    @Override
    public void setImaginary(float complex) {
    }

    @Override
    public void setImaginary(double complex) {
    }

    @Override
    public float getPhaseFloat() {
        return 0.0f;
    }

    @Override
    public double getPhaseDouble() {
        return 0.0;
    }

    @Override
    public float getPowerFloat() {
        return this.getRealFloat();
    }

    @Override
    public double getPowerDouble() {
        return this.getRealDouble();
    }

    @Override
    public void setComplexNumber(float r, float i) {
        this.setReal(r);
    }

    @Override
    public void setComplexNumber(double r, double i) {
        this.setReal(r);
    }

    @Override
    public void complexConjugate() {
    }

    @Override
    public int compareTo(UnsignedVariableBitLengthType t) {
        return Long.compareUnsigned(this.getBits(), t.getBits());
    }

    @Override
    public boolean valueEquals(UnsignedVariableBitLengthType t) {
        return this.getBits() == t.getBits();
    }

    public boolean equals(Object obj) {
        return Util.valueEqualsObject(this, obj);
    }

    public int hashCode() {
        return Long.hashCode(this.getBits());
    }
}

