/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.real;

import net.imglib2.img.NativeImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.basictypeaccess.DoubleAccess;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.type.Index;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.type.numeric.real.AbstractRealType;
import net.imglib2.util.Fraction;
import net.imglib2.view.Views;
import net.imglib2.view.composite.RealComposite;

public class DoubleType
extends AbstractRealType<DoubleType>
implements NativeType<DoubleType> {
    private final Index i = new Index();
    protected final NativeImg<?, ? extends DoubleAccess> img;
    protected DoubleAccess dataAccess;
    private static final NativeTypeFactory<DoubleType, DoubleAccess> typeFactory = NativeTypeFactory.DOUBLE(DoubleType::new);

    public DoubleType(NativeImg<?, ? extends DoubleAccess> doubleStorage) {
        this.img = doubleStorage;
    }

    public DoubleType(double value) {
        this.img = null;
        this.dataAccess = new DoubleArray(1);
        this.set(value);
    }

    public DoubleType(DoubleAccess access) {
        this.img = null;
        this.dataAccess = access;
    }

    public DoubleType() {
        this(0.0);
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    @Override
    public Index index() {
        return this.i;
    }

    @Override
    public DoubleType duplicateTypeOnSameNativeImg() {
        return new DoubleType(this.img);
    }

    @Override
    public NativeTypeFactory<DoubleType, DoubleAccess> getNativeTypeFactory() {
        return typeFactory;
    }

    public double get() {
        return this.dataAccess.getValue(this.i.get());
    }

    @Override
    public void set(double f) {
        this.dataAccess.setValue(this.i.get(), f);
    }

    @Override
    public float getRealFloat() {
        return (float)this.get();
    }

    @Override
    public double getRealDouble() {
        return this.get();
    }

    @Override
    public void setReal(float real) {
        this.set(real);
    }

    @Override
    public void setReal(double real) {
        this.set(real);
    }

    @Override
    public double getMaxValue() {
        return Double.MAX_VALUE;
    }

    @Override
    public double getMinValue() {
        return -1.7976931348623157E308;
    }

    @Override
    public double getMinIncrement() {
        return Double.MIN_VALUE;
    }

    @Override
    public DoubleType createVariable() {
        return new DoubleType(0.0);
    }

    @Override
    public DoubleType copy() {
        return new DoubleType(this.dataAccess != null ? this.get() : 0.0);
    }

    @Override
    public Fraction getEntitiesPerPixel() {
        return new Fraction();
    }

    @Override
    public int getBitsPerPixel() {
        return 64;
    }

    public static boolean equals(double a, double b) {
        return Double.doubleToLongBits(a) == Double.doubleToLongBits(b);
    }

    public static RealComposite<DoubleType> createVector(int n) {
        return (RealComposite)Views.collapseReal(ArrayImgs.doubles(n)).randomAccess().get();
    }

    public static RealComposite<DoubleType> wrapVector(double[] array) {
        return (RealComposite)Views.collapseReal(ArrayImgs.doubles(array, new long[]{array.length})).randomAccess().get();
    }
}

