/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view.fluent;

import java.util.function.Function;
import java.util.function.Supplier;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.outofbounds.OutOfBoundsBorderFactory;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.outofbounds.OutOfBoundsPeriodicFactory;
import net.imglib2.outofbounds.OutOfBoundsZeroFactory;
import net.imglib2.stream.LocalizableSpliterator;
import net.imglib2.type.Type;
import net.imglib2.type.operators.SetZero;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import net.imglib2.view.fluent.RandomAccessibleView;

public interface RandomAccessibleIntervalView<T>
extends RandomAccessibleView<T, RandomAccessibleIntervalView<T>>,
RandomAccessibleInterval<T> {
    @Override
    public RandomAccessibleInterval<T> delegate();

    public static <T> RandomAccessibleIntervalView<T> wrap(RandomAccessibleInterval<T> delegate) {
        return () -> delegate;
    }

    default public RandomAccessibleIntervalView<T> flatIterable() {
        return RandomAccessibleIntervalView.wrap(Views.flatIterable(this.delegate()));
    }

    default public RandomAccessibleIntervalView<T> slice(int d, long pos) {
        return RandomAccessibleIntervalView.wrap(Views.hyperSlice(this.delegate(), d, pos));
    }

    default public RandomAccessibleIntervalView<T> addDimension(long minOfNewDim, long maxOfNewDim) {
        return RandomAccessibleIntervalView.wrap(Views.addDimension(this.delegate(), minOfNewDim, maxOfNewDim));
    }

    default public RandomAccessibleIntervalView<T> translate(long ... translation) {
        return RandomAccessibleIntervalView.wrap(Views.translate(this.delegate(), translation));
    }

    default public RandomAccessibleIntervalView<T> translateInverse(long ... translation) {
        return RandomAccessibleIntervalView.wrap(Views.translateInverse(this.delegate(), translation));
    }

    default public RandomAccessibleIntervalView<T> zeroMin() {
        return RandomAccessibleIntervalView.wrap(Views.zeroMin(this.delegate()));
    }

    default public RandomAccessibleIntervalView<T> subsample(long ... steps) {
        return RandomAccessibleIntervalView.wrap(Views.subsample(this.delegate(), Util.expandArray(steps, this.numDimensions())));
    }

    default public RandomAccessibleIntervalView<T> rotate(int fromAxis, int toAxis) {
        return RandomAccessibleIntervalView.wrap(Views.rotate(this.delegate(), fromAxis, toAxis));
    }

    default public RandomAccessibleIntervalView<T> permute(int fromAxis, int toAxis) {
        return RandomAccessibleIntervalView.wrap(Views.permute(this.delegate(), fromAxis, toAxis));
    }

    default public RandomAccessibleIntervalView<T> moveAxis(int fromAxis, int toAxis) {
        return RandomAccessibleIntervalView.wrap(Views.moveAxis(this.delegate(), fromAxis, toAxis));
    }

    default public RandomAccessibleIntervalView<T> invertAxis(int axis) {
        return RandomAccessibleIntervalView.wrap(Views.invertAxis(this.delegate(), axis));
    }

    default public RandomAccessibleView<T, ?> extend(Extension<T> extension) {
        return RandomAccessibleView.wrap(Views.extend(this, extension.factory));
    }

    default public RandomAccessibleIntervalView<T> expand(Extension<T> extension, long ... border) {
        return RandomAccessibleIntervalView.wrap(Views.expand(this, extension.factory, Util.expandArray(border, this.numDimensions())));
    }

    default public <U> RandomAccessibleIntervalView<U> convert(Supplier<U> targetSupplier, Converter<? super T, ? super U> converter) {
        return RandomAccessibleIntervalView.wrap(Converters.convert2(this.delegate(), converter, targetSupplier));
    }

    default public <U> RandomAccessibleIntervalView<U> convert(Supplier<U> targetSupplier, Supplier<Converter<? super T, ? super U>> converterSupplier) {
        return RandomAccessibleIntervalView.wrap(Converters.convert2(this.delegate(), converterSupplier, targetSupplier));
    }

    @Override
    default public <U> U use(Function<? super RandomAccessibleIntervalView<T>, U> function) {
        return function.apply(this);
    }

    @Override
    default public RandomAccessibleIntervalView<T> view() {
        return this;
    }

    @Override
    default public T getType() {
        return this.delegate().getType();
    }

    @Override
    default public long min(int d) {
        return this.delegate().min(d);
    }

    @Override
    default public long max(int d) {
        return this.delegate().max(d);
    }

    @Override
    default public long dimension(int d) {
        return this.delegate().dimension(d);
    }

    @Override
    default public Cursor<T> cursor() {
        return this.delegate().cursor();
    }

    @Override
    default public Cursor<T> localizingCursor() {
        return this.delegate().localizingCursor();
    }

    @Override
    default public LocalizableSpliterator<T> spliterator() {
        return this.delegate().spliterator();
    }

    @Override
    default public LocalizableSpliterator<T> localizingSpliterator() {
        return this.delegate().localizingSpliterator();
    }

    @Override
    default public long size() {
        return this.delegate().size();
    }

    @Override
    default public Object iterationOrder() {
        return this.delegate().iterationOrder();
    }

    public static class Extension<T> {
        final OutOfBoundsFactory<T, RandomAccessibleIntervalView<T>> factory;

        private Extension(OutOfBoundsFactory<T, RandomAccessibleIntervalView<T>> factory) {
            this.factory = factory;
        }

        public static <T> Extension<T> border() {
            return new Extension(new OutOfBoundsBorderFactory());
        }

        public static <T extends Type<T> & SetZero> Extension<T> zero() {
            return new Extension(new OutOfBoundsZeroFactory());
        }

        public static <T> Extension<T> value(T value) {
            return new Extension<T>(new OutOfBoundsConstantValueFactory(value));
        }

        public static <T> Extension<T> mirrorSingle() {
            return new Extension(new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE));
        }

        public static <T> Extension<T> mirrorDouble() {
            return new Extension(new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.DOUBLE));
        }

        public static <T> Extension<T> periodic() {
            return new Extension(new OutOfBoundsPeriodicFactory());
        }
    }
}

