/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats.imaris;

import hdf.hdf5lib.H5;
import hdf.hdf5lib.HDF5Constants;
import hdf.hdf5lib.exceptions.HDF5Exception;
import hdf.hdf5lib.exceptions.HDF5LibraryException;
import java.io.UnsupportedEncodingException;
import javax.swing.JOptionPane;

public class HDFUtils {
    public static long[] createDataSet(long id, String name, long[] size, long l) throws HDF5LibraryException, HDF5Exception {
        long dataSpaceID = H5.H5Screate_simple((int)size.length, (long[])size, null);
        long dataTypeID = H5.H5Tcopy((long)l);
        H5.H5Tset_order((long)dataTypeID, (int)HDF5Constants.H5T_ORDER_LE);
        long dataSetID = H5.H5Dcreate((long)id, (String)name, (long)dataTypeID, (long)dataSpaceID, (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT);
        return new long[]{dataSpaceID, dataTypeID, dataSetID};
    }

    public static long[] createCompressedDataSet(long id, String name, long[] size, long l, long[] chunk) throws HDF5LibraryException, HDF5Exception {
        long dataSpaceID = H5.H5Screate_simple((int)size.length, (long[])size, null);
        long dataTypeID = H5.H5Tcopy((long)l);
        H5.H5Tset_order((long)dataTypeID, (int)HDF5Constants.H5T_ORDER_LE);
        long propListID = H5.H5Pcreate((long)HDF5Constants.H5P_DATASET_CREATE);
        H5.H5Pset_deflate((long)propListID, (int)2);
        H5.H5Pset_chunk((long)propListID, (int)chunk.length, (long[])chunk);
        long dataSetID = H5.H5Dcreate((long)id, (String)name, (long)dataTypeID, (long)dataSpaceID, (long)HDF5Constants.H5P_DEFAULT, (long)propListID, (long)HDF5Constants.H5P_DEFAULT);
        return new long[]{dataSpaceID, dataTypeID, dataSetID, propListID};
    }

    public static void writeStringAttribute(long id, String name, String value) throws HDF5LibraryException, HDF5Exception {
        long dataspaceID = H5.H5Screate_simple((int)1, (long[])new long[]{value.length()}, null);
        long attID = H5.H5Acreate((long)id, (String)name, (long)HDF5Constants.H5T_C_S1, (long)dataspaceID, (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT);
        try {
            H5.H5Awrite((long)attID, (long)HDF5Constants.H5T_C_S1, (byte[])value.getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException ex) {
            JOptionPane.showMessageDialog(null, "Can't encode string");
        }
        H5.H5Sclose((long)dataspaceID);
        H5.H5Aclose((long)attID);
    }
}

