/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.cache;

import java.util.ArrayDeque;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;

class PausableQueue<E> {
    private final ArrayDeque<E> elements;
    private final int capacity;
    private boolean paused;
    private final int numConsumers;
    private int waitCount;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;
    private final Condition isPaused;

    public PausableQueue(int capacity, int numConsumers, boolean fair) {
        this.capacity = capacity;
        this.numConsumers = numConsumers;
        this.elements = new ArrayDeque(capacity);
        this.lock = new ReentrantLock(fair);
        this.notEmpty = this.lock.newCondition();
        this.notFull = this.lock.newCondition();
        this.isPaused = this.lock.newCondition();
    }

    public void put(E e) throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.elements.size() >= this.capacity || this.paused) {
                this.notFull.await();
            }
            this.enqueue(e);
        }
        finally {
            lock.unlock();
        }
    }

    public void pause() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            if (!this.paused) {
                this.paused = true;
                while (this.waitCount != this.numConsumers) {
                    this.isPaused.await();
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void resume() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            if (this.paused) {
                this.paused = false;
                this.notFull.signalAll();
                this.notEmpty.signalAll();
            }
        }
        finally {
            lock.unlock();
        }
    }

    public E take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            if (++this.waitCount == this.numConsumers) {
                this.isPaused.signal();
            }
            while (this.elements.size() == 0 || this.paused) {
                this.notEmpty.await();
            }
            --this.waitCount;
            E e = this.dequeue();
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    private void enqueue(E x) {
        this.elements.offer(x);
        this.notEmpty.signal();
    }

    private E dequeue() {
        E x = this.elements.poll();
        this.notFull.signal();
        return x;
    }

    public void remove(E element) {
        this.elements.removeIf((? super E e) -> e.equals(element));
    }

    public void clear() {
        this.elements.clear();
    }

    public void removeIf(Predicate<E> condition) {
        this.elements.removeIf(condition::test);
    }
}

