/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.cache.ref;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.imglib2.cache.CacheLoader;
import net.imglib2.cache.CacheRemover;
import net.imglib2.cache.LoaderRemoverCache;

public class SoftRefLoaderRemoverCache<K, V, D>
implements LoaderRemoverCache<K, V, D> {
    final ConcurrentHashMap<K, Entry> map = new ConcurrentHashMap();
    final ReferenceQueue<V> queue = new ReferenceQueue();

    @Override
    public V getIfPresent(K key) {
        this.cleanUp();
        Entry entry = this.map.get(key);
        return entry == null ? null : (V)entry.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key, CacheLoader<? super K, ? extends V> loader, CacheRemover<? super K, V, D> remover) throws ExecutionException {
        this.cleanUp();
        Entry entry = this.map.computeIfAbsent(key, k -> new Entry(k));
        Object value = entry.getValue();
        if (value == null) {
            Entry entry2 = entry;
            synchronized (entry2) {
                if (entry.loaded) {
                    value = entry.getValue();
                    if (value == null) {
                        entry.remove();
                    }
                } else {
                    try {
                        value = loader.get(key);
                        entry.setValue(value, remover);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new ExecutionException(e);
                    }
                    catch (Exception e) {
                        throw new ExecutionException(e);
                    }
                }
            }
        }
        if (value == null) {
            value = this.get(key, loader, remover);
        }
        return value;
    }

    @Override
    public void persist(K key) {
        Entry entry = this.map.get(key);
        if (entry == null) {
            return;
        }
        Object value = entry.getValue();
        if (value == null) {
            return;
        }
        Object data = entry.remover.extract(value);
        entry.remover.persist(key, data).join();
    }

    @Override
    public void persistIf(Predicate<K> condition) {
        this.map.values().parallelStream().filter(entry -> condition.test(entry.key)).map(entry -> {
            Object value = entry.getValue();
            if (value == null) {
                return CompletableFuture.completedFuture(null);
            }
            Object data = ((Entry)entry).remover.extract(value);
            return ((Entry)entry).remover.persist(entry.key, data);
        }).collect(Collectors.toList()).forEach(CompletableFuture::join);
    }

    @Override
    public void persistAll() {
        this.map.values().parallelStream().map(entry -> {
            Object value = entry.getValue();
            if (value == null) {
                return CompletableFuture.completedFuture(null);
            }
            Object data = ((Entry)entry).remover.extract(value);
            return ((Entry)entry).remover.persist(entry.key, data);
        }).collect(Collectors.toList()).forEach(CompletableFuture::join);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(K key) {
        Entry entry = this.map.remove(key);
        if (entry != null) {
            Entry entry2 = entry;
            synchronized (entry2) {
                entry.phantomRef.clear();
                entry.phantomRef = null;
                entry.remover = null;
            }
        }
    }

    @Override
    public void invalidateIf(long parallelismThreshold, Predicate<K> condition) {
        this.map.forEachValue(parallelismThreshold, entry -> {
            if (condition.test(entry.key)) {
                Entry entry2 = entry;
                synchronized (entry2) {
                    this.map.remove(entry.key, entry);
                    ((Entry)entry).phantomRef.clear();
                    ((Entry)entry).phantomRef = null;
                    ((Entry)entry).remover = null;
                }
            }
        });
    }

    @Override
    public void invalidateAll(long parallelismThreshold) {
        this.map.forEachValue(parallelismThreshold, entry -> {
            Entry entry2 = entry;
            synchronized (entry2) {
                this.map.remove(entry.key, entry);
                ((Entry)entry).phantomRef.clear();
                ((Entry)entry).phantomRef = null;
                ((Entry)entry).remover = null;
            }
        });
    }

    public void cleanUp() {
        CachePhantomReference pr;
        while ((pr = (CachePhantomReference)this.queue.poll()) != null) {
            pr.entry.remove();
        }
    }

    final class Entry {
        final K key;
        private SoftReference<V> ref;
        private CachePhantomReference<V> phantomRef;
        private CacheRemover<? super K, V, D> remover;
        boolean loaded;
        private D valueData;

        public Entry(K key) {
            this.key = key;
            this.ref = new SoftReference<Object>(null);
            this.phantomRef = null;
            this.remover = null;
            this.loaded = false;
        }

        public V getValue() {
            return this.ref.get();
        }

        public void setValue(V value, CacheRemover<? super K, V, D> remover) {
            this.loaded = true;
            this.ref = new SoftReference(value);
            this.phantomRef = new CachePhantomReference(value, SoftRefLoaderRemoverCache.this.queue, this);
            this.remover = remover;
            this.valueData = remover.extract(value);
        }

        public synchronized void remove() {
            if (this.remover != null) {
                this.phantomRef.clear();
                this.phantomRef = null;
                this.remover.onRemoval(this.key, this.valueData);
                this.remover = null;
                this.valueData = null;
            }
            SoftRefLoaderRemoverCache.this.map.remove(this.key, this);
        }
    }

    static final class CachePhantomReference<V>
    extends PhantomReference<V> {
        final Entry entry;

        public CachePhantomReference(V referent, ReferenceQueue<V> remove, Entry entry) {
            super(referent, remove);
            this.entry = entry;
        }
    }
}

