/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.tools;

import net.imagej.ChannelCollection;
import net.imagej.Dataset;
import net.imagej.DrawingTool;
import net.imagej.display.ImageCanvas;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.event.DatasetUpdatedEvent;
import net.imagej.options.OptionsChannels;
import net.imagej.render.RenderingService;
import org.scijava.display.event.input.MsDraggedEvent;
import org.scijava.display.event.input.MsPressedEvent;
import org.scijava.display.event.input.MsReleasedEvent;
import org.scijava.event.EventService;
import org.scijava.event.SciJavaEvent;
import org.scijava.options.OptionsService;
import org.scijava.plugin.Parameter;
import org.scijava.tool.AbstractTool;
import org.scijava.util.IntCoords;
import org.scijava.util.RealCoords;

public abstract class AbstractLineTool
extends AbstractTool {
    @Parameter
    private ImageDisplayService imageDisplayService;
    @Parameter
    private OptionsService optionsService;
    @Parameter
    private RenderingService renderingService;
    @Parameter(required=false)
    private EventService eventService;
    private DrawingTool drawingTool;
    private long lineWidth = 1L;

    public void setLineWidth(long w) {
        this.lineWidth = w < 1L ? 1L : w;
    }

    public long getLineWidth() {
        return this.lineWidth;
    }

    public void onMouseDown(MsPressedEvent evt) {
        if (evt.getButton() != 0) {
            return;
        }
        if (!(evt.getDisplay() instanceof ImageDisplay)) {
            return;
        }
        this.initDrawingTool(evt);
        if (this.drawingTool != null) {
            ImageDisplay disp = (ImageDisplay)evt.getDisplay();
            ImageCanvas canv = disp.getCanvas();
            IntCoords panelCoords = new IntCoords(evt.getX(), evt.getY());
            RealCoords realCoords = canv.panelToDataCoords(panelCoords);
            long modelX = realCoords.getLongX();
            long modelY = realCoords.getLongY();
            this.drawingTool.moveTo(modelX, modelY);
        }
        evt.consume();
    }

    public void onMouseUp(MsReleasedEvent evt) {
        if (evt.getButton() != 0) {
            return;
        }
        if (this.drawingTool != null) {
            Dataset dataset = this.drawingTool.getDataset();
            if (this.eventService != null) {
                this.eventService.publish((SciJavaEvent)new DatasetUpdatedEvent(dataset, false));
            }
            this.drawingTool = null;
        }
        evt.consume();
    }

    public void onMouseDrag(MsDraggedEvent evt) {
        if (this.drawingTool == null) {
            return;
        }
        if (!(evt.getDisplay() instanceof ImageDisplay)) {
            return;
        }
        ImageDisplay disp = (ImageDisplay)evt.getDisplay();
        ImageCanvas canv = disp.getCanvas();
        IntCoords panelCoords = new IntCoords(evt.getX(), evt.getY());
        RealCoords realCoords = canv.panelToDataCoords(panelCoords);
        long modelX = realCoords.getLongX();
        long modelY = realCoords.getLongY();
        this.drawingTool.lineTo(modelX, modelY);
        evt.getDisplay().update();
        evt.consume();
    }

    private void initDrawingTool(MsPressedEvent evt) {
        ImageDisplay imageDisplay = (ImageDisplay)evt.getDisplay();
        if (imageDisplay == null) {
            return;
        }
        OptionsChannels options = (OptionsChannels)this.optionsService.getOptions(OptionsChannels.class);
        ChannelCollection channels = evt.getModifiers().isAltDown() || evt.getModifiers().isAltGrDown() ? options.getBgValues() : options.getFgValues();
        Dataset dataset = this.imageDisplayService.getActiveDataset(imageDisplay);
        this.drawingTool = new DrawingTool(dataset, this.renderingService);
        this.drawingTool.setChannels(channels);
        long[] currPos = new long[imageDisplay.numDimensions()];
        for (int i = 0; i < currPos.length; ++i) {
            currPos[i] = imageDisplay.getLongPosition(i);
        }
        this.drawingTool.setPosition(currPos);
        this.drawingTool.setUAxis(0);
        this.drawingTool.setVAxis(1);
        this.drawingTool.setLineWidth(this.getLineWidth());
    }
}

