/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.display.imagej;

import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.image.ColorModel;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;

public class ImageProcessorUtils {
    private ImageProcessorUtils() {
    }

    public static ImageProcessor createImageProcessor(Object pixels, int width, int height, ColorModel colorModel) {
        if (pixels instanceof byte[]) {
            return new ByteProcessor(width, height, (byte[])pixels, colorModel);
        }
        if (pixels instanceof short[]) {
            return new ShortProcessor(width, height, (short[])pixels, colorModel);
        }
        if (pixels instanceof int[]) {
            return new ColorProcessor(width, height, (int[])pixels);
        }
        if (pixels instanceof float[]) {
            return new FloatProcessor(width, height, (float[])pixels, colorModel);
        }
        throw new IllegalArgumentException("unsupported color type");
    }

    public static boolean isSupported(Type<?> type) {
        return type instanceof UnsignedByteType || type instanceof UnsignedShortType || type instanceof ARGBType || type instanceof FloatType;
    }

    public static Img<?> createImg(Object pixels, int width, int height) {
        if (pixels instanceof int[]) {
            return ArrayImgs.argbs((int[])((int[])pixels), (long[])new long[]{width, height});
        }
        if (pixels instanceof byte[]) {
            return ArrayImgs.unsignedBytes((byte[])((byte[])pixels), (long[])new long[]{width, height});
        }
        if (pixels instanceof short[]) {
            return ArrayImgs.unsignedShorts((short[])((short[])pixels), (long[])new long[]{width, height});
        }
        if (pixels instanceof float[]) {
            return ArrayImgs.floats((float[])((float[])pixels), (long[])new long[]{width, height});
        }
        throw new IllegalArgumentException("unsupported pixel type");
    }
}

