/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.bdv.tools.boundingbox;

import bdv.tools.boundingbox.AbstractTransformedBoxModel;
import bdv.tools.boundingbox.BoxDisplayModePanel;
import bdv.tools.boundingbox.BoxSelectionOptions;
import bdv.tools.boundingbox.TransformedRealBoxSelectionDialog;
import bdv.util.MipmapTransforms;
import bdv.viewer.AbstractViewerPanel;
import bdv.viewer.ConverterSetups;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerStateChange;
import bdv.viewer.ViewerStateChangeListener;
import ij.ImagePlus;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.FinalRealInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.Volatile;
import net.imglib2.converter.Converter;
import net.imglib2.display.RealARGBColorConverter;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.iterator.IntervalIterator;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.imglib2.N5Utils;
import org.scijava.ui.behaviour.Behaviour;
import org.scijava.ui.behaviour.BehaviourMap;
import org.scijava.ui.behaviour.ClickBehaviour;
import org.scijava.ui.behaviour.InputTriggerAdder;
import org.scijava.ui.behaviour.InputTriggerMap;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.util.TriggerBehaviourBindings;

public class BoxCrop
extends TransformedRealBoxSelectionDialog
implements ClickBehaviour,
ViewerStateChangeListener {
    private static final long serialVersionUID = -1857317799215108065L;
    public static final String EXPORT_CURRENT = "Current";
    public static final String EXPORT_VISIBLE = "Visible";
    private final AbstractViewerPanel viewer;
    private final List<SourceAndConverter<?>> sources;
    private int[] scales;
    private final String name;
    private final String[] defaultTriggers;
    private JComboBox<Integer> scaleLevelDropdown;
    private JComboBox<String> exportedSourcesDropddown;
    private JCheckBox concatenateSourcesCheck;
    private JLabel information;
    private SourceAndConverter<?> currSrc;
    private int selectedLevel;
    private RealInterval lastInterval;
    private final BehaviourMap behaviourMap = new BehaviourMap();
    private final InputTriggerMap inputTriggerMap = new InputTriggerMap();
    private final InputTriggerAdder inputAdder;
    private BoxSelectionOptions.TimepointSelection timePointSelection = BoxSelectionOptions.TimepointSelection.NONE;

    public BoxCrop(AbstractViewerPanel viewer, ConverterSetups converterSetups, int setupId, InputTriggerConfig keyConfig, TriggerBehaviourBindings triggerbindings, BoxSelectionOptions options, AffineTransform3D boxTransform, RealInterval initialInterval, RealInterval rangeInterval, String name, String ... defaultTriggers) {
        super(viewer, converterSetups, setupId, keyConfig, triggerbindings, boxTransform, initialInterval, rangeInterval, options);
        this.viewer = viewer;
        this.sources = viewer.state().getSources();
        viewer.state().changeListeners().add((Object)this);
        this.name = name;
        this.defaultTriggers = defaultTriggers;
        this.timePointSelection = options.values.getTimepointSelection();
        this.inputAdder = keyConfig.inputTriggerAdder(this.inputTriggerMap, new String[]{"crop"});
        this.register();
        this.model.intervalChangedListeners().add((Object)new AbstractTransformedBoxModel.IntervalChangedListener(){

            public void intervalChanged() {
                BoxCrop.this.updateInformation();
            }
        });
        this.buttons.onOk(() -> {
            this.crop();
            viewer.state().changeListeners().remove((Object)this);
        });
        this.buttons.onCancel(() -> viewer.state().changeListeners().remove((Object)this));
    }

    public void click(int x, int y) {
        this.currSrc = this.viewer.state().getCurrentSource();
        this.viewer.state().changeListeners().add((Object)this);
        this.updateScales();
        this.scales = null;
        Source src = this.currSrc.getSpimSource();
        int estBestScale = MipmapTransforms.getBestMipMapLevel((AffineTransform3D)this.viewer.state().getViewerTransform(), (Source)src, (int)0);
        int bestScale = estBestScale <= src.getNumMipmapLevels() - 1 ? estBestScale : src.getNumMipmapLevels() - 1;
        this.scaleLevelDropdown.setSelectedIndex(bestScale);
        double[] boxMin = new double[3];
        double[] boxMax = new double[3];
        RandomAccessibleInterval srcItvl = src.getSource(0, 0);
        srcItvl.realMin(boxMin);
        srcItvl.realMax(boxMax);
        AffineTransform3D srcXfm = new AffineTransform3D();
        src.getSourceTransform(0, 0, srcXfm);
        srcXfm.apply(boxMin, boxMin);
        srcXfm.apply(boxMax, boxMax);
        RealInterval initItvl = this.lastInterval == null ? BoxCrop.initialBoxFromView(this.viewer, src) : this.lastInterval;
        this.model.setInterval(initItvl);
        this.updateInformation();
        this.setVisible(true);
        this.viewer.state().setCurrentSource(this.currSrc);
    }

    public static RealInterval initialBoxFromView(AbstractViewerPanel viewer, Source<?> src) {
        double f;
        double w;
        int d;
        Dimension dispSz = viewer.getDisplayComponent().getSize();
        RealPoint minCorner = new RealPoint(3);
        RealPoint maxCorner = new RealPoint(new float[]{dispSz.width, dispSz.height, 0.0f});
        viewer.state().getViewerTransform().applyInverse((RealPositionable)minCorner, (RealLocalizable)minCorner);
        viewer.state().getViewerTransform().applyInverse((RealPositionable)maxCorner, (RealLocalizable)maxCorner);
        RandomAccessibleInterval srcItvl = src.getSource(0, 0);
        AffineTransform3D srcXfm = new AffineTransform3D();
        src.getSourceTransform(0, 0, srcXfm);
        FinalRealInterval srcBboxWorld = BoxCrop.transformedBoundingBox((RealTransform)srcXfm, (RealInterval)srcItvl);
        int nd = srcItvl.numDimensions();
        double[] min = new double[nd];
        double[] max = new double[nd];
        double maxWidth = 0.0;
        double minFrac = Double.MAX_VALUE;
        double avgFrac = 0.0;
        for (d = 0; d < nd; ++d) {
            w = Math.abs(maxCorner.getDoublePosition(d) - minCorner.getDoublePosition(d)) / 2.0;
            maxWidth = w > maxWidth ? w : maxWidth;
            f = w / (srcBboxWorld.realMax(d) - srcBboxWorld.realMin(d));
            avgFrac += f;
            minFrac = f < minFrac ? f : minFrac;
        }
        avgFrac /= (double)nd;
        for (d = 0; d < nd; ++d) {
            w = maxWidth / 2.0;
            f = w / (srcBboxWorld.realMax(d) - srcBboxWorld.realMin(d));
            if (f > avgFrac) {
                w = avgFrac * (srcBboxWorld.realMax(d) - srcBboxWorld.realMin(d));
            }
            double center = 0.5 * (minCorner.getDoublePosition(d) + maxCorner.getDoublePosition(d));
            min[d] = center - w;
            max[d] = center + w;
        }
        return new FinalRealInterval(min, max);
    }

    public void register() {
        this.behaviourMap.put(this.name, (Behaviour)this);
        this.inputAdder.put(this.name, this.defaultTriggers);
    }

    protected JPanel createContent() {
        JPanel content = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        layout.columnWidths = new int[]{80};
        layout.columnWeights = new double[]{1.0};
        content.setLayout(layout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.information = new JLabel("");
        content.add((Component)this.information, gbc);
        ++gbc.gridy;
        content.add((Component)new JLabel("Scale level"), gbc);
        gbc.gridx = 1;
        this.scaleLevelDropdown = new JComboBox<Integer>(new Integer[]{0});
        this.scaleLevelDropdown.addActionListener(e -> {
            this.selectedLevel = this.scaleLevelDropdown.getSelectedIndex();
            if (EXPORT_VISIBLE.equals((String)this.exportedSourcesDropddown.getSelectedItem()) && !this.canExportVisible(true)) {
                this.exportedSourcesDropddown.setSelectedItem(EXPORT_CURRENT);
                this.concatenateSourcesCheck.setEnabled(false);
            }
            this.updateInformation();
        });
        content.add(this.scaleLevelDropdown, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        content.add((Component)new JLabel("Images to export"), gbc);
        gbc.gridx = 1;
        this.exportedSourcesDropddown = new JComboBox<String>(new String[]{EXPORT_CURRENT, EXPORT_VISIBLE});
        this.exportedSourcesDropddown.addActionListener(e -> {
            if (EXPORT_VISIBLE.equals((String)this.exportedSourcesDropddown.getSelectedItem())) {
                if (this.concatenateSourcesCheck.isSelected() && !this.canStackVisibleSources(true)) {
                    this.exportedSourcesDropddown.setSelectedItem(EXPORT_CURRENT);
                }
                if (!this.canExportVisible(true)) {
                    this.exportedSourcesDropddown.setSelectedItem(EXPORT_CURRENT);
                }
                this.concatenateSourcesCheck.setEnabled(true);
            } else {
                this.concatenateSourcesCheck.setEnabled(false);
            }
        });
        content.add(this.exportedSourcesDropddown, gbc);
        ++gbc.gridy;
        this.concatenateSourcesCheck = new JCheckBox("Multichannel export");
        this.concatenateSourcesCheck.setEnabled(false);
        this.concatenateSourcesCheck.addActionListener(e -> {
            if (EXPORT_VISIBLE.equals((String)this.exportedSourcesDropddown.getSelectedItem()) && this.concatenateSourcesCheck.isSelected() && !this.canStackVisibleSources(true)) {
                this.concatenateSourcesCheck.setSelected(false);
            }
        });
        content.add((Component)this.concatenateSourcesCheck, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        JLabel lblTitle = new JLabel("Selection:");
        lblTitle.setFont(content.getFont().deriveFont(1));
        content.add((Component)lblTitle, gbc);
        ++gbc.gridy;
        JPanel boundsPanel = new JPanel();
        boundsPanel.setLayout(new BoxLayout(boundsPanel, 3));
        boundsPanel.add((Component)this.boxSelectionPanel);
        if (this.timePointSelection != BoxSelectionOptions.TimepointSelection.NONE) {
            boundsPanel.add((Component)this.timepointSelectionPanel);
        }
        content.add((Component)boundsPanel, gbc);
        ++gbc.gridy;
        gbc.anchor = 512;
        gbc.fill = 0;
        BoxDisplayModePanel boxModePanel = new BoxDisplayModePanel(this.boxEditor.boxDisplayMode());
        content.add((Component)boxModePanel, gbc);
        return content;
    }

    public void setVisible(boolean visible) {
        this.updateScales();
        super.setVisible(visible);
    }

    public void updateScales() {
        int numScales = this.currSrc != null ? this.currSrc.getSpimSource().getNumMipmapLevels() : this.sources.get(0).getSpimSource().getNumMipmapLevels();
        this.scaleLevelDropdown.setModel(new DefaultComboBoxModel(IntStream.range(0, numScales).mapToObj(x -> x).toArray(Integer[]::new)));
        this.pack();
    }

    public <T extends NativeType<T>> void updateInformation() {
        Source src = this.currSrc.getSpimSource();
        NativeType t = (NativeType)Util.getTypeFromInterval((Interval)src.getSource(0, 0));
        Interval pixItvl = this.getPixelInterval(src, this.selectedLevel);
        long numBytes = this.estimateBytes(pixItvl, t, this.selectedLevel);
        String byteString = BoxCrop.humanReadableByteCountSI(numBytes);
        if (pixItvl.numDimensions() == 2) {
            this.information.setText(String.format("Output %d x %d (%s)", pixItvl.dimension(0), pixItvl.dimension(1), byteString));
        } else if (pixItvl.numDimensions() == 3) {
            this.information.setText(String.format("Output %d x %d x %d (%s)", pixItvl.dimension(0), pixItvl.dimension(1), pixItvl.dimension(2), byteString));
        }
        this.repaint();
    }

    public BehaviourMap getBehaviourMap() {
        return this.behaviourMap;
    }

    public InputTriggerMap getInputTriggerMap() {
        return this.inputTriggerMap;
    }

    public Interval getPixelInterval(Source<?> src, int scale) {
        AffineTransform3D srcXfm = new AffineTransform3D();
        src.getSourceTransform(0, scale, srcXfm);
        RealInterval requestedInterval = this.model.getInterval();
        FinalRealInterval bbox = BoxCrop.transformedBoundingBox((RealTransform)srcXfm.inverse(), requestedInterval);
        long[] pixMin = new long[bbox.numDimensions()];
        long[] pixMax = new long[bbox.numDimensions()];
        for (int d = 0; d < bbox.numDimensions(); ++d) {
            pixMin[d] = (long)Math.floor(bbox.realMin(d));
            pixMax[d] = (long)Math.ceil(bbox.realMax(d));
        }
        return new FinalInterval(pixMin, pixMax);
    }

    protected boolean canExportVisible(boolean showMessage) {
        List<SourceAndConverter<?>> srcList = this.getVisibleSources();
        for (int i = 0; i < srcList.size(); ++i) {
            Source src = srcList.get(i).getSpimSource();
            if (this.selectedLevel <= src.getNumMipmapLevels() - 1) continue;
            if (showMessage) {
                System.out.println("Can't export all visible : source  " + src.getName() + " does not have scale level " + this.selectedLevel);
            }
            return false;
        }
        return true;
    }

    protected List<SourceAndConverter<?>> getVisibleSources() {
        ArrayList srcList = new ArrayList();
        Set visibleSources = this.viewer.state().getVisibleSources();
        visibleSources.removeIf(x -> x.getSpimSource().getType() == null);
        visibleSources.forEach(x -> srcList.add((SourceAndConverter<?>)x));
        return srcList;
    }

    protected boolean canStackVisibleSources(boolean showMessage) {
        List<SourceAndConverter<?>> srcList = this.getVisibleSources();
        return this.canStackSources(srcList, showMessage);
    }

    protected boolean findMatchingScaleLevels(List<SourceAndConverter<?>> srcList, AffineTransform3D affine, double tolerance) {
        this.scales = new int[srcList.size()];
        Arrays.fill(this.scales, -1);
        int i = 0;
        AffineTransform3D testTransform = new AffineTransform3D();
        for (SourceAndConverter<?> sac : srcList) {
            int N = sac.getSpimSource().getNumMipmapLevels();
            for (int j = 0; j < N; ++j) {
                sac.getSpimSource().getSourceTransform(0, j, testTransform);
                if (!BoxCrop.affineAlmostEqual(testTransform, affine, tolerance)) continue;
                this.scales[i] = j;
            }
            ++i;
        }
        for (i = 0; i < this.scales.length; ++i) {
            if (this.scales[i] >= 0) continue;
            return false;
        }
        return true;
    }

    protected boolean canStackSources(List<SourceAndConverter<?>> srcList, boolean showMessage) {
        AffineTransform3D first = new AffineTransform3D();
        AffineTransform3D comp = new AffineTransform3D();
        Object t = Util.getTypeFromInterval((Interval)srcList.get(0).getSpimSource().getSource(0, 0));
        if (srcList.get(0).getSpimSource().getNumMipmapLevels() <= this.selectedLevel) {
            if (showMessage) {
                System.out.println("Can't stack visible sources : different scale levels");
            }
            return false;
        }
        srcList.get(0).getSpimSource().getSourceTransform(0, this.selectedLevel, first);
        for (int i = 1; i < srcList.size(); ++i) {
            Object s = Util.getTypeFromInterval((Interval)srcList.get(i).getSpimSource().getSource(0, 0));
            if (!s.getClass().equals(t.getClass())) {
                if (showMessage) {
                    System.out.println("Can't stack visible sources : different types");
                }
                return false;
            }
            if (srcList.get(i).getSpimSource().getNumMipmapLevels() <= this.selectedLevel) {
                if (showMessage) {
                    System.out.println("Can't stack visible sources : different scale levels");
                }
                return false;
            }
            srcList.get(i).getSpimSource().getSourceTransform(0, this.selectedLevel, comp);
            if (BoxCrop.affineAlmostEqual(first, comp, 1.0E-9)) continue;
            if (this.findMatchingScaleLevels(srcList, comp, 1.0E-9)) {
                return true;
            }
            if (showMessage) {
                System.out.println("Can't stack visible sources : different resolutions.");
            }
            return false;
        }
        return true;
    }

    public <T extends NumericType<T> & NativeType<T>> ImagePlus[] crop() {
        this.lastInterval = this.model.getInterval();
        String exportOption = (String)this.exportedSourcesDropddown.getSelectedItem();
        ArrayList srcList = new ArrayList();
        if (exportOption.equals(EXPORT_CURRENT)) {
            srcList.add(this.currSrc);
        } else {
            srcList.add(this.currSrc);
            Set visibleSources = this.viewer.state().getVisibleSources();
            visibleSources.removeIf(x -> x.getSpimSource().getType() == null);
            visibleSources.forEach(x -> {
                if (x != this.currSrc) {
                    srcList.add((SourceAndConverter<?>)x);
                }
            });
        }
        boolean doStack = this.concatenateSourcesCheck.isSelected();
        if (doStack) {
            doStack = this.canStackSources(srcList, false);
        }
        if (this.scales == null) {
            this.scales = new int[srcList.size()];
            Arrays.fill(this.scales, this.selectedLevel);
        }
        ArrayList<RandomAccessibleInterval<T>> imgList = new ArrayList<RandomAccessibleInterval<T>>();
        int i = 0;
        Interval[] intervals = new Interval[srcList.size()];
        for (SourceAndConverter sourceAndConverter : srcList) {
            Interval pixItvl;
            Source src = sourceAndConverter.getSpimSource();
            int level = this.scales[i];
            intervals[i] = pixItvl = this.getPixelInterval(src, level);
            imgList.add(this.cropSource(src, pixItvl, level));
            ++i;
        }
        if (doStack) {
            if (this.scales == null) {
                this.scales = new int[imgList.size()];
                Arrays.fill(this.scales, this.selectedLevel);
            }
            RandomAccessibleInterval imgTmp = Views.stack(imgList);
            RandomAccessibleInterval randomAccessibleInterval = Views.moveAxis((RandomAccessibleInterval)imgTmp, (int)(imgTmp.numDimensions() - 1), (int)2);
            ImagePlus imp = ImageJFunctions.wrap((RandomAccessibleInterval)randomAccessibleInterval, (String)"multichannel crop");
            BoxCrop.updateDisplayRange(imp, (SourceAndConverter)srcList.get(0));
            BoxCrop.updateResolutionOffset(imp, ((SourceAndConverter)srcList.get(0)).getSpimSource(), intervals[0], this.selectedLevel);
            imp.show();
            return new ImagePlus[]{imp};
        }
        ImagePlus[] results = new ImagePlus[imgList.size()];
        for (i = 0; i < imgList.size(); ++i) {
            RandomAccessibleInterval randomAccessibleInterval = (RandomAccessibleInterval)imgList.get(i);
            RandomAccessibleInterval img = randomAccessibleInterval.numDimensions() == 3 ? Views.moveAxis((RandomAccessibleInterval)Views.addDimension((RandomAccessibleInterval)randomAccessibleInterval, (long)0L, (long)0L), (int)2, (int)3) : randomAccessibleInterval;
            ImagePlus imp = ImageJFunctions.wrap((RandomAccessibleInterval)img, (String)(((SourceAndConverter)srcList.get(i)).getSpimSource().getName() + "+_crop"));
            BoxCrop.updateDisplayRange(imp, (SourceAndConverter)srcList.get(i));
            BoxCrop.updateResolutionOffset(imp, ((SourceAndConverter)srcList.get(0)).getSpimSource(), intervals[i], this.scales[i]);
            results[i] = imp;
            imp.show();
        }
        return results;
    }

    public <T extends NumericType<T> & NativeType<T>> RandomAccessibleInterval<T> cropSource(Source<T> src, Interval pixItvl, int level) {
        RandomAccessibleInterval img = src.getSource(0, level);
        IntervalView cropImg = Views.interval((RandomAccessible)Views.extendZero((RandomAccessibleInterval)img), (Interval)pixItvl);
        return cropImg;
    }

    private static void updateDisplayRange(ImagePlus imp, SourceAndConverter<?> sac) {
        Converter conv = sac.getConverter();
        if (conv instanceof RealARGBColorConverter) {
            RealARGBColorConverter rc = (RealARGBColorConverter)conv;
            imp.setDisplayRange(rc.getMin(), rc.getMax());
        }
    }

    private static void updateResolutionOffset(ImagePlus imp, Source<?> src, Interval itvl, int level) {
        AffineTransform3D tmp = new AffineTransform3D();
        src.getSourceTransform(0, level, tmp);
        double sx = tmp.get(0, 0);
        double sy = tmp.get(1, 1);
        double sz = tmp.get(2, 2);
        imp.getCalibration().pixelWidth = sx;
        imp.getCalibration().pixelHeight = sy;
        imp.getCalibration().pixelDepth = sz;
        imp.getCalibration().xOrigin = sx * (double)itvl.min(0) + tmp.get(0, 3);
        imp.getCalibration().yOrigin = sy * (double)itvl.min(1) + tmp.get(1, 3);
        imp.getCalibration().zOrigin = sz * (double)itvl.min(2) + tmp.get(2, 3);
    }

    public static FinalRealInterval transformedBoundingBox(RealTransform xfm, RealInterval interval) {
        if (xfm == null) {
            return new FinalRealInterval(interval);
        }
        int nd = interval.numDimensions();
        double[] pt = new double[nd];
        double[] ptxfm = new double[nd];
        double[] min = new double[nd];
        double[] max = new double[nd];
        Arrays.fill(min, Double.MAX_VALUE);
        Arrays.fill(max, Double.MIN_VALUE);
        long[] unitInterval = new long[nd];
        Arrays.fill(unitInterval, 2L);
        IntervalIterator it = new IntervalIterator(unitInterval);
        while (it.hasNext()) {
            int d;
            it.fwd();
            for (d = 0; d < nd; ++d) {
                pt[d] = it.getLongPosition(d) == 0L ? interval.realMin(d) : interval.realMax(d);
            }
            xfm.apply(pt, ptxfm);
            for (d = 0; d < nd; ++d) {
                long lo = (long)Math.floor(ptxfm[d]);
                long hi = (long)Math.ceil(ptxfm[d]);
                if ((double)lo < min[d]) {
                    min[d] = lo;
                }
                if (!((double)hi > max[d])) continue;
                max[d] = hi;
            }
        }
        return new FinalRealInterval(min, max);
    }

    protected static String humanReadableByteCountSI(long bytes) {
        if (-1000L < bytes && bytes < 1000L) {
            return bytes + " B";
        }
        StringCharacterIterator ci = new StringCharacterIterator("kMGTPE");
        while (bytes <= -999950L || bytes >= 999950L) {
            bytes /= 1000L;
            ci.next();
        }
        return String.format("%.1f %cB", (double)bytes / 1000.0, Character.valueOf(ci.current()));
    }

    private <T extends NativeType<T>> long estimateBytes(Interval itvl, T t, int level) {
        Object g = t instanceof Volatile ? (NativeType)((Volatile)t).get() : t;
        DataType dataType = N5Utils.dataType(g);
        String typeString = dataType.toString();
        long N = Intervals.numElements((Dimensions)itvl);
        long nBytes = -1L;
        if (typeString.endsWith("8")) {
            nBytes = N;
        } else if (typeString.endsWith("16")) {
            nBytes = N * 2L;
        } else if (typeString.endsWith("32")) {
            nBytes = N * 4L;
        } else if (typeString.endsWith("64")) {
            nBytes = N * 8L;
        }
        return nBytes;
    }

    private static boolean affineAlmostEqual(AffineTransform3D a, AffineTransform3D b, double relativeThreshold) {
        double[] avals = a.getRowPackedCopy();
        double[] bvals = b.getRowPackedCopy();
        for (int i = 0; i < avals.length; ++i) {
            double absDiff = Math.abs(avals[i] - bvals[i]);
            if (!(absDiff > relativeThreshold)) continue;
            return false;
        }
        return true;
    }

    private static double frobeniusNorm(AffineTransform3D a) {
        double norm = 0.0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                double v = a.get(i, j);
                norm += v * v;
            }
        }
        return Math.sqrt(norm);
    }

    public void viewerStateChanged(ViewerStateChange change) {
        if (change.equals((Object)ViewerStateChange.CURRENT_SOURCE_CHANGED) || change.equals((Object)ViewerStateChange.VISIBILITY_CHANGED)) {
            SourceAndConverter tmpSrc = this.viewer.state().getCurrentSource();
            if (tmpSrc == null) {
                return;
            }
            if (tmpSrc.getSpimSource().getType() != null) {
                this.currSrc = tmpSrc;
            }
            this.updateScales();
            if (EXPORT_VISIBLE.equals((String)this.exportedSourcesDropddown.getSelectedItem())) {
                if (this.concatenateSourcesCheck.isSelected() && !this.canStackVisibleSources(true)) {
                    this.exportedSourcesDropddown.setSelectedItem(EXPORT_CURRENT);
                }
                if (!this.canExportVisible(true)) {
                    this.exportedSourcesDropddown.setSelectedItem(EXPORT_CURRENT);
                }
            }
            this.updateInformation();
        }
    }
}

