/*
 * Decompiled with CFR 0.152.
 */
package hr.irb.fastRandomForest;

import hr.irb.fastRandomForest.FastRfUtils;
import java.util.Arrays;
import java.util.Random;
import weka.core.Instances;

public class DataCache {
    protected final float[][] vals;
    protected final int[] attNumVals;
    protected final int classIndex;
    protected final int numAttributes;
    protected final int numClasses;
    protected final int numInstances;
    protected final int[] instClassValues;
    protected int[][] sortedIndices;
    protected double[] instWeights;
    protected boolean[] inBag = null;
    protected int numInBag = 0;
    protected int[] whatGoesWhere = null;
    protected Random reusableRandomGenerator = null;

    public float[] scrambleOneAttribute(int attIndex, Random random) {
        float[] toReturn = Arrays.copyOf(this.vals[attIndex], this.vals[attIndex].length);
        for (int i = 0; i < this.vals[attIndex].length; ++i) {
            int swapWith = random.nextInt(this.vals[attIndex].length);
            float temp = this.vals[attIndex][i];
            this.vals[attIndex][i] = this.vals[attIndex][swapWith];
            this.vals[attIndex][swapWith] = temp;
        }
        return toReturn;
    }

    public DataCache(Instances origData) throws Exception {
        int a;
        int i;
        this.classIndex = origData.classIndex();
        this.numAttributes = origData.numAttributes();
        this.numClasses = origData.numClasses();
        this.numInstances = origData.numInstances();
        this.attNumVals = new int[origData.numAttributes()];
        for (i = 0; i < this.attNumVals.length; ++i) {
            if (origData.attribute(i).isNumeric()) {
                this.attNumVals[i] = 0;
                continue;
            }
            if (origData.attribute(i).isNominal()) {
                this.attNumVals[i] = origData.attribute(i).numValues();
                continue;
            }
            throw new Exception("Only numeric and nominal attributes are supported.");
        }
        this.vals = new float[this.numAttributes][this.numInstances];
        for (a = 0; a < this.numAttributes; ++a) {
            for (int i2 = 0; i2 < this.numInstances; ++i2) {
                this.vals[a][i2] = origData.instance(i2).isMissing(a) ? Float.MAX_VALUE : (float)origData.instance(i2).value(a);
            }
        }
        this.instWeights = new double[this.numInstances];
        this.instClassValues = new int[this.numInstances];
        for (i = 0; i < this.numInstances; ++i) {
            this.instWeights[i] = origData.instance(i).weight();
            this.instClassValues[i] = (int)origData.instance(i).classValue();
        }
        this.sortedIndices = new int[this.numAttributes][];
        for (a = 0; a < this.numAttributes; ++a) {
            if (a == this.classIndex) continue;
            if (this.attNumVals[a] > 0) {
                this.sortedIndices[a] = new int[this.numInstances];
                this.sortedIndices[a] = FastRfUtils.sort(this.vals[a]);
                continue;
            }
            this.sortedIndices[a] = FastRfUtils.sort(this.vals[a]);
        }
    }

    public DataCache(DataCache origData) {
        this.classIndex = origData.classIndex;
        this.numAttributes = origData.numAttributes;
        this.numClasses = origData.numClasses;
        this.numInstances = origData.numInstances;
        this.attNumVals = origData.attNumVals;
        this.instClassValues = origData.instClassValues;
        this.vals = origData.vals;
        this.sortedIndices = origData.sortedIndices;
        this.instWeights = origData.instWeights;
        this.inBag = new boolean[this.numInstances];
        this.numInBag = 0;
        this.whatGoesWhere = null;
    }

    public DataCache resample(int bagSize, Random random) {
        DataCache result = new DataCache(this);
        double[] newWeights = new double[this.numInstances];
        for (int r = 0; r < bagSize; ++r) {
            int curIdx;
            int n = curIdx = random.nextInt(this.numInstances);
            newWeights[n] = newWeights[n] + this.instWeights[curIdx];
            if (result.inBag[curIdx]) continue;
            ++result.numInBag;
            result.inBag[curIdx] = true;
        }
        result.instWeights = newWeights;
        return result;
    }

    protected void createInBagSortedIndices() {
        int[][] newSortedIndices = new int[this.numAttributes][];
        for (int a = 0; a < this.numAttributes; ++a) {
            if (a == this.classIndex) continue;
            newSortedIndices[a] = new int[this.numInBag];
            int inBagIdx = 0;
            for (int i = 0; i < this.sortedIndices[a].length; ++i) {
                int origIdx = this.sortedIndices[a][i];
                if (!this.inBag[origIdx]) continue;
                newSortedIndices[a][inBagIdx] = this.sortedIndices[a][i];
                ++inBagIdx;
            }
        }
        this.sortedIndices = newSortedIndices;
    }

    public final boolean isValueMissing(int attIndex, int instIndex) {
        return this.vals[attIndex][instIndex] == Float.MAX_VALUE;
    }

    public final boolean isAttrNominal(int attIndex) {
        return this.attNumVals[attIndex] > 0;
    }

    public Random getRandomNumberGenerator(long seed) {
        Random r = new Random(seed);
        long dataSignature = Arrays.toString(this.sortedIndices[r.nextInt(this.numAttributes)]).hashCode();
        r.setSeed(dataSignature + seed);
        return r;
    }
}

