/*
 * Decompiled with CFR 0.152.
 */
package trainableSegmentation;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import trainableSegmentation.FeatureStack;
import weka.core.Instances;

public class FeatureStackArray {
    private FeatureStack[] featureStackArray;
    private int referenceStackIndex = -1;
    private float minimumSigma = 1.0f;
    private float maximumSigma = 16.0f;
    private boolean useNeighbors = false;
    private int membraneThickness = 1;
    private int membranePatchSize = 19;
    private boolean[] enabledFeatures = null;
    private boolean oldColorFormat = false;
    private boolean oldHessianFormat = false;

    public FeatureStackArray(int num) {
        this.featureStackArray = new FeatureStack[num];
    }

    public FeatureStackArray(int num, float minimumSigma, float maximumSigma, boolean useNeighbors, int membraneSize, int membranePatchSize, boolean[] enabledFeatures) {
        this.featureStackArray = new FeatureStack[num];
        this.minimumSigma = minimumSigma;
        this.maximumSigma = maximumSigma;
        this.useNeighbors = useNeighbors;
        this.membraneThickness = membraneSize;
        this.membranePatchSize = membranePatchSize;
        this.enabledFeatures = enabledFeatures;
    }

    public FeatureStackArray(ImagePlus inputImage, ImagePlus filters) {
        this.featureStackArray = new FeatureStack[inputImage.getImageStackSize()];
        for (int i = 1; i <= this.featureStackArray.length; ++i) {
            this.featureStackArray[i - 1] = new FeatureStack(new ImagePlus("slice " + i, inputImage.getImageStack().getProcessor(i)));
            this.featureStackArray[i - 1].addFeaturesMT(filters);
        }
    }

    public int getSize() {
        return this.featureStackArray.length;
    }

    public FeatureStack get(int n) {
        return this.featureStackArray[n];
    }

    public boolean isRGB() {
        if (this.referenceStackIndex != -1) {
            return this.featureStackArray[this.referenceStackIndex].getStack().getBitDepth() == 24;
        }
        IJ.log((String)"Warning. Error in FeatureStackArray: trying to access empty array!");
        return false;
    }

    public void set(FeatureStack fs, int index) {
        this.featureStackArray[index] = fs;
        if (this.referenceStackIndex == -1) {
            this.setReference(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateFeaturesMT(boolean[] update) {
        if (Thread.currentThread().isInterrupted()) {
            return false;
        }
        int numProcessors = Prefs.getThreads();
        ExecutorService exe = Executors.newFixedThreadPool(numProcessors);
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        try {
            for (int i = 0; i < this.featureStackArray.length; ++i) {
                if (null == this.featureStackArray[i] || !update[i]) continue;
                IJ.log((String)("Updating features of slice number " + (i + 1) + "..."));
                this.featureStackArray[i].setEnabledFeatures(this.enabledFeatures);
                this.featureStackArray[i].setMembranePatchSize(this.membranePatchSize);
                this.featureStackArray[i].setMembraneSize(this.membraneThickness);
                this.featureStackArray[i].setMaximumSigma(this.maximumSigma);
                this.featureStackArray[i].setMinimumSigma(this.minimumSigma);
                this.featureStackArray[i].setUseNeighbors(this.useNeighbors);
                this.featureStackArray[i].setOldColorFormat(this.oldColorFormat);
                this.featureStackArray[i].setOldHessianFormat(this.oldHessianFormat);
                if (this.featureStackArray.length == 1) {
                    if (!this.featureStackArray[i].updateFeaturesMT()) {
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    futures.add(exe.submit(this.updateFeatures(this.featureStackArray[i])));
                }
                if (this.referenceStackIndex != -1) continue;
                this.referenceStackIndex = i;
            }
            for (Future future : futures) {
                boolean result = (Boolean)future.get();
                if (result) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (InterruptedException e) {
            IJ.log((String)"The feature update was interrupted by the user.");
            exe.shutdownNow();
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            IJ.log((String)"Error when updating feature stack array.");
            ex.printStackTrace();
            exe.shutdownNow();
            boolean bl = false;
            return bl;
        }
        finally {
            exe.shutdown();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateFeaturesMT() {
        boolean bl;
        int numProcessors = Prefs.getThreads();
        ExecutorService exe = Executors.newFixedThreadPool(numProcessors);
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        IJ.showStatus((String)"Updating features...");
        try {
            for (int i = 0; i < this.featureStackArray.length; ++i) {
                if (null == this.featureStackArray[i]) continue;
                IJ.log((String)("Updating features of slice number " + (i + 1) + "..."));
                this.featureStackArray[i].setEnabledFeatures(this.enabledFeatures);
                this.featureStackArray[i].setMembranePatchSize(this.membranePatchSize);
                this.featureStackArray[i].setMembraneSize(this.membraneThickness);
                this.featureStackArray[i].setMaximumSigma(this.maximumSigma);
                this.featureStackArray[i].setMinimumSigma(this.minimumSigma);
                this.featureStackArray[i].setUseNeighbors(this.useNeighbors);
                this.featureStackArray[i].setOldColorFormat(this.oldColorFormat);
                this.featureStackArray[i].setOldHessianFormat(this.oldHessianFormat);
                if (this.featureStackArray.length == 1) {
                    if (!this.featureStackArray[i].updateFeaturesMT()) {
                        boolean bl2 = false;
                        return bl2;
                    }
                } else {
                    futures.add(exe.submit(this.updateFeatures(this.featureStackArray[i])));
                }
                if (this.referenceStackIndex != -1) continue;
                this.referenceStackIndex = i;
            }
            int currentIndex = 0;
            int finalIndex = this.featureStackArray.length;
            for (Future future : futures) {
                boolean result = (Boolean)future.get();
                IJ.showStatus((String)"Updating features...");
                IJ.showProgress((int)(++currentIndex), (int)finalIndex);
                if (result) continue;
                boolean bl3 = false;
                return bl3;
            }
        }
        catch (InterruptedException e) {
            IJ.log((String)"The feature update was interrupted by the user.");
            IJ.showStatus((String)"The feature update was interrupted by the user.");
            IJ.showProgress((double)1.0);
            exe.shutdownNow();
            bl = false;
            return bl;
        }
        catch (Exception ex) {
            IJ.log((String)"Error when updating feature stack array.");
            ex.printStackTrace();
            exe.shutdownNow();
            bl = false;
            return bl;
        }
        finally {
            exe.shutdown();
        }
        return true;
    }

    public Callable<Boolean> updateFeatures(final FeatureStack fs) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return fs.updateFeaturesST();
            }
        };
    }

    public void resetReference() {
        this.referenceStackIndex = -1;
    }

    public void setReference(int index) {
        this.referenceStackIndex = index;
    }

    public void shutDownNow() {
        for (int i = 0; i < this.featureStackArray.length; ++i) {
            if (null == this.featureStackArray[i]) continue;
            this.featureStackArray[i].shutDownNow();
        }
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getSize(); ++i) {
            if (null == this.featureStackArray[i] || this.featureStackArray[i].getSize() <= 1) continue;
            return false;
        }
        return true;
    }

    public int getNumOfFeatures() {
        if (this.referenceStackIndex == -1) {
            return -1;
        }
        return this.featureStackArray[this.referenceStackIndex].getSize();
    }

    public String getLabel(int index) {
        if (this.referenceStackIndex == -1) {
            return null;
        }
        return this.featureStackArray[this.referenceStackIndex].getSliceLabel(index);
    }

    public boolean[] getEnabledFeatures() {
        if (this.referenceStackIndex == -1) {
            return this.enabledFeatures;
        }
        return this.featureStackArray[this.referenceStackIndex].getEnabledFeatures();
    }

    public void setEnabledFeatures(boolean[] newFeatures) {
        this.enabledFeatures = newFeatures;
        if (this.referenceStackIndex != -1) {
            this.featureStackArray[this.referenceStackIndex].setEnabledFeatures(newFeatures);
        }
    }

    public void setMembraneSize(int thickness) {
        this.membraneThickness = thickness;
        if (this.referenceStackIndex != -1) {
            this.featureStackArray[this.referenceStackIndex].setMembraneSize(thickness);
        }
    }

    public void setMembranePatchSize(int patchSize) {
        this.membranePatchSize = patchSize;
        if (this.referenceStackIndex != -1) {
            this.featureStackArray[this.referenceStackIndex].setMembranePatchSize(patchSize);
        }
    }

    public void setMaximumSigma(float sigma) {
        this.maximumSigma = sigma;
        if (this.referenceStackIndex != -1) {
            this.featureStackArray[this.referenceStackIndex].setMaximumSigma(sigma);
        }
    }

    public void setMinimumSigma(float sigma) {
        this.minimumSigma = sigma;
        if (this.referenceStackIndex != -1) {
            this.featureStackArray[this.referenceStackIndex].setMinimumSigma(sigma);
        }
    }

    public void setUseNeighbors(boolean useNeighbors) {
        this.useNeighbors = useNeighbors;
        if (this.referenceStackIndex != -1) {
            this.featureStackArray[this.referenceStackIndex].setUseNeighbors(useNeighbors);
        }
    }

    public boolean useNeighborhood() {
        if (this.referenceStackIndex != -1) {
            return this.featureStackArray[this.referenceStackIndex].useNeighborhood();
        }
        return this.useNeighbors;
    }

    public int getReferenceSliceIndex() {
        return this.referenceStackIndex;
    }

    public int getWidth() {
        if (this.referenceStackIndex != -1) {
            return this.featureStackArray[this.referenceStackIndex].getWidth();
        }
        return -1;
    }

    public int getHeight() {
        if (this.referenceStackIndex != -1) {
            return this.featureStackArray[this.referenceStackIndex].getHeight();
        }
        return -1;
    }

    public void setOldColorFormat(boolean oldColorFormat) {
        this.oldColorFormat = oldColorFormat;
        if (this.referenceStackIndex != -1) {
            this.featureStackArray[this.referenceStackIndex].setOldColorFormat(oldColorFormat);
        }
    }

    public boolean isOldColorFormat() {
        return this.oldColorFormat;
    }

    public void setOldHessianFormat(boolean oldHessianFormat) {
        this.oldHessianFormat = oldHessianFormat;
        if (this.referenceStackIndex != -1) {
            this.featureStackArray[this.referenceStackIndex].setOldHessianFormat(oldHessianFormat);
        }
    }

    public boolean isOldoldHessianFormatFormat() {
        return this.oldHessianFormat;
    }

    public boolean reorderFeatures(Instances data) {
        if (null == data) {
            return false;
        }
        for (int i = 0; i < this.featureStackArray.length; ++i) {
            if (null == this.featureStackArray[i]) continue;
            if (!this.featureStackArray[i].reorderFeatures(data)) {
                // empty if block
            }
            return false;
        }
        return true;
    }
}

