/*
 * Decompiled with CFR 0.152.
 */
package trainableSegmentation;

import fiji.util.gui.GenericDialogPlus;
import fiji.util.gui.OverlayedImageCanvas;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.gui.StackWindow;
import ij.gui.Toolbar;
import ij.io.DirectoryChooser;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.process.LUT;
import ij.process.StackConverter;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.List;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ColorModel;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.GZIPOutputStream;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import trainableSegmentation.FeatureStack;
import trainableSegmentation.FeatureStack3D;
import trainableSegmentation.FeatureStackArray;
import trainableSegmentation.ImageOverlay;
import trainableSegmentation.ImageScience;
import trainableSegmentation.RoiListOverlay;
import trainableSegmentation.WekaSegmentation;
import trainableSegmentation.utils.Utils;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.evaluation.EvaluationUtils;
import weka.classifiers.evaluation.ThresholdCurve;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.PluginManager;
import weka.core.SerializationHelper;
import weka.core.WekaPackageManager;
import weka.gui.GUIChooserApp;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertyPanel;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.ThresholdVisualizePanel;

public class Weka_Segmentation
implements PlugIn {
    public static final String PLUGIN_NAME = "Trainable Weka Segmentation";
    public static final String PLUGIN_VERSION = "v" + Weka_Segmentation.class.getPackage().getImplementationVersion();
    private WekaSegmentation wekaSegmentation = null;
    private ImagePlus displayImage = null;
    private ImagePlus trainingImage = null;
    private ImagePlus classifiedImage = null;
    private CustomWindow win = null;
    private int numOfClasses = 2;
    private int[] traceCounter = new int[100];
    private boolean showColorOverlay = false;
    private final ExecutorService exec = Executors.newFixedThreadPool(1);
    private JButton trainButton = null;
    private JButton overlayButton = null;
    private JButton resultButton = null;
    private JButton probabilityButton = null;
    private JButton plotButton = null;
    private JButton applyButton = null;
    private JButton loadClassifierButton = null;
    private JButton saveClassifierButton = null;
    private JButton loadDataButton = null;
    private JButton saveDataButton = null;
    private JButton settingsButton = null;
    private JButton wekaButton = null;
    private JButton addClassButton = null;
    private RoiListOverlay[] roiOverlay = null;
    private Color[] colors = new Color[]{Color.red, Color.green, Color.blue, Color.cyan, Color.magenta};
    private LUT overlayLUT = null;
    private List[] exampleList = null;
    private JButton[] addExampleButton = null;
    public static final String ADD_TRACE = "addTrace";
    public static final String DELETE_TRACE = "deleteTrace";
    public static final String TRAIN_CLASSIFIER = "trainClassifier";
    public static final String TOGGLE_OVERLAY = "toggleOverlay";
    public static final String GET_RESULT = "getResult";
    public static final String GET_PROBABILITY = "getProbability";
    public static final String PLOT_RESULT = "plotResultGraphs";
    public static final String APPLY_CLASSIFIER = "applyClassifier";
    public static final String LOAD_CLASSIFIER = "loadClassifier";
    public static final String SAVE_CLASSIFIER = "saveClassifier";
    public static final String LOAD_DATA = "loadData";
    public static final String SAVE_DATA = "saveData";
    public static final String CREATE_CLASS = "createNewClass";
    public static final String LAUNCH_WEKA = "launchWeka";
    public static final String SET_FEATURE = "setFeature";
    public static final String SET_MEMBRANE_THICKNESS = "setMembraneThickness";
    public static final String SET_MEMBRANE_PATCH = "setMembranePatchSize";
    public static final String SET_MINIMUM_SIGMA = "setMinimumSigma";
    public static final String SET_MAXIMUM_SIGMA = "setMaximumSigma";
    public static final String CHANGE_CLASS_COLOR = "changeClassColor";
    public static final String SET_HOMOGENIZATION = "setClassHomogenization";
    public static final String SET_BALANCE = "setClassBalance";
    public static final String SET_CLASSIFIER = "setClassifier";
    public static final String SAVE_FEATURE_STACK = "saveFeatureStack";
    public static final String CHANGE_CLASS_NAME = "changeClassName";
    public static final String SET_OPACITY = "setOpacity";
    private boolean trainingFlag = false;
    private boolean isProcessing3D = false;
    private Thread trainingTask = null;
    private ActionListener listener = new ActionListener(){

        @Override
        public void actionPerformed(final ActionEvent e) {
            final String command = e.getActionCommand();
            Weka_Segmentation.this.exec.submit(new Runnable(){

                @Override
                public void run() {
                    if (e.getSource() == Weka_Segmentation.this.trainButton) {
                        Weka_Segmentation.this.runStopTraining(command);
                    } else if (e.getSource() == Weka_Segmentation.this.overlayButton) {
                        String[] arg = new String[]{};
                        Weka_Segmentation.record(Weka_Segmentation.TOGGLE_OVERLAY, arg);
                        Weka_Segmentation.this.win.toggleOverlay();
                    } else if (e.getSource() == Weka_Segmentation.this.resultButton) {
                        String[] arg = new String[]{};
                        Weka_Segmentation.record(Weka_Segmentation.GET_RESULT, arg);
                        Weka_Segmentation.this.showClassificationImage();
                    } else if (e.getSource() == Weka_Segmentation.this.probabilityButton) {
                        String[] arg = new String[]{};
                        Weka_Segmentation.record(Weka_Segmentation.GET_PROBABILITY, arg);
                        Weka_Segmentation.this.showProbabilityImage();
                    } else if (e.getSource() == Weka_Segmentation.this.plotButton) {
                        String[] arg = new String[]{};
                        Weka_Segmentation.record(Weka_Segmentation.PLOT_RESULT, arg);
                        Weka_Segmentation.this.plotResult();
                    } else if (e.getSource() == Weka_Segmentation.this.applyButton) {
                        Weka_Segmentation.this.applyClassifierToTestData();
                    } else if (e.getSource() == Weka_Segmentation.this.loadClassifierButton) {
                        Weka_Segmentation.this.loadClassifier();
                        Weka_Segmentation.this.win.updateButtonsEnabling();
                    } else if (e.getSource() == Weka_Segmentation.this.saveClassifierButton) {
                        Weka_Segmentation.this.win.setButtonsEnabled(false);
                        Weka_Segmentation.this.saveClassifier();
                        Weka_Segmentation.this.win.updateButtonsEnabling();
                    } else if (e.getSource() == Weka_Segmentation.this.loadDataButton) {
                        Weka_Segmentation.this.loadTrainingData();
                    } else if (e.getSource() == Weka_Segmentation.this.saveDataButton) {
                        Weka_Segmentation.this.saveTrainingData();
                    } else if (e.getSource() == Weka_Segmentation.this.addClassButton) {
                        Weka_Segmentation.this.addNewClass();
                    } else if (e.getSource() == Weka_Segmentation.this.settingsButton) {
                        Weka_Segmentation.this.showSettingsDialog();
                        Weka_Segmentation.this.win.updateButtonsEnabling();
                    } else if (e.getSource() == Weka_Segmentation.this.wekaButton) {
                        String[] arg = new String[]{};
                        Weka_Segmentation.record(Weka_Segmentation.LAUNCH_WEKA, arg);
                        Weka_Segmentation.launchWeka();
                    } else {
                        for (int i = 0; i < Weka_Segmentation.this.wekaSegmentation.getNumOfClasses(); ++i) {
                            if (e.getSource() == Weka_Segmentation.this.exampleList[i]) {
                                Weka_Segmentation.this.deleteSelected(e);
                                break;
                            }
                            if (e.getSource() != Weka_Segmentation.this.addExampleButton[i]) continue;
                            Weka_Segmentation.this.addExamples(i);
                            break;
                        }
                        Weka_Segmentation.this.win.updateButtonsEnabling();
                    }
                }
            });
        }
    };
    private ItemListener itemListener = new ItemListener(){

        @Override
        public void itemStateChanged(final ItemEvent e) {
            Weka_Segmentation.this.exec.submit(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < Weka_Segmentation.this.wekaSegmentation.getNumOfClasses(); ++i) {
                        if (e.getSource() != Weka_Segmentation.this.exampleList[i]) continue;
                        Weka_Segmentation.this.listSelected(e, i);
                    }
                }
            });
        }
    };
    private MouseListener mouseListener = new MouseListener(){

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 3) {
                for (int i = 0; i < Weka_Segmentation.this.wekaSegmentation.getNumOfClasses(); ++i) {
                    if (e.getSource() != Weka_Segmentation.this.addExampleButton[i]) continue;
                    Weka_Segmentation.this.updateClassColor(i);
                    break;
                }
                Weka_Segmentation.this.win.updateButtonsEnabling();
            }
        }
    };

    public Weka_Segmentation() {
        this.colors = new Color[100];
        float hue = 0.0f;
        float saturation = 1.0f;
        for (int i = 0; i < 100; ++i) {
            this.colors[i] = Color.getHSBColor(hue, saturation, 1.0f);
            if ((hue += 0.38197f) > 1.0f) {
                hue -= 1.0f;
            }
            if ((saturation += 0.38197f) > 1.0f) {
                saturation -= 1.0f;
            }
            saturation = 0.5f * saturation + 0.5f;
        }
        this.overlayLUT = Utils.createLUT(this.colors);
        this.exampleList = new List[100];
        this.addExampleButton = new JButton[100];
        this.roiOverlay = new RoiListOverlay[100];
        this.trainButton = new JButton("Train classifier");
        this.trainButton.setToolTipText("Start training the classifier");
        this.overlayButton = new JButton("Toggle overlay");
        this.overlayButton.setToolTipText("Toggle between current segmentation and original image");
        this.overlayButton.setEnabled(false);
        this.resultButton = new JButton("Create result");
        this.resultButton.setToolTipText("Generate result image");
        this.resultButton.setEnabled(false);
        this.probabilityButton = new JButton("Get probability");
        this.probabilityButton.setToolTipText("Generate current probability maps");
        this.probabilityButton.setEnabled(false);
        this.plotButton = new JButton("Plot result");
        this.plotButton.setToolTipText("Plot result based on different metrics");
        this.plotButton.setEnabled(false);
        this.applyButton = new JButton("Apply classifier");
        this.applyButton.setToolTipText("Apply current classifier to a single image or stack");
        this.applyButton.setEnabled(false);
        this.loadClassifierButton = new JButton("Load classifier");
        this.loadClassifierButton.setToolTipText("Load Weka classifier from a file");
        this.saveClassifierButton = new JButton("Save classifier");
        this.saveClassifierButton.setToolTipText("Save current classifier into a file");
        this.saveClassifierButton.setEnabled(false);
        this.loadDataButton = new JButton("Load data");
        this.loadDataButton.setToolTipText("Load previous segmentation from an ARFF file");
        this.saveDataButton = new JButton("Save data");
        this.saveDataButton.setToolTipText("Save current segmentation into an ARFF file");
        this.saveDataButton.setEnabled(false);
        this.addClassButton = new JButton("Create new class");
        this.addClassButton.setToolTipText("Add one more label to mark different areas");
        this.settingsButton = new JButton("Settings");
        this.settingsButton.setToolTipText("Display settings dialog");
        ImageIcon icon = new ImageIcon(Weka_Segmentation.class.getResource("/trainableSegmentation/images/weka.png"));
        this.wekaButton = new JButton(icon);
        this.wekaButton.setToolTipText("Launch Weka GUI chooser");
        this.showColorOverlay = false;
    }

    public void run(String arg) {
        if (arg.equals("3D")) {
            this.isProcessing3D = true;
        }
        this.wekaSegmentation = new WekaSegmentation(this.isProcessing3D);
        for (int i = 0; i < this.wekaSegmentation.getNumOfClasses(); ++i) {
            this.exampleList[i] = new List(5);
            this.exampleList[i].setForeground(this.colors[i]);
        }
        this.numOfClasses = this.wekaSegmentation.getNumOfClasses();
        if (null == WindowManager.getCurrentImage()) {
            this.trainingImage = IJ.openImage();
            if (null == this.trainingImage) {
                return;
            }
        } else {
            this.trainingImage = WindowManager.getCurrentImage();
            this.trainingImage.getWindow().setVisible(false);
        }
        if (Math.max(this.trainingImage.getWidth(), this.trainingImage.getHeight()) > 1024) {
            IJ.log((String)"Warning: at least one dimension of the image is larger than 1024 pixels.\nFeature stack creation and classifier training might take some time depending on your computer.\n");
        }
        this.wekaSegmentation.setTrainingImage(this.trainingImage);
        this.displayImage = this.trainingImage.duplicate();
        this.displayImage.setSlice(this.trainingImage.getCurrentSlice());
        this.displayImage.setTitle("Trainable Weka Segmentation " + PLUGIN_VERSION);
        Toolbar.getInstance().setTool(6);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Weka_Segmentation.this.win = new CustomWindow(Weka_Segmentation.this.displayImage);
                Weka_Segmentation.this.win.pack();
            }
        });
    }

    private void addExamples(int i) {
        Roi r = this.displayImage.getRoi();
        if (null == r) {
            return;
        }
        int n = this.displayImage.getCurrentSlice();
        this.displayImage.killRoi();
        this.wekaSegmentation.addExample(i, r, n);
        int n2 = i;
        this.traceCounter[n2] = this.traceCounter[n2] + 1;
        this.win.drawExamples();
        this.win.updateExampleLists();
        String[] arg = new String[]{Integer.toString(i), Integer.toString(n)};
        Weka_Segmentation.record(ADD_TRACE, arg);
    }

    public void updateClassifiedImage(ImagePlus classifiedImage) {
        this.classifiedImage = classifiedImage;
    }

    public void updateResultOverlay() {
        if (null != this.classifiedImage) {
            ImageProcessor overlay = this.classifiedImage.getImageStack().getProcessor(this.displayImage.getCurrentSlice()).duplicate();
            overlay = overlay.convertToByte(false);
            overlay.setColorModel((ColorModel)this.overlayLUT);
            this.win.resultOverlay.setImage(overlay);
        }
    }

    void listSelected(ItemEvent e, int i) {
        this.win.drawExamples();
        this.displayImage.setColor(Color.YELLOW);
        for (int j = 0; j < this.wekaSegmentation.getNumOfClasses(); ++j) {
            if (j == i) {
                Roi newRoi = this.wekaSegmentation.getExamples(i, this.displayImage.getCurrentSlice()).get(this.exampleList[i].getSelectedIndex());
                newRoi.setImage(this.displayImage);
                this.displayImage.setRoi(newRoi);
                continue;
            }
            this.exampleList[j].deselect(this.exampleList[j].getSelectedIndex());
        }
        this.displayImage.updateAndDraw();
    }

    void updateClassColor(int i) {
        Color newColor = JColorChooser.showDialog(this.addExampleButton[i], "Choose Color", this.colors[i]);
        if (null != newColor) {
            this.colors[i] = newColor;
            this.exampleList[i].setForeground(this.colors[i]);
            this.exampleList[i].repaint();
            this.overlayLUT = Utils.createLUT(this.colors);
            this.displayImage.killRoi();
            this.win.drawExamples();
            this.updateResultOverlay();
            String hex = String.format("#%02x%02x%02x", newColor.getRed(), newColor.getGreen(), newColor.getBlue());
            String[] arg = new String[]{Integer.toString(i), hex};
            Weka_Segmentation.record(CHANGE_CLASS_COLOR, arg);
        }
    }

    void deleteSelected(ActionEvent e) {
        for (int i = 0; i < this.wekaSegmentation.getNumOfClasses(); ++i) {
            if (e.getSource() != this.exampleList[i]) continue;
            int index = this.exampleList[i].getSelectedIndex();
            if (this.displayImage.getRoi().equals((Object)this.wekaSegmentation.getExamples(i, this.displayImage.getCurrentSlice()).get(index))) {
                this.displayImage.killRoi();
            }
            this.wekaSegmentation.deleteExample(i, this.displayImage.getCurrentSlice(), index);
            this.exampleList[i].remove(index);
            String[] arg = new String[]{Integer.toString(i), Integer.toString(this.displayImage.getCurrentSlice()), Integer.toString(index)};
            Weka_Segmentation.record(DELETE_TRACE, arg);
        }
        this.win.drawExamples();
        this.win.updateExampleLists();
    }

    void runStopTraining(String command) {
        if (command.equals("Train classifier")) {
            Thread newTask;
            this.trainingFlag = true;
            this.trainButton.setText("STOP");
            final Thread oldTask = this.trainingTask;
            this.win.updateButtonsEnabling();
            this.trainButton.setText("STOP");
            this.trainingTask = newTask = new Thread(){

                @Override
                public void run() {
                    if (null != oldTask) {
                        try {
                            IJ.log((String)"Waiting for old task to finish...");
                            oldTask.join();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    try {
                        String[] arg = new String[]{};
                        Weka_Segmentation.record(Weka_Segmentation.TRAIN_CLASSIFIER, arg);
                        if (Weka_Segmentation.this.wekaSegmentation.trainClassifier()) {
                            if (this.isInterrupted()) {
                                Weka_Segmentation.this.wekaSegmentation.shutDownNow();
                                Weka_Segmentation.this.win.trainingComplete = false;
                                return;
                            }
                            Weka_Segmentation.this.wekaSegmentation.applyClassifier(false);
                            Weka_Segmentation.this.classifiedImage = Weka_Segmentation.this.wekaSegmentation.getClassifiedImage();
                            if (Weka_Segmentation.this.showColorOverlay) {
                                Weka_Segmentation.this.win.toggleOverlay();
                            }
                            Weka_Segmentation.this.win.toggleOverlay();
                            Weka_Segmentation.this.win.trainingComplete = true;
                        } else {
                            IJ.log((String)"The traning did not finish.");
                            Weka_Segmentation.this.win.trainingComplete = false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    catch (OutOfMemoryError err) {
                        err.printStackTrace();
                        IJ.log((String)"ERROR: plugin run out of memory. Please, use a smaller input image or fewer features.");
                    }
                    finally {
                        Weka_Segmentation.this.trainingFlag = false;
                        Weka_Segmentation.this.trainButton.setText("Train classifier");
                        Weka_Segmentation.this.win.updateButtonsEnabling();
                        Weka_Segmentation.this.trainingTask = null;
                    }
                }
            };
            newTask.start();
        } else if (command.equals("STOP")) {
            try {
                this.trainingFlag = false;
                this.win.trainingComplete = false;
                IJ.log((String)"Training was stopped by the user!");
                this.win.setButtonsEnabled(false);
                this.trainButton.setText("Train classifier");
                if (null != this.trainingTask) {
                    this.trainingTask.interrupt();
                    this.trainingTask.stop();
                } else {
                    IJ.log((String)"Error: interrupting training failed becaused the thread is null!");
                }
                this.wekaSegmentation.shutDownNow();
                this.win.updateButtonsEnabling();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    void showClassificationImage() {
        if (null == this.classifiedImage) {
            this.win.setButtonsEnabled(false);
            this.wekaSegmentation.applyClassifier(false);
            this.classifiedImage = this.wekaSegmentation.getClassifiedImage();
            this.win.updateButtonsEnabling();
        }
        ImagePlus resultImage = this.classifiedImage.duplicate();
        resultImage.setTitle("Classified image");
        Weka_Segmentation.convertTo8bitNoScaling(resultImage);
        resultImage.getProcessor().setColorModel((ColorModel)this.overlayLUT);
        resultImage.getImageStack().setColorModel((ColorModel)this.overlayLUT);
        resultImage.updateAndDraw();
        resultImage.show();
    }

    static void convertTo8bitNoScaling(ImagePlus image) {
        boolean aux = ImageConverter.getDoScaling();
        ImageConverter.setDoScaling((boolean)false);
        if (image.getImageStackSize() > 1) {
            new StackConverter(image).convertToGray8();
        } else {
            new ImageConverter(image).convertToGray8();
        }
        ImageConverter.setDoScaling((boolean)aux);
    }

    void showProbabilityImage() {
        IJ.showStatus((String)"Calculating probability maps...");
        IJ.log((String)"Calculating probability maps...");
        this.win.setButtonsEnabled(false);
        try {
            this.wekaSegmentation.applyClassifier(true);
        }
        catch (Exception ex) {
            IJ.log((String)"Error while applying classifier! (please send bug report)");
            ex.printStackTrace();
            this.win.updateButtonsEnabling();
            return;
        }
        ImagePlus probImage = this.wekaSegmentation.getClassifiedImage();
        if (null != probImage) {
            probImage.setDimensions(this.numOfClasses, this.displayImage.getNSlices(), this.displayImage.getNFrames());
            if (this.displayImage.getNSlices() * this.displayImage.getNFrames() > 1) {
                probImage.setOpenAsHyperStack(true);
            }
            probImage.show();
        }
        this.win.updateButtonsEnabling();
        IJ.showStatus((String)"Done.");
        IJ.log((String)"Done");
    }

    void plotResult() {
        IJ.showStatus((String)"Evaluating current data...");
        IJ.log((String)"Evaluating current data...");
        this.win.setButtonsEnabled(false);
        Instances data = this.wekaSegmentation.getTraceTrainingData() != null ? this.wekaSegmentation.getTraceTrainingData() : this.wekaSegmentation.getLoadedTrainingData();
        if (null == data) {
            IJ.error((String)"Error in plot result", (String)"No data available yet to plot results: you need to trace\nsome training samples or load data from file.");
            this.win.updateButtonsEnabling();
            return;
        }
        Weka_Segmentation.displayGraphs(data, this.wekaSegmentation.getClassifier());
        this.win.updateButtonsEnabling();
        IJ.showStatus((String)"Done.");
        IJ.log((String)"Done");
    }

    public static void displayGraphs(Instances data, AbstractClassifier classifier) {
        ThresholdCurve tc = new ThresholdCurve();
        ArrayList predictions = null;
        try {
            EvaluationUtils eu = new EvaluationUtils();
            predictions = eu.getTestPredictions((Classifier)classifier, data);
        }
        catch (Exception e) {
            IJ.log((String)"Error while evaluating data!");
            e.printStackTrace();
            return;
        }
        Instances result = tc.getCurve(predictions);
        ThresholdVisualizePanel vmc = new ThresholdVisualizePanel();
        vmc.setName(result.relationName() + " (display only)");
        PlotData2D tempd = new PlotData2D(result);
        tempd.setPlotName(result.relationName());
        tempd.addInstanceNumberAttribute();
        try {
            vmc.addPlot(tempd);
        }
        catch (Exception e) {
            IJ.log((String)"Error while adding plot to visualization panel!");
            e.printStackTrace();
            return;
        }
        String plotName = vmc.getName();
        JFrame jf = new JFrame("Weka Classifier Visualize: " + plotName);
        jf.setDefaultCloseOperation(2);
        jf.setSize(500, 400);
        jf.getContentPane().setLayout(new BorderLayout());
        jf.getContentPane().add((Component)vmc, "Center");
        jf.setVisible(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void applyClassifierToTestData() {
        int decision;
        int decision2;
        File[] imageFiles;
        String storeDir = "";
        String dir = OpenDialog.getLastDirectory();
        if (null == dir) {
            dir = OpenDialog.getDefaultDirectory();
        }
        if (Prefs.useFileChooser) {
            JFileChooser fileChooser = new JFileChooser(dir);
            fileChooser.setFileSelectionMode(0);
            fileChooser.setMultiSelectionEnabled(true);
            fileChooser.setDialogTitle("Select file(s) to classify");
            int returnVal = fileChooser.showOpenDialog(null);
            if (returnVal != 0) return;
            imageFiles = fileChooser.getSelectedFiles();
            OpenDialog.setLastDirectory((String)imageFiles[0].getParent());
        } else {
            ImageJ parent = IJ.getInstance();
            FileDialog fd = new FileDialog((Frame)parent, "Select file(s) to classify", 0);
            fd.setDirectory(dir);
            fd.setMultipleMode(true);
            fd.setFilenameFilter(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    File f = new File(dir + File.separator + name);
                    return f.exists() && !f.isDirectory();
                }
            });
            fd.setVisible(true);
            imageFiles = fd.getFiles();
            fd.dispose();
            if (null == imageFiles || imageFiles.length == 0) {
                return;
            }
            OpenDialog.setLastDirectory((String)imageFiles[0].getParent());
        }
        boolean showResults = true;
        boolean storeResults = false;
        if (imageFiles.length >= 3 && (decision2 = JOptionPane.showConfirmDialog(null, "You decided to process three or more image files. Do you want the results to be stored on the disk instead of opening them in Fiji?", "Save results?", 0)) == 0) {
            DirectoryChooser dc = new DirectoryChooser("Select folder to store results");
            DirectoryChooser.setDefaultDirectory((String)dir);
            storeDir = dc.getDirectory();
            if (null == storeDir) {
                return;
            }
            showResults = false;
            storeResults = true;
        }
        final boolean probabilityMaps = (decision = JOptionPane.showConfirmDialog(null, "Create probability maps instead of segmentation?", "Probability maps?", 0)) == 0;
        int numProcessors = Prefs.getThreads();
        int numThreads = Math.min(imageFiles.length, numProcessors);
        final int numFurtherThreads = (int)Math.ceil((double)(numProcessors - numThreads) / (double)imageFiles.length) + 1;
        IJ.log((String)("Processing " + imageFiles.length + " image file(s) in " + numThreads + " thread(s)...."));
        this.win.setButtonsEnabled(false);
        Thread[] threads = new Thread[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            class ImageProcessingThread
            extends Thread {
                private final int numThread;
                private final int numThreads;
                private final File[] imageFiles;
                private final boolean storeResults;
                private final boolean showResults;
                private final String storeDir;

                public ImageProcessingThread(int numThread, int numThreads, File[] imageFiles, boolean storeResults, boolean showResults, String storeDir) {
                    this.numThread = numThread;
                    this.numThreads = numThreads;
                    this.imageFiles = imageFiles;
                    this.storeResults = storeResults;
                    this.showResults = showResults;
                    this.storeDir = storeDir;
                }

                @Override
                public void run() {
                    for (int i = this.numThread; i < this.imageFiles.length; i += this.numThreads) {
                        File file = this.imageFiles[i];
                        ImagePlus testImage = IJ.openImage((String)file.getPath());
                        if (null == testImage) {
                            IJ.log((String)("Error: " + file.getPath() + " is not a valid image file."));
                            IJ.error((String)"Trainable Weka Segmentation I/O error", (String)("Error: " + file.getPath() + " is not a valid image file."));
                            return;
                        }
                        if (testImage.getNSlices() == 1 && Weka_Segmentation.this.isProcessing3D) {
                            IJ.log((String)("Error: " + file.getPath() + " is a 2D image but Trainable Weka Segmentation is working in 3D."));
                            IJ.error((String)("Wrong image dimensions: " + file.getPath() + " is a 2D image but Trainable Weka Segmentation is working in 3D."));
                            return;
                        }
                        IJ.log((String)("Processing image " + file.getName() + " in thread " + this.numThread));
                        ImagePlus segmentation = Weka_Segmentation.this.wekaSegmentation.applyClassifier(testImage, numFurtherThreads, probabilityMaps);
                        if (null == segmentation) {
                            IJ.log((String)("Error: " + file.getName() + "could not be classified!"));
                            return;
                        }
                        if (!probabilityMaps) {
                            Weka_Segmentation.convertTo8bitNoScaling(segmentation);
                            segmentation.getProcessor().setColorModel((ColorModel)Weka_Segmentation.this.overlayLUT);
                            segmentation.getImageStack().setColorModel((ColorModel)Weka_Segmentation.this.overlayLUT);
                            segmentation.updateAndDraw();
                        }
                        if (this.showResults) {
                            segmentation.show();
                            testImage.show();
                            continue;
                        }
                        if (!this.storeResults) continue;
                        String filename = this.storeDir + File.separator + file.getName();
                        IJ.log((String)("Saving results to " + filename));
                        IJ.save((ImagePlus)segmentation, (String)filename);
                        segmentation.close();
                        testImage.close();
                        segmentation = null;
                        testImage = null;
                        System.gc();
                    }
                }
            }
            threads[i] = new ImageProcessingThread(i, numThreads, imageFiles, storeResults, showResults, storeDir);
            String[] arg = new String[]{imageFiles[i].getParent(), imageFiles[i].getName(), "showResults=" + showResults, "storeResults=" + storeResults, "probabilityMaps=" + probabilityMaps, storeDir};
            Weka_Segmentation.record(APPLY_CLASSIFIER, arg);
            threads[i].start();
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.win.updateButtonsEnabling();
    }

    public void loadClassifier() {
        OpenDialog od = new OpenDialog("Choose Weka classifier file", "");
        if (od.getFileName() == null) {
            return;
        }
        IJ.log((String)("Loading Weka classifier from " + od.getDirectory() + od.getFileName() + "..."));
        String[] arg = new String[]{od.getDirectory() + od.getFileName()};
        Weka_Segmentation.record(LOAD_CLASSIFIER, arg);
        this.win.setButtonsEnabled(false);
        AbstractClassifier oldClassifier = this.wekaSegmentation.getClassifier();
        if (!this.wekaSegmentation.loadClassifier(od.getDirectory() + od.getFileName())) {
            IJ.error((String)"Error when loading Weka classifier from file");
            IJ.log((String)"Error: classifier could not be loaded.");
            this.win.updateButtonsEnabling();
            return;
        }
        if (!this.wekaSegmentation.loadClassifier(od.getDirectory() + od.getFileName())) {
            IJ.error((String)"Error when loading Weka classifier from file");
            IJ.log((String)"Error: classifier could not be loaded.");
            this.win.updateButtonsEnabling();
            return;
        }
        IJ.log((String)("Read header from " + od.getDirectory() + od.getFileName() + " (number of attributes = " + this.wekaSegmentation.getTrainHeader().numAttributes() + ")"));
        if (this.wekaSegmentation.getTrainHeader().numAttributes() < 1) {
            IJ.error((String)"Error", (String)"No attributes were found on the model header");
            this.wekaSegmentation.setClassifier(oldClassifier);
            this.win.updateButtonsEnabling();
            return;
        }
        this.win.trainingComplete = true;
        this.win.updateAddClassButtons();
        IJ.log((String)("Loaded " + od.getDirectory() + od.getFileName()));
    }

    public static AbstractClassifier readClassifier(String filename) {
        AbstractClassifier cls = null;
        try {
            cls = (AbstractClassifier)SerializationHelper.read((String)filename);
        }
        catch (Exception e) {
            IJ.log((String)("Error when loading classifier from " + filename));
            e.printStackTrace();
        }
        return cls;
    }

    public void saveClassifier() {
        SaveDialog sd = new SaveDialog("Save model as...", "classifier", ".model");
        if (sd.getFileName() == null) {
            return;
        }
        String[] arg = new String[]{sd.getDirectory() + sd.getFileName()};
        Weka_Segmentation.record(SAVE_CLASSIFIER, arg);
        if (!this.wekaSegmentation.saveClassifier(sd.getDirectory() + sd.getFileName())) {
            IJ.error((String)"Error while writing classifier into a file");
            return;
        }
    }

    public static boolean saveClassifier(AbstractClassifier classifier, Instances trainHeader, String filename) {
        File sFile = null;
        boolean saveOK = true;
        IJ.log((String)"Saving model to file...");
        try {
            sFile = new File(filename);
            OutputStream os = new FileOutputStream(sFile);
            if (sFile.getName().endsWith(".gz")) {
                os = new GZIPOutputStream(os);
            }
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(os);
            objectOutputStream.writeObject(classifier);
            if (trainHeader != null) {
                objectOutputStream.writeObject(trainHeader);
            }
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception e) {
            IJ.error((String)"Save Failed", (String)"Error when saving classifier into a file");
            saveOK = false;
            e.printStackTrace();
        }
        if (saveOK) {
            IJ.log((String)("Saved model into the file " + filename));
        }
        return saveOK;
    }

    public static boolean writeClassifier(AbstractClassifier cls, String filename) {
        try {
            SerializationHelper.write((String)filename, (Object)cls);
        }
        catch (Exception e) {
            IJ.log((String)"Error while writing classifier into a file");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void loadTrainingData() {
        OpenDialog od = new OpenDialog("Choose data file", OpenDialog.getLastDirectory(), "data.arff");
        if (od.getFileName() == null) {
            return;
        }
        String[] arg = new String[]{od.getDirectory() + od.getFileName()};
        Weka_Segmentation.record(LOAD_DATA, arg);
        this.win.setButtonsEnabled(false);
        IJ.log((String)("Loading data from " + od.getDirectory() + od.getFileName() + "..."));
        this.wekaSegmentation.loadTrainingData(od.getDirectory() + od.getFileName());
        this.win.updateButtonsEnabling();
    }

    public void saveTrainingData() {
        SaveDialog sd = new SaveDialog("Choose save file", "data", ".arff");
        if (sd.getFileName() == null) {
            return;
        }
        String[] arg = new String[]{sd.getDirectory() + sd.getFileName()};
        Weka_Segmentation.record(SAVE_DATA, arg);
        this.win.setButtonsEnabled(false);
        if (!this.wekaSegmentation.saveData(sd.getDirectory() + sd.getFileName())) {
            IJ.showMessage((String)"There is no data to save");
        }
        this.win.updateButtonsEnabling();
    }

    private void addNewClass() {
        if (this.wekaSegmentation.getNumOfClasses() == 100) {
            IJ.showMessage((String)PLUGIN_NAME, (String)"Sorry, maximum number of classes has been reached");
            return;
        }
        String inputName = JOptionPane.showInputDialog("Please input a new label name");
        if (null == inputName) {
            return;
        }
        if (null == inputName || 0 == inputName.length()) {
            IJ.error((String)"Invalid name for class");
            return;
        }
        if (0 == (inputName = inputName.trim()).toLowerCase().indexOf("add to ")) {
            inputName = inputName.substring(7);
        }
        this.wekaSegmentation.setClassLabel(this.wekaSegmentation.getNumOfClasses(), inputName);
        this.wekaSegmentation.addClass();
        this.win.addClass();
        this.repaintWindow();
        String[] arg = new String[]{inputName};
        Weka_Segmentation.record(CREATE_CLASS, arg);
    }

    private void repaintWindow() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Weka_Segmentation.this.win.invalidate();
                Weka_Segmentation.this.win.validate();
                Weka_Segmentation.this.win.repaint();
            }
        });
    }

    public static void launchWeka() {
        GUIChooserApp chooser = new GUIChooserApp();
        for (WindowListener wl : chooser.getWindowListeners()) {
            chooser.removeWindowListener(wl);
        }
        chooser.setVisible(true);
    }

    public boolean showSettingsDialog() {
        int newOpacity;
        float newMaxSigma;
        float newMinSigma;
        Object c2;
        GenericDialogPlus gd = new GenericDialogPlus("Segmentation settings");
        boolean[] oldEnableFeatures = this.wekaSegmentation.getEnabledFeatures();
        String[] availableFeatures = this.isProcessing3D ? FeatureStack3D.availableFeatures : FeatureStack.availableFeatures;
        gd.addMessage("Training features:");
        int rows = (int)Math.round((double)availableFeatures.length / 2.0);
        gd.addCheckboxGroup(rows, 2, availableFeatures, oldEnableFeatures);
        Weka_Segmentation.disableMissingFeatures((GenericDialog)gd);
        if (this.wekaSegmentation.getLoadedTrainingData() != null) {
            Vector v = gd.getCheckboxes();
            for (Object c2 : v) {
                ((Component)c2).setEnabled(false);
            }
            gd.addMessage("WARNING: no features are selectable while using loaded data");
        }
        if (!this.isProcessing3D) {
            gd.addNumericField("Membrane thickness:", (double)this.wekaSegmentation.getMembraneThickness(), 0);
            gd.addNumericField("Membrane patch size:", (double)this.wekaSegmentation.getMembranePatchSize(), 0);
        }
        gd.addNumericField("Minimum sigma:", (double)this.wekaSegmentation.getMinimumSigma(), 1);
        gd.addNumericField("Maximum sigma:", (double)this.wekaSegmentation.getMaximumSigma(), 1);
        if (this.wekaSegmentation.getLoadedTrainingData() != null) {
            int nNumericFields = this.isProcessing3D ? 2 : 4;
            for (int i = 0; i < nNumericFields; ++i) {
                ((TextField)gd.getNumericFields().get(i)).setEnabled(false);
            }
        }
        gd.addMessage("Classifier options:");
        GenericObjectEditor m_ClassifierEditor = new GenericObjectEditor();
        PropertyPanel m_CEPanel = new PropertyPanel((PropertyEditor)m_ClassifierEditor);
        m_ClassifierEditor.setClassType(Classifier.class);
        m_ClassifierEditor.setValue((Object)this.wekaSegmentation.getClassifier());
        gd.addComponent((Component)m_CEPanel, 2, 1.0);
        c2 = m_ClassifierEditor.getValue();
        String originalOptions = "";
        String originalClassifierName = c2.getClass().getName();
        if (c2 instanceof OptionHandler) {
            originalOptions = weka.core.Utils.joinOptions((String[])((OptionHandler)c2).getOptions());
        }
        gd.addMessage("Class names:");
        for (int i = 0; i < this.wekaSegmentation.getNumOfClasses(); ++i) {
            gd.addStringField("Class " + (i + 1), this.wekaSegmentation.getClassLabel(i), 15);
        }
        gd.addMessage("Advanced options:");
        gd.addCheckbox("Balance classes", this.wekaSegmentation.doClassBalance());
        gd.addButton("Save feature stack", (ActionListener)new SaveFeatureStackButtonListener("Select location to save feature stack", this.wekaSegmentation));
        gd.addSlider("Result overlay opacity", 0.0, 100.0, (double)this.win.overlayOpacity);
        gd.addHelp("https://imagej.net/plugins/tws/");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        int numOfFeatures = availableFeatures.length;
        boolean[] newEnableFeatures = new boolean[numOfFeatures];
        boolean featuresChanged = false;
        for (int i = 0; i < numOfFeatures; ++i) {
            newEnableFeatures[i] = gd.getNextBoolean();
            if (newEnableFeatures[i] == oldEnableFeatures[i]) continue;
            featuresChanged = true;
            String featureName = availableFeatures[i];
            Weka_Segmentation.record(SET_FEATURE, featureName + "=" + newEnableFeatures[i]);
        }
        if (featuresChanged) {
            this.wekaSegmentation.setEnabledFeatures(newEnableFeatures);
        }
        if (!this.isProcessing3D) {
            int newPatch;
            int newThickness = (int)gd.getNextNumber();
            if (newThickness != this.wekaSegmentation.getMembraneThickness()) {
                featuresChanged = true;
                this.wekaSegmentation.setMembraneThickness(newThickness);
                Weka_Segmentation.record(SET_MEMBRANE_THICKNESS, Integer.toString(newThickness));
            }
            if ((newPatch = (int)gd.getNextNumber()) != this.wekaSegmentation.getMembranePatchSize()) {
                featuresChanged = true;
                Weka_Segmentation.record(SET_MEMBRANE_PATCH, Integer.toString(newPatch));
                this.wekaSegmentation.setMembranePatchSize(newPatch);
            }
        }
        if ((newMinSigma = (float)gd.getNextNumber()) != this.wekaSegmentation.getMinimumSigma() && newMinSigma > 0.0f) {
            featuresChanged = true;
            Weka_Segmentation.record(SET_MINIMUM_SIGMA, Float.toString(newMinSigma));
            this.wekaSegmentation.setMinimumSigma(newMinSigma);
        }
        if ((newMaxSigma = (float)gd.getNextNumber()) != this.wekaSegmentation.getMaximumSigma() && newMaxSigma >= this.wekaSegmentation.getMinimumSigma()) {
            featuresChanged = true;
            Weka_Segmentation.record(SET_MAXIMUM_SIGMA, Float.toString(newMaxSigma));
            this.wekaSegmentation.setMaximumSigma(newMaxSigma);
        }
        if (this.wekaSegmentation.getMinimumSigma() > this.wekaSegmentation.getMaximumSigma()) {
            IJ.error((String)"Error in the field of view parameters: they will be reset to default values");
            this.wekaSegmentation.setMinimumSigma(0.0f);
            this.wekaSegmentation.setMaximumSigma(16.0f);
        }
        c2 = m_ClassifierEditor.getValue();
        String options = "";
        String[] optionsArray = ((OptionHandler)c2).getOptions();
        if (c2 instanceof OptionHandler) {
            options = weka.core.Utils.joinOptions((String[])optionsArray);
        }
        if (!originalClassifierName.equals(c2.getClass().getName()) || !originalOptions.equals(options)) {
            AbstractClassifier cls;
            try {
                cls = (AbstractClassifier)c2.getClass().newInstance();
                cls.setOptions(optionsArray);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
            this.wekaSegmentation.setClassifier(cls);
            this.win.trainingComplete = false;
            Weka_Segmentation.record(SET_CLASSIFIER, c2.getClass().getName(), options);
            IJ.log((String)("Current classifier: " + c2.getClass().getName() + " " + options));
        }
        boolean classNameChanged = false;
        for (int i = 0; i < this.wekaSegmentation.getNumOfClasses(); ++i) {
            String s = gd.getNextString();
            if (null == s || 0 == s.length()) {
                IJ.log((String)("Invalid name for class " + (i + 1)));
                continue;
            }
            if ((s = s.trim()).equals(this.wekaSegmentation.getClassLabel(i))) continue;
            if (0 == s.toLowerCase().indexOf("add to ")) {
                s = s.substring(7);
            }
            this.wekaSegmentation.setClassLabel(i, s);
            classNameChanged = true;
            this.addExampleButton[i].setText("Add to " + s);
            Weka_Segmentation.record(CHANGE_CLASS_NAME, Integer.toString(i), s);
        }
        boolean balanceClasses = gd.getNextBoolean();
        if (this.wekaSegmentation.doClassBalance() != balanceClasses) {
            this.wekaSegmentation.setClassBalance(balanceClasses);
            Weka_Segmentation.record(SET_BALANCE, Boolean.toString(balanceClasses));
        }
        if ((newOpacity = (int)gd.getNextNumber()) != this.win.overlayOpacity) {
            this.win.overlayOpacity = newOpacity;
            this.win.overlayAlpha = AlphaComposite.getInstance(3, (float)this.win.overlayOpacity / 100.0f);
            this.win.resultOverlay.setComposite(this.win.overlayAlpha);
            Weka_Segmentation.record(SET_OPACITY, Integer.toString(this.win.overlayOpacity));
            if (this.showColorOverlay) {
                this.displayImage.updateAndDraw();
            }
        }
        if (classNameChanged) {
            this.win.pack();
        }
        if (featuresChanged) {
            this.wekaSegmentation.setFeaturesDirty();
        } else if (!this.wekaSegmentation.getFeatureStackArray().isEmpty() && this.wekaSegmentation.getFeatureStackArray().getReferenceSliceIndex() != -1) {
            this.wekaSegmentation.setUpdateFeatures(false);
        }
        return true;
    }

    public static void record(String command, String ... args) {
        command = "call(\"trainableSegmentation.Weka_Segmentation." + command;
        for (int i = 0; i < args.length; ++i) {
            command = command + "\", \"" + args[i];
        }
        command = command + "\");\n";
        if (IJ.isWindows()) {
            command = command.replaceAll("\\\\", "\\\\\\\\");
        }
        if (Recorder.record) {
            Recorder.recordString((String)command);
        }
    }

    public static void addTrace(String classNum, String nSlice) {
        ImageWindow iw = WindowManager.getCurrentImage().getWindow();
        if (iw instanceof CustomWindow) {
            CustomWindow win = (CustomWindow)iw;
            WekaSegmentation wekaSegmentation = win.getWekaSegmentation();
            Roi roi = win.getDisplayImage().getRoi();
            wekaSegmentation.addExample(Integer.parseInt(classNum), roi, Integer.parseInt(nSlice));
            win.getDisplayImage().killRoi();
            win.drawExamples();
            win.updateExampleLists();
        }
    }

    public static void deleteTrace(String classNum, String nSlice, String index) {
        ImageWindow iw = WindowManager.getCurrentImage().getWindow();
        if (iw instanceof CustomWindow) {
            CustomWindow win = (CustomWindow)iw;
            WekaSegmentation wekaSegmentation = win.getWekaSegmentation();
            wekaSegmentation.deleteExample(Integer.parseInt(classNum), Integer.parseInt(nSlice), Integer.parseInt(index));
            win.getDisplayImage().killRoi();
            win.drawExamples();
            win.updateExampleLists();
        }
    }

    public static void trainClassifier() {
        ImageWindow iw = WindowManager.getCurrentImage().getWindow();
        if (iw instanceof CustomWindow) {
            CustomWindow win = (CustomWindow)iw;
            WekaSegmentation wekaSegmentation = win.getWekaSegmentation();
            win.setButtonsEnabled(false);
            win.setTrainingComplete(false);
            if (wekaSegmentation.trainClassifier()) {
                win.setTrainingComplete(true);
                wekaSegmentation.applyClassifier(false);
                win.setClassfiedImage(wekaSegmentation.getClassifiedImage());
                if (win.isToogleEnabled()) {
                    win.toggleOverlay();
                }
                win.toggleOverlay();
            }
            win.updateButtonsEnabling();
        }
    }

    public static void getResult() {
        ImageWindow iw = WindowManager.getCurrentImage().getWindow();
        if (iw instanceof CustomWindow) {
            CustomWindow win = (CustomWindow)iw;
            WekaSegmentation wekaSegmentation = win.getWekaSegmentation();
            ImagePlus classifiedImage = wekaSegmentation.getClassifiedImage();
            if (null == classifiedImage) {
                if (win.trainingComplete) {
                    win.setButtonsEnabled(false);
                    wekaSegmentation.applyClassifier(false);
                    classifiedImage = wekaSegmentation.getClassifiedImage();
                    win.updateButtonsEnabling();
                } else {
                    IJ.log((String)"Result image could not be created:  you need to train or load a classifier first.");
                    return;
                }
            }
            ImagePlus resultImage = classifiedImage.duplicate();
            resultImage.setTitle("Classified image");
            Weka_Segmentation.convertTo8bitNoScaling(resultImage);
            resultImage.getProcessor().setColorModel((ColorModel)win.getOverlayLUT());
            resultImage.getImageStack().setColorModel((ColorModel)win.getOverlayLUT());
            resultImage.updateAndDraw();
            resultImage.show();
        }
    }

    public static void getProbability() {
        ImageWindow iw = WindowManager.getCurrentImage().getWindow();
        if (iw instanceof CustomWindow) {
            CustomWindow win = (CustomWindow)iw;
            WekaSegmentation wekaSegmentation = win.getWekaSegmentation();
            IJ.showStatus((String)"Calculating probability maps...");
            IJ.log((String)"Calculating probability maps...");
            win.setButtonsEnabled(false);
            wekaSegmentation.applyClassifier(true);
            ImagePlus probImage = wekaSegmentation.getClassifiedImage();
            if (null != probImage) {
                probImage.setDimensions(wekaSegmentation.getNumOfClasses(), win.getTrainingImage().getNSlices(), win.getTrainingImage().getNFrames());
                if (win.getTrainingImage().getNSlices() * win.getTrainingImage().getNFrames() > 1) {
                    probImage.setOpenAsHyperStack(true);
                }
                probImage.show();
            }
            win.updateButtonsEnabling();
            IJ.showStatus((String)"Done.");
            IJ.log((String)"Done");
        }
    }

    public static void plotResultGraphs() {
        ImageWindow iw = WindowManager.getCurrentImage().getWindow();
        if (iw instanceof CustomWindow) {
            CustomWindow win = (CustomWindow)iw;
            WekaSegmentation wekaSegmentation = win.getWekaSegmentation();
            IJ.showStatus((String)"Evaluating current data...");
            IJ.log((String)"Evaluating current data...");
            win.setButtonsEnabled(false);
            Instances data = wekaSegmentation.getTraceTrainingData() != null ? wekaSegmentation.getTraceTrainingData() : wekaSegmentation.getLoadedTrainingData();
            if (null == data) {
                IJ.error((String)"Error in plot result", (String)"No data available yet to display results");
                return;
            }
            Weka_Segmentation.displayGraphs(data, wekaSegmentation.getClassifier());
            win.updateButtonsEnabling();
            IJ.showStatus((String)"Done.");
            IJ.log((String)"Done");
        }
    }

    public static void applyClassifier(String dir, String fileName, String showResultsFlag, String storeResultsFlag, String probabilityMapsFlag, String storeDir) {
        ImageWindow iw = WindowManager.getCurrentImage().getWindow();
        if (iw instanceof CustomWindow) {
            CustomWindow win = (CustomWindow)iw;
            WekaSegmentation wekaSegmentation = win.getWekaSegmentation();
            ImagePlus testImage = IJ.openImage((String)(dir + File.separator + fileName));
            if (null == testImage) {
                IJ.log((String)("Error: " + dir + File.separator + fileName + " could not be opened"));
                return;
            }
            boolean probabilityMaps = probabilityMapsFlag.contains("true");
            boolean storeResults = storeResultsFlag.contains("true");
            boolean showResults = showResultsFlag.contains("true");
            IJ.log((String)("Processing image " + dir + File.separator + fileName));
            ImagePlus segmentation = wekaSegmentation.applyClassifier(testImage, 0, probabilityMaps);
            if (!probabilityMaps) {
                Weka_Segmentation.convertTo8bitNoScaling(segmentation);
                segmentation.getProcessor().setColorModel((ColorModel)win.getOverlayLUT());
                segmentation.getImageStack().setColorModel((ColorModel)win.getOverlayLUT());
                segmentation.updateAndDraw();
            }
            if (showResults) {
                segmentation.show();
                testImage.show();
            }
            if (storeResults) {
                String filename = storeDir + File.separator + fileName;
                IJ.log((String)("Saving results to " + filename));
                IJ.save((ImagePlus)segmentation, (String)filename);
                segmentation.close();
                testImage.close();
            }
        }
    }

    public static void toggleOverlay() {
        ImageWindow iw = WindowManager.getCurrentImage().getWindow();
        if (iw instanceof CustomWindow) {
            CustomWindow win = (CustomWindow)iw;
            win.toggleOverlay();
        }
    }

    public static void loadClassifier(String newClassifierPathName) {
        ImageWindow iw = WindowManager.getCurrentImage().getWindow();
        if (iw instanceof CustomWindow) {
            CustomWindow win = (CustomWindow)iw;
            WekaSegmentation wekaSegmentation = win.getWekaSegmentation();
            IJ.log((String)("Loading Weka classifier from " + newClassifierPathName + "..."));
            win.setButtonsEnabled(false);
            AbstractClassifier oldClassifier = wekaSegmentation.getClassifier();
            if (!wekaSegmentation.loadClassifier(newClassifierPathName)) {
                IJ.error((String)"Error when loading Weka classifier from file");
                win.updateButtonsEnabling();
                return;
            }
            IJ.log((String)("Read header from " + newClassifierPathName + " (number of attributes = " + wekaSegmentation.getTrainHeader().numAttributes() + ")"));
            if (wekaSegmentation.getTrainHeader().numAttributes() < 1) {
                IJ.error((String)"Error", (String)"No attributes were found on the model header");
                wekaSegmentation.setClassifier(oldClassifier);
                win.updateButtonsEnabling();
                return;
            }
            win.trainingComplete = true;
            win.updateAddClassButtons();
            IJ.log((String)("Loaded " + newClassifierPathName));
        }
    }

    public static void saveClassifier(String classifierPathName) {
        CustomWindow win;
        WekaSegmentation wekaSegmentation;
        ImageWindow iw = WindowManager.getCurrentImage().getWindow();
        if (iw instanceof CustomWindow && !(wekaSegmentation = (win = (CustomWindow)iw).getWekaSegmentation()).saveClassifier(classifierPathName)) {
            IJ.error((String)"Error while writing classifier into a file");
            return;
        }
    }

    public static void loadData(String arffFilePathName) {
        ImageWindow iw = WindowManager.getCurrentImage().getWindow();
        if (iw instanceof CustomWindow) {
            CustomWindow win = (CustomWindow)iw;
            WekaSegmentation wekaSegmentation = win.getWekaSegmentation();
            win.setButtonsEnabled(false);
            IJ.log((String)("Loading data from " + arffFilePathName + "..."));
            wekaSegmentation.loadTrainingData(arffFilePathName);
            win.updateButtonsEnabling();
        }
    }

    public static void saveData(String arffFilePathName) {
        CustomWindow win;
        WekaSegmentation wekaSegmentation;
        ImageWindow iw = WindowManager.getCurrentImage().getWindow();
        if (iw instanceof CustomWindow && !(wekaSegmentation = (win = (CustomWindow)iw).getWekaSegmentation()).saveData(arffFilePathName)) {
            IJ.showMessage((String)"There is no data to save");
        }
    }

    public static void createNewClass(String inputName) {
        ImageWindow iw = WindowManager.getCurrentImage().getWindow();
        if (iw instanceof CustomWindow) {
            CustomWindow win = (CustomWindow)iw;
            WekaSegmentation wekaSegmentation = win.getWekaSegmentation();
            if (null == inputName || 0 == inputName.length()) {
                IJ.error((String)"Invalid name for class");
                return;
            }
            if (0 == (inputName = inputName.trim()).toLowerCase().indexOf("add to ")) {
                inputName = inputName.substring(7);
            }
            wekaSegmentation.setClassLabel(wekaSegmentation.getNumOfClasses(), inputName);
            wekaSegmentation.addClass();
            win.addClass();
            win.updateAddClassButtons();
        }
    }

    public static void setMembraneThickness(String newThicknessStr) {
        ImageWindow iw = WindowManager.getCurrentImage().getWindow();
        if (iw instanceof CustomWindow) {
            WekaSegmentation wekaSegmentation;
            CustomWindow win = (CustomWindow)iw;
            int newThickness = Integer.parseInt(newThicknessStr);
            if (newThickness != (wekaSegmentation = win.getWekaSegmentation()).getMembraneThickness()) {
                wekaSegmentation.setFeaturesDirty();
            }
            wekaSegmentation.setMembraneThickness(newThickness);
        }
    }

    public static void setMembranePatchSize(String newPatchSizeStr) {
        ImageWindow iw = WindowManager.getCurrentImage().getWindow();
        if (iw instanceof CustomWindow) {
            CustomWindow win = (CustomWindow)iw;
            WekaSegmentation wekaSegmentation = win.getWekaSegmentation();
            int newPatchSize = Integer.parseInt(newPatchSizeStr);
            if (newPatchSize != wekaSegmentation.getMembranePatchSize()) {
                wekaSegmentation.setFeaturesDirty();
            }
            wekaSegmentation.setMembranePatchSize(newPatchSize);
        }
    }

    public static void setMinimumSigma(String newMinSigmaStr) {
        ImageWindow iw = WindowManager.getCurrentImage().getWindow();
        if (iw instanceof CustomWindow) {
            CustomWindow win = (CustomWindow)iw;
            WekaSegmentation wekaSegmentation = win.getWekaSegmentation();
            float newMinSigma = Float.parseFloat(newMinSigmaStr);
            if (newMinSigma != wekaSegmentation.getMinimumSigma() && newMinSigma > 0.0f) {
                wekaSegmentation.setFeaturesDirty();
                wekaSegmentation.setMinimumSigma(newMinSigma);
            }
            if (wekaSegmentation.getMinimumSigma() >= wekaSegmentation.getMaximumSigma()) {
                IJ.error((String)"Error in the field of view parameters: they will be reset to default values");
                wekaSegmentation.setMinimumSigma(0.0f);
                wekaSegmentation.setMaximumSigma(16.0f);
            }
        }
    }

    public static void setMaximumSigma(String newMaxSigmaStr) {
        ImageWindow iw = WindowManager.getCurrentImage().getWindow();
        if (iw instanceof CustomWindow) {
            CustomWindow win = (CustomWindow)iw;
            WekaSegmentation wekaSegmentation = win.getWekaSegmentation();
            float newMaxSigma = Float.parseFloat(newMaxSigmaStr);
            if (newMaxSigma != wekaSegmentation.getMaximumSigma() && newMaxSigma > wekaSegmentation.getMinimumSigma()) {
                wekaSegmentation.setFeaturesDirty();
                wekaSegmentation.setMaximumSigma(newMaxSigma);
            }
            if (wekaSegmentation.getMinimumSigma() >= wekaSegmentation.getMaximumSigma()) {
                IJ.error((String)"Error in the field of view parameters: they will be reset to default values");
                wekaSegmentation.setMinimumSigma(0.0f);
                wekaSegmentation.setMaximumSigma(16.0f);
            }
        }
    }

    public static void setClassHomogenization(String flagStr) {
        Weka_Segmentation.setClassBalance(flagStr);
    }

    public static void setClassBalance(String flagStr) {
        ImageWindow iw = WindowManager.getCurrentImage().getWindow();
        if (iw instanceof CustomWindow) {
            CustomWindow win = (CustomWindow)iw;
            boolean flag = Boolean.parseBoolean(flagStr);
            WekaSegmentation wekaSegmentation = win.getWekaSegmentation();
            wekaSegmentation.setClassBalance(flag);
        }
    }

    public static void setClassifier(String classifierName, String options) {
        ImageWindow iw = WindowManager.getCurrentImage().getWindow();
        if (iw instanceof CustomWindow) {
            CustomWindow win = (CustomWindow)iw;
            WekaSegmentation wekaSegmentation = win.getWekaSegmentation();
            try {
                AbstractClassifier cls = (AbstractClassifier)Class.forName(classifierName).newInstance();
                cls.setOptions(options.split(" "));
                wekaSegmentation.setClassifier(cls);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveFeatureStack(String dir, String fileWithExt) {
        ImageWindow iw = WindowManager.getCurrentImage().getWindow();
        if (iw instanceof CustomWindow) {
            CustomWindow win = (CustomWindow)iw;
            WekaSegmentation wekaSegmentation = win.getWekaSegmentation();
            FeatureStackArray featureStackArray = wekaSegmentation.getFeatureStackArray();
            if (featureStackArray.isEmpty()) {
                featureStackArray.updateFeaturesMT();
            }
            if (null == dir || null == fileWithExt) {
                return;
            }
            for (int i = 0; i < featureStackArray.getSize(); ++i) {
                String fileName = dir + fileWithExt.substring(0, fileWithExt.length() - 4) + String.format("%04d", i + 1) + ".tif";
                if (!featureStackArray.get(i).saveStackAsTiff(fileName)) {
                    IJ.error((String)"Error", (String)"Feature stack could not be saved");
                    return;
                }
                IJ.log((String)("Saved feature stack for slice " + (i + 1) + " as " + fileName));
            }
        }
    }

    public static void changeClassName(String classIndex, String className) {
        ImageWindow iw = WindowManager.getCurrentImage().getWindow();
        if (iw instanceof CustomWindow) {
            CustomWindow win = (CustomWindow)iw;
            WekaSegmentation wekaSegmentation = win.getWekaSegmentation();
            int classNum = Integer.parseInt(classIndex);
            wekaSegmentation.setClassLabel(classNum, className);
            win.updateAddClassButtons();
            win.pack();
        }
    }

    public static void setFeature(String feature) {
        ImageWindow iw = WindowManager.getCurrentImage().getWindow();
        if (iw instanceof CustomWindow) {
            CustomWindow win = (CustomWindow)iw;
            WekaSegmentation wekaSegmentation = win.getWekaSegmentation();
            boolean isProcessing3D = wekaSegmentation.isProcessing3D();
            int index = feature.indexOf("=");
            String featureName = feature.substring(0, index);
            boolean featureValue = feature.contains("true");
            boolean[] enabledFeatures = wekaSegmentation.getEnabledFeatures();
            boolean forceUpdate = false;
            for (int i = 0; i < enabledFeatures.length; ++i) {
                String availableFeature;
                String string = availableFeature = isProcessing3D ? FeatureStack3D.availableFeatures[i] : FeatureStack.availableFeatures[i];
                if (!availableFeature.equals(featureName) || featureValue == enabledFeatures[i]) continue;
                enabledFeatures[i] = featureValue;
                forceUpdate = true;
            }
            wekaSegmentation.setEnabledFeatures(enabledFeatures);
            if (forceUpdate) {
                wekaSegmentation.setFeaturesDirty();
            }
        }
    }

    public static void setOpacity(String newOpacity) {
        ImageWindow iw = WindowManager.getCurrentImage().getWindow();
        if (iw instanceof CustomWindow) {
            CustomWindow win = (CustomWindow)iw;
            win.overlayOpacity = Integer.parseInt(newOpacity);
            AlphaComposite alpha = AlphaComposite.getInstance(3, (float)win.overlayOpacity / 100.0f);
            win.resultOverlay.setComposite(alpha);
        }
    }

    public static void changeClassColor(String classNum, String color) {
        ImageWindow iw = WindowManager.getCurrentImage().getWindow();
        if (iw instanceof CustomWindow) {
            CustomWindow win = (CustomWindow)iw;
            int i = Integer.parseInt(classNum);
            Color[] colors = win.getOverlayColors();
            colors[i] = Color.decode(color);
            LUT overlayLUT = Utils.createLUT(colors);
            win.setOverlayLUT(overlayLUT);
            win.getDisplayImage().killRoi();
            win.drawExamples();
            win.updateExampleLists();
        }
    }

    public static void disableMissingFeatures(GenericDialog gd) {
        if (!Weka_Segmentation.isImageScienceAvailable()) {
            IJ.log((String)"Warning: ImageScience library unavailable. Some training features will be disabled.");
            Vector v = gd.getCheckboxes();
            for (int i = 0; i < v.size(); ++i) {
                if (!FeatureStack.IMAGESCIENCE_FEATURES[i]) continue;
                ((Checkbox)v.get(i)).setState(false);
                ((Checkbox)v.get(i)).setEnabled(false);
            }
        }
    }

    private static boolean isImageScienceAvailable() {
        try {
            return ImageScience.isAvailable();
        }
        catch (NoClassDefFoundError err) {
            return false;
        }
    }

    public static ImagePlus getLabelImage() {
        ImageWindow iw = WindowManager.getCurrentImage().getWindow();
        if (iw instanceof CustomWindow) {
            CustomWindow win = (CustomWindow)iw;
            WekaSegmentation wekaSegmentation = win.getWekaSegmentation();
            int numClasses = wekaSegmentation.getNumOfClasses();
            int width = win.getTrainingImage().getWidth();
            int height = win.getTrainingImage().getHeight();
            int depth = win.getTrainingImage().getNSlices();
            ImageStack labelStack = numClasses < 256 ? ImageStack.create((int)width, (int)height, (int)depth, (int)8) : (numClasses < 65536 ? ImageStack.create((int)width, (int)height, (int)depth, (int)16) : ImageStack.create((int)width, (int)height, (int)depth, (int)32));
            ImagePlus labelImage = new ImagePlus("Labels", labelStack);
            for (int i = 0; i < depth; ++i) {
                labelImage.setSlice(i + 1);
                for (int j = 0; j < numClasses; ++j) {
                    java.util.List<Roi> rois = wekaSegmentation.getExamples(j, i + 1);
                    for (Roi r : rois) {
                        ImageProcessor ip = labelImage.getProcessor();
                        ip.setValue((double)(j + 1));
                        if (r.isLine()) {
                            ip.setLineWidth(Math.round(r.getStrokeWidth()));
                            ip.draw(r);
                            continue;
                        }
                        ip.fill(r);
                    }
                }
            }
            labelImage.setSlice(1);
            labelImage.setDisplayRange(0.0, (double)numClasses);
            return labelImage;
        }
        return null;
    }

    static /* synthetic */ Color[] access$3002(Weka_Segmentation x0, Color[] x1) {
        x0.colors = x1;
        return x1;
    }

    static {
        try {
            IJ.showStatus((String)"Loading Weka properties...");
            IJ.log((String)"Loading Weka properties...");
            Field field = GenericObjectEditor.class.getDeclaredField("EDITOR_PROPERTIES");
            field.setAccessible(true);
            Properties editorProperties = (Properties)field.get(null);
            String key = "weka.classifiers.Classifier";
            String value = editorProperties.getProperty(key);
            value = value + ",hr.irb.fastRandomForest.FastRandomForest";
            editorProperties.setProperty(key, value);
            WekaPackageManager.loadPackages((boolean)true);
            PluginManager.addFromProperties((Properties)editorProperties);
        }
        catch (Exception e) {
            IJ.error((String)"Could not insert my own cool classifiers!");
        }
    }

    static class SaveFeatureStackButtonListener
    implements ActionListener {
        private String title;
        private TextField text;
        private WekaSegmentation wekaSegmentation;

        public SaveFeatureStackButtonListener(String title, WekaSegmentation wekaSegmentation) {
            this.title = title;
            this.wekaSegmentation = wekaSegmentation;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SaveDialog sd = new SaveDialog(this.title, "feature-stack", ".tif");
            String dir = sd.getDirectory();
            String fileWithExt = sd.getFileName();
            if (null == dir || null == fileWithExt) {
                return;
            }
            FeatureStackArray featureStackArray = this.wekaSegmentation.getFeatureStackArray();
            for (int i = 0; i < featureStackArray.getSize(); ++i) {
                this.wekaSegmentation.saveFeatureStack(i + 1, dir, fileWithExt);
            }
            Weka_Segmentation.record(Weka_Segmentation.SAVE_FEATURE_STACK, dir, fileWithExt);
        }
    }

    private class CustomWindow
    extends StackWindow {
        private static final long serialVersionUID = 1L;
        private GridBagLayout boxAnnotation;
        private GridBagConstraints annotationsConstraints;
        private JScrollPane scrollPanel;
        private JPanel labelsJPanel;
        private JPanel annotationsPanel;
        private JPanel buttonsPanel;
        private JPanel trainingJPanel;
        private JPanel optionsJPanel;
        private Panel all;
        private final Composite transparency050;
        private int overlayOpacity;
        private Composite overlayAlpha;
        private ImageOverlay resultOverlay;
        private boolean trainingComplete;

        CustomWindow(ImagePlus imp) {
            int i;
            int canvasWidth;
            super(imp, (ImageCanvas)new CustomCanvas(imp));
            this.boxAnnotation = new GridBagLayout();
            this.annotationsConstraints = new GridBagConstraints();
            this.scrollPanel = null;
            this.labelsJPanel = new JPanel();
            this.annotationsPanel = new JPanel();
            this.buttonsPanel = new JPanel();
            this.trainingJPanel = new JPanel();
            this.optionsJPanel = new JPanel();
            this.all = new Panel();
            this.transparency050 = AlphaComposite.getInstance(3, 0.5f);
            this.overlayOpacity = 33;
            this.overlayAlpha = AlphaComposite.getInstance(3, (float)this.overlayOpacity / 100.0f);
            this.trainingComplete = false;
            final CustomCanvas canvas = (CustomCanvas)this.getCanvas();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            double screenWidth = screenSize.getWidth();
            double screenHeight = screenSize.getHeight();
            while (((double)this.ic.getWidth() < screenWidth / 2.0 || (double)this.ic.getHeight() < screenHeight / 2.0) && this.ic.getMagnification() < 32.0) {
                canvasWidth = this.ic.getWidth();
                this.ic.zoomIn(0, 0);
                if (canvasWidth != this.ic.getWidth()) continue;
                this.ic.zoomOut(0, 0);
                break;
            }
            while (((double)this.ic.getWidth() > 0.75 * screenWidth || (double)this.ic.getHeight() > 0.75 * screenHeight) && this.ic.getMagnification() > 0.013888888888888888) {
                canvasWidth = this.ic.getWidth();
                this.ic.zoomOut(0, 0);
                if (canvasWidth != this.ic.getWidth()) continue;
                this.ic.zoomIn(0, 0);
                break;
            }
            for (i = 0; i < 100; ++i) {
                ((Weka_Segmentation)Weka_Segmentation.this).roiOverlay[i] = new RoiListOverlay();
                Weka_Segmentation.this.roiOverlay[i].setComposite(this.transparency050);
                ((OverlayedImageCanvas)this.ic).addOverlay((OverlayedImageCanvas.Overlay)Weka_Segmentation.this.roiOverlay[i]);
            }
            this.resultOverlay = new ImageOverlay();
            this.resultOverlay.setComposite(this.overlayAlpha);
            ((OverlayedImageCanvas)this.ic).addOverlay((OverlayedImageCanvas.Overlay)this.resultOverlay);
            this.removeAll();
            this.setTitle("Trainable Weka Segmentation " + PLUGIN_VERSION);
            this.annotationsConstraints.anchor = 18;
            this.annotationsConstraints.fill = 2;
            this.annotationsConstraints.gridwidth = 1;
            this.annotationsConstraints.gridheight = 1;
            this.annotationsConstraints.gridx = 0;
            this.annotationsConstraints.gridy = 0;
            this.annotationsPanel.setBorder(BorderFactory.createTitledBorder("Labels"));
            this.annotationsPanel.setLayout(this.boxAnnotation);
            for (i = 0; i < Weka_Segmentation.this.wekaSegmentation.getNumOfClasses(); ++i) {
                Weka_Segmentation.this.exampleList[i].addActionListener(Weka_Segmentation.this.listener);
                Weka_Segmentation.this.exampleList[i].addItemListener(Weka_Segmentation.this.itemListener);
                ((Weka_Segmentation)Weka_Segmentation.this).addExampleButton[i] = new JButton("Add to " + Weka_Segmentation.this.wekaSegmentation.getClassLabel(i));
                Weka_Segmentation.this.addExampleButton[i].setToolTipText("Add markings of label '" + Weka_Segmentation.this.wekaSegmentation.getClassLabel(i) + "'");
                this.annotationsConstraints.insets = new Insets(5, 5, 6, 6);
                this.annotationsPanel.add((Component)Weka_Segmentation.this.addExampleButton[i], this.annotationsConstraints);
                ++this.annotationsConstraints.gridy;
                this.annotationsConstraints.insets = new Insets(0, 0, 0, 0);
                this.annotationsPanel.add((Component)Weka_Segmentation.this.exampleList[i], this.annotationsConstraints);
                ++this.annotationsConstraints.gridy;
            }
            Weka_Segmentation.this.addExampleButton[0].setSelected(true);
            for (i = 0; i < Weka_Segmentation.this.wekaSegmentation.getNumOfClasses(); ++i) {
                Weka_Segmentation.this.addExampleButton[i].addActionListener(Weka_Segmentation.this.listener);
                Weka_Segmentation.this.addExampleButton[i].addMouseListener(Weka_Segmentation.this.mouseListener);
            }
            Weka_Segmentation.this.trainButton.addActionListener(Weka_Segmentation.this.listener);
            Weka_Segmentation.this.overlayButton.addActionListener(Weka_Segmentation.this.listener);
            Weka_Segmentation.this.resultButton.addActionListener(Weka_Segmentation.this.listener);
            Weka_Segmentation.this.probabilityButton.addActionListener(Weka_Segmentation.this.listener);
            Weka_Segmentation.this.plotButton.addActionListener(Weka_Segmentation.this.listener);
            Weka_Segmentation.this.applyButton.addActionListener(Weka_Segmentation.this.listener);
            Weka_Segmentation.this.loadClassifierButton.addActionListener(Weka_Segmentation.this.listener);
            Weka_Segmentation.this.saveClassifierButton.addActionListener(Weka_Segmentation.this.listener);
            Weka_Segmentation.this.loadDataButton.addActionListener(Weka_Segmentation.this.listener);
            Weka_Segmentation.this.saveDataButton.addActionListener(Weka_Segmentation.this.listener);
            Weka_Segmentation.this.addClassButton.addActionListener(Weka_Segmentation.this.listener);
            Weka_Segmentation.this.settingsButton.addActionListener(Weka_Segmentation.this.listener);
            Weka_Segmentation.this.wekaButton.addActionListener(Weka_Segmentation.this.listener);
            if (null != this.sliceSelector) {
                this.sliceSelector.setValue(imp.getCurrentSlice());
                this.sliceSelector.addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(final AdjustmentEvent e) {
                        Weka_Segmentation.this.exec.submit(new Runnable(){

                            @Override
                            public void run() {
                                if (e.getSource() == CustomWindow.this.sliceSelector) {
                                    Weka_Segmentation.this.displayImage.killRoi();
                                    CustomWindow.this.drawExamples();
                                    CustomWindow.this.updateExampleLists();
                                    if (Weka_Segmentation.this.showColorOverlay) {
                                        Weka_Segmentation.this.updateResultOverlay();
                                        Weka_Segmentation.this.displayImage.updateAndDraw();
                                    }
                                }
                            }
                        });
                    }
                });
                this.addMouseWheelListener(new MouseWheelListener(){

                    @Override
                    public void mouseWheelMoved(MouseWheelEvent e) {
                        Weka_Segmentation.this.exec.submit(new Runnable(){

                            @Override
                            public void run() {
                                Weka_Segmentation.this.displayImage.killRoi();
                                CustomWindow.this.drawExamples();
                                CustomWindow.this.updateExampleLists();
                                if (Weka_Segmentation.this.showColorOverlay) {
                                    Weka_Segmentation.this.updateResultOverlay();
                                    Weka_Segmentation.this.displayImage.updateAndDraw();
                                }
                            }
                        });
                    }
                });
                KeyListener keyListener = new KeyListener(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                    }

                    @Override
                    public void keyReleased(final KeyEvent e) {
                        Weka_Segmentation.this.exec.submit(new Runnable(){

                            @Override
                            public void run() {
                                if (e.getKeyCode() == 37 || e.getKeyCode() == 39 || e.getKeyCode() == 153 || e.getKeyCode() == 160 || e.getKeyCode() == 44 || e.getKeyCode() == 46) {
                                    Weka_Segmentation.this.displayImage.killRoi();
                                    CustomWindow.this.updateExampleLists();
                                    CustomWindow.this.drawExamples();
                                    if (Weka_Segmentation.this.showColorOverlay) {
                                        Weka_Segmentation.this.updateResultOverlay();
                                        Weka_Segmentation.this.displayImage.updateAndDraw();
                                    }
                                }
                            }
                        });
                    }

                    @Override
                    public void keyPressed(KeyEvent e) {
                    }
                };
                this.addKeyListener(keyListener);
                canvas.addKeyListener(keyListener);
            }
            GridBagLayout labelsLayout = new GridBagLayout();
            GridBagConstraints labelsConstraints = new GridBagConstraints();
            this.labelsJPanel.setLayout(labelsLayout);
            labelsConstraints.anchor = 18;
            labelsConstraints.fill = 2;
            labelsConstraints.gridwidth = 1;
            labelsConstraints.gridheight = 1;
            labelsConstraints.gridx = 0;
            labelsConstraints.gridy = 0;
            this.labelsJPanel.add((Component)this.annotationsPanel, labelsConstraints);
            this.scrollPanel = new JScrollPane(this.labelsJPanel);
            this.scrollPanel.setHorizontalScrollBarPolicy(31);
            this.scrollPanel.setMinimumSize(this.labelsJPanel.getPreferredSize());
            this.trainingJPanel.setBorder(BorderFactory.createTitledBorder("Training"));
            GridBagLayout trainingLayout = new GridBagLayout();
            GridBagConstraints trainingConstraints = new GridBagConstraints();
            trainingConstraints.anchor = 18;
            trainingConstraints.fill = 2;
            trainingConstraints.gridwidth = 1;
            trainingConstraints.gridheight = 1;
            trainingConstraints.gridx = 0;
            trainingConstraints.gridy = 0;
            trainingConstraints.insets = new Insets(5, 5, 6, 6);
            this.trainingJPanel.setLayout(trainingLayout);
            this.trainingJPanel.add((Component)Weka_Segmentation.this.trainButton, trainingConstraints);
            ++trainingConstraints.gridy;
            this.trainingJPanel.add((Component)Weka_Segmentation.this.overlayButton, trainingConstraints);
            ++trainingConstraints.gridy;
            this.trainingJPanel.add((Component)Weka_Segmentation.this.resultButton, trainingConstraints);
            ++trainingConstraints.gridy;
            this.trainingJPanel.add((Component)Weka_Segmentation.this.probabilityButton, trainingConstraints);
            ++trainingConstraints.gridy;
            this.trainingJPanel.add((Component)Weka_Segmentation.this.plotButton, trainingConstraints);
            ++trainingConstraints.gridy;
            this.optionsJPanel.setBorder(BorderFactory.createTitledBorder("Options"));
            GridBagLayout optionsLayout = new GridBagLayout();
            GridBagConstraints optionsConstraints = new GridBagConstraints();
            optionsConstraints.anchor = 18;
            optionsConstraints.fill = 2;
            optionsConstraints.gridwidth = 1;
            optionsConstraints.gridheight = 1;
            optionsConstraints.gridx = 0;
            optionsConstraints.gridy = 0;
            optionsConstraints.insets = new Insets(5, 5, 6, 6);
            this.optionsJPanel.setLayout(optionsLayout);
            this.optionsJPanel.add((Component)Weka_Segmentation.this.applyButton, optionsConstraints);
            ++optionsConstraints.gridy;
            this.optionsJPanel.add((Component)Weka_Segmentation.this.loadClassifierButton, optionsConstraints);
            ++optionsConstraints.gridy;
            this.optionsJPanel.add((Component)Weka_Segmentation.this.saveClassifierButton, optionsConstraints);
            ++optionsConstraints.gridy;
            this.optionsJPanel.add((Component)Weka_Segmentation.this.loadDataButton, optionsConstraints);
            ++optionsConstraints.gridy;
            this.optionsJPanel.add((Component)Weka_Segmentation.this.saveDataButton, optionsConstraints);
            ++optionsConstraints.gridy;
            this.optionsJPanel.add((Component)Weka_Segmentation.this.addClassButton, optionsConstraints);
            ++optionsConstraints.gridy;
            this.optionsJPanel.add((Component)Weka_Segmentation.this.settingsButton, optionsConstraints);
            ++optionsConstraints.gridy;
            this.optionsJPanel.add((Component)Weka_Segmentation.this.wekaButton, optionsConstraints);
            ++optionsConstraints.gridy;
            GridBagLayout buttonsLayout = new GridBagLayout();
            GridBagConstraints buttonsConstraints = new GridBagConstraints();
            this.buttonsPanel.setLayout(buttonsLayout);
            buttonsConstraints.anchor = 18;
            buttonsConstraints.fill = 2;
            buttonsConstraints.gridwidth = 1;
            buttonsConstraints.gridheight = 1;
            buttonsConstraints.gridx = 0;
            buttonsConstraints.gridy = 0;
            this.buttonsPanel.add((Component)this.trainingJPanel, buttonsConstraints);
            ++buttonsConstraints.gridy;
            this.buttonsPanel.add((Component)this.optionsJPanel, buttonsConstraints);
            ++buttonsConstraints.gridy;
            buttonsConstraints.insets = new Insets(5, 5, 6, 6);
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints allConstraints = new GridBagConstraints();
            this.all.setLayout(layout);
            allConstraints.anchor = 18;
            allConstraints.fill = 1;
            allConstraints.gridwidth = 1;
            allConstraints.gridheight = 2;
            allConstraints.gridx = 0;
            allConstraints.gridy = 0;
            allConstraints.weightx = 0.0;
            allConstraints.weighty = 0.0;
            this.all.add((Component)this.buttonsPanel, allConstraints);
            ++allConstraints.gridx;
            allConstraints.weightx = 1.0;
            allConstraints.weighty = 1.0;
            allConstraints.gridheight = 1;
            this.all.add((Component)((Object)canvas), allConstraints);
            ++allConstraints.gridy;
            allConstraints.weightx = 0.0;
            allConstraints.weighty = 0.0;
            if (null != this.sliceSelector) {
                this.all.add((Component)this.sliceSelector, allConstraints);
            }
            --allConstraints.gridy;
            ++allConstraints.gridx;
            allConstraints.anchor = 12;
            allConstraints.weightx = 0.0;
            allConstraints.weighty = 0.0;
            allConstraints.gridheight = 1;
            this.all.add((Component)this.scrollPanel, allConstraints);
            GridBagLayout wingb = new GridBagLayout();
            GridBagConstraints winc = new GridBagConstraints();
            winc.anchor = 18;
            winc.fill = 1;
            winc.weightx = 1.0;
            winc.weighty = 1.0;
            this.setLayout(wingb);
            this.add(this.all, winc);
            this.pack();
            this.setMinimumSize(this.getPreferredSize());
            for (Component p : new Component[]{this.all, this.buttonsPanel}) {
                for (KeyListener kl : this.getKeyListeners()) {
                    p.addKeyListener(kl);
                }
            }
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    super.windowClosing(e);
                    if (null != Weka_Segmentation.this.trainingImage) {
                        if (null == Weka_Segmentation.this.trainingImage.getWindow()) {
                            Weka_Segmentation.this.trainingImage.show();
                        }
                        Weka_Segmentation.this.trainingImage.getWindow().setVisible(true);
                    }
                    if (null != Weka_Segmentation.this.trainingTask) {
                        Weka_Segmentation.this.trainingTask.interrupt();
                    }
                    Weka_Segmentation.this.wekaSegmentation.shutDownNow();
                    Weka_Segmentation.this.exec.shutdownNow();
                    for (int i = 0; i < Weka_Segmentation.this.wekaSegmentation.getNumOfClasses(); ++i) {
                        Weka_Segmentation.this.addExampleButton[i].removeActionListener(Weka_Segmentation.this.listener);
                    }
                    Weka_Segmentation.this.trainButton.removeActionListener(Weka_Segmentation.this.listener);
                    Weka_Segmentation.this.overlayButton.removeActionListener(Weka_Segmentation.this.listener);
                    Weka_Segmentation.this.resultButton.removeActionListener(Weka_Segmentation.this.listener);
                    Weka_Segmentation.this.probabilityButton.removeActionListener(Weka_Segmentation.this.listener);
                    Weka_Segmentation.this.plotButton.removeActionListener(Weka_Segmentation.this.listener);
                    Weka_Segmentation.this.applyButton.removeActionListener(Weka_Segmentation.this.listener);
                    Weka_Segmentation.this.loadClassifierButton.removeActionListener(Weka_Segmentation.this.listener);
                    Weka_Segmentation.this.saveClassifierButton.removeActionListener(Weka_Segmentation.this.listener);
                    Weka_Segmentation.this.loadDataButton.removeActionListener(Weka_Segmentation.this.listener);
                    Weka_Segmentation.this.saveDataButton.removeActionListener(Weka_Segmentation.this.listener);
                    Weka_Segmentation.this.addClassButton.removeActionListener(Weka_Segmentation.this.listener);
                    Weka_Segmentation.this.settingsButton.removeActionListener(Weka_Segmentation.this.listener);
                    Weka_Segmentation.this.wekaButton.removeActionListener(Weka_Segmentation.this.listener);
                    Weka_Segmentation.this.wekaSegmentation.setNumOfClasses(2);
                }
            });
            canvas.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent ce) {
                    Rectangle r = canvas.getBounds();
                    canvas.setDstDimensions(r.width, r.height);
                }
            });
        }

        protected WekaSegmentation getWekaSegmentation() {
            return Weka_Segmentation.this.wekaSegmentation;
        }

        public LUT getOverlayLUT() {
            return Weka_Segmentation.this.overlayLUT;
        }

        public void setOverlayLUT(LUT lut) {
            Weka_Segmentation.this.overlayLUT = lut;
        }

        public Color[] getOverlayColors() {
            return Weka_Segmentation.this.colors;
        }

        public void setOverlayColors(Color[] newColors) {
            Weka_Segmentation.access$3002(Weka_Segmentation.this, newColors);
        }

        protected void drawExamples() {
            int currentSlice = Weka_Segmentation.this.displayImage.getCurrentSlice();
            for (int i = 0; i < Weka_Segmentation.this.wekaSegmentation.getNumOfClasses(); ++i) {
                Weka_Segmentation.this.roiOverlay[i].setColor(Weka_Segmentation.this.colors[i]);
                ArrayList<Roi> rois = new ArrayList<Roi>();
                for (Roi r : Weka_Segmentation.this.wekaSegmentation.getExamples(i, currentSlice)) {
                    rois.add(r);
                }
                Weka_Segmentation.this.roiOverlay[i].setRoi(rois);
            }
            Weka_Segmentation.this.displayImage.updateAndDraw();
        }

        protected void updateExampleLists() {
            int currentSlice = Weka_Segmentation.this.displayImage.getCurrentSlice();
            for (int i = 0; i < Weka_Segmentation.this.wekaSegmentation.getNumOfClasses(); ++i) {
                Weka_Segmentation.this.exampleList[i].removeAll();
                for (int j = 0; j < Weka_Segmentation.this.wekaSegmentation.getExamples(i, currentSlice).size(); ++j) {
                    Weka_Segmentation.this.exampleList[i].add("trace " + j + " (Z=" + currentSlice + ")");
                }
            }
        }

        protected boolean isToogleEnabled() {
            return Weka_Segmentation.this.showColorOverlay;
        }

        protected ImagePlus getDisplayImage() {
            return this.getImagePlus();
        }

        public void setSliceSelectorEnabled(boolean b) {
            if (null != this.sliceSelector) {
                this.sliceSelector.setEnabled(b);
            }
        }

        public void repaintAll() {
            this.annotationsPanel.repaint();
            this.getCanvas().repaint();
            this.buttonsPanel.repaint();
            this.all.repaint();
        }

        public void addClass() {
            int classNum = Weka_Segmentation.this.numOfClasses;
            ((Weka_Segmentation)Weka_Segmentation.this).exampleList[classNum] = new List(5);
            Weka_Segmentation.this.exampleList[classNum].setForeground(Weka_Segmentation.this.colors[classNum]);
            Weka_Segmentation.this.exampleList[classNum].addActionListener(Weka_Segmentation.this.listener);
            Weka_Segmentation.this.exampleList[classNum].addItemListener(Weka_Segmentation.this.itemListener);
            ((Weka_Segmentation)Weka_Segmentation.this).addExampleButton[classNum] = new JButton("Add to " + Weka_Segmentation.this.wekaSegmentation.getClassLabel(classNum));
            this.annotationsConstraints.fill = 2;
            this.annotationsConstraints.insets = new Insets(5, 5, 6, 6);
            this.boxAnnotation.setConstraints(Weka_Segmentation.this.addExampleButton[classNum], this.annotationsConstraints);
            this.annotationsPanel.add(Weka_Segmentation.this.addExampleButton[classNum]);
            ++this.annotationsConstraints.gridy;
            this.annotationsConstraints.insets = new Insets(0, 0, 0, 0);
            this.boxAnnotation.setConstraints(Weka_Segmentation.this.exampleList[classNum], this.annotationsConstraints);
            this.annotationsPanel.add(Weka_Segmentation.this.exampleList[classNum]);
            ++this.annotationsConstraints.gridy;
            Weka_Segmentation.this.addExampleButton[classNum].addActionListener(Weka_Segmentation.this.listener);
            Weka_Segmentation.this.numOfClasses++;
            this.scrollPanel.setMinimumSize(this.labelsJPanel.getPreferredSize());
            this.repaintAll();
        }

        public void setImagePlus(ImagePlus imp) {
            this.imp = imp;
            ((CustomCanvas)super.getCanvas()).setImagePlus(imp);
            Dimension dim = new Dimension(Math.min(512, imp.getWidth()), Math.min(512, imp.getHeight()));
            ((CustomCanvas)super.getCanvas()).setDstDimensions(dim.width, dim.height);
            imp.setWindow((ImageWindow)this);
            this.repaint();
        }

        protected void setButtonsEnabled(boolean s) {
            Weka_Segmentation.this.trainButton.setEnabled(s);
            Weka_Segmentation.this.overlayButton.setEnabled(s);
            Weka_Segmentation.this.resultButton.setEnabled(s);
            Weka_Segmentation.this.probabilityButton.setEnabled(s);
            Weka_Segmentation.this.plotButton.setEnabled(s);
            Weka_Segmentation.this.applyButton.setEnabled(s);
            Weka_Segmentation.this.loadClassifierButton.setEnabled(s);
            Weka_Segmentation.this.saveClassifierButton.setEnabled(s);
            Weka_Segmentation.this.loadDataButton.setEnabled(s);
            Weka_Segmentation.this.saveDataButton.setEnabled(s);
            Weka_Segmentation.this.addClassButton.setEnabled(s);
            Weka_Segmentation.this.settingsButton.setEnabled(s);
            Weka_Segmentation.this.wekaButton.setEnabled(s);
            for (int i = 0; i < Weka_Segmentation.this.wekaSegmentation.getNumOfClasses(); ++i) {
                Weka_Segmentation.this.exampleList[i].setEnabled(s);
                Weka_Segmentation.this.addExampleButton[i].setEnabled(s);
            }
            this.setSliceSelectorEnabled(s);
        }

        protected void updateButtonsEnabling() {
            if (Weka_Segmentation.this.trainingFlag) {
                this.setButtonsEnabled(false);
                Weka_Segmentation.this.trainButton.setEnabled(true);
            } else {
                int i;
                boolean classifierExists = null != Weka_Segmentation.this.wekaSegmentation.getClassifier();
                Weka_Segmentation.this.trainButton.setEnabled(classifierExists);
                Weka_Segmentation.this.applyButton.setEnabled(((Weka_Segmentation)Weka_Segmentation.this).win.trainingComplete);
                boolean resultExists = null != Weka_Segmentation.this.classifiedImage && null != Weka_Segmentation.this.classifiedImage.getProcessor();
                Weka_Segmentation.this.saveClassifierButton.setEnabled(((Weka_Segmentation)Weka_Segmentation.this).win.trainingComplete);
                Weka_Segmentation.this.overlayButton.setEnabled(resultExists);
                Weka_Segmentation.this.resultButton.setEnabled(((Weka_Segmentation)Weka_Segmentation.this).win.trainingComplete);
                Weka_Segmentation.this.plotButton.setEnabled(((Weka_Segmentation)Weka_Segmentation.this).win.trainingComplete);
                Weka_Segmentation.this.probabilityButton.setEnabled(((Weka_Segmentation)Weka_Segmentation.this).win.trainingComplete);
                Weka_Segmentation.this.loadClassifierButton.setEnabled(true);
                Weka_Segmentation.this.loadDataButton.setEnabled(true);
                Weka_Segmentation.this.addClassButton.setEnabled(Weka_Segmentation.this.wekaSegmentation.getNumOfClasses() < 100);
                Weka_Segmentation.this.settingsButton.setEnabled(true);
                Weka_Segmentation.this.wekaButton.setEnabled(true);
                boolean examplesEmpty = true;
                block0: for (int n = 1; n <= Weka_Segmentation.this.displayImage.getImageStackSize(); ++n) {
                    for (i = 0; i < Weka_Segmentation.this.wekaSegmentation.getNumOfClasses(); ++i) {
                        if (Weka_Segmentation.this.wekaSegmentation.getExamples(i, n).size() <= 0) continue;
                        examplesEmpty = false;
                        continue block0;
                    }
                }
                boolean loadedTrainingData = null != Weka_Segmentation.this.wekaSegmentation.getLoadedTrainingData();
                Weka_Segmentation.this.saveDataButton.setEnabled(!examplesEmpty || loadedTrainingData);
                for (i = 0; i < Weka_Segmentation.this.wekaSegmentation.getNumOfClasses(); ++i) {
                    Weka_Segmentation.this.exampleList[i].setEnabled(true);
                    Weka_Segmentation.this.addExampleButton[i].setEnabled(true);
                }
                this.setSliceSelectorEnabled(true);
            }
        }

        void toggleOverlay() {
            Weka_Segmentation.this.showColorOverlay = !Weka_Segmentation.this.showColorOverlay;
            if (Weka_Segmentation.this.showColorOverlay && null != Weka_Segmentation.this.classifiedImage) {
                Weka_Segmentation.this.updateResultOverlay();
            } else {
                this.resultOverlay.setImage(null);
            }
            Weka_Segmentation.this.displayImage.updateAndDraw();
        }

        protected void setClassfiedImage(ImagePlus classifiedImage) {
            Weka_Segmentation.this.updateClassifiedImage(classifiedImage);
        }

        public void updateAddClassButtons() {
            int wekaNumOfClasses = Weka_Segmentation.this.wekaSegmentation.getNumOfClasses();
            while (Weka_Segmentation.this.numOfClasses < wekaNumOfClasses) {
                Weka_Segmentation.this.win.addClass();
            }
            for (int i = 0; i < Weka_Segmentation.this.numOfClasses; ++i) {
                Weka_Segmentation.this.addExampleButton[i].setText("Add to " + Weka_Segmentation.this.wekaSegmentation.getClassLabel(i));
            }
            Weka_Segmentation.this.win.updateButtonsEnabling();
            Weka_Segmentation.this.repaintWindow();
        }

        void setTrainingComplete(boolean b) {
            this.trainingComplete = b;
        }

        public ImagePlus getTrainingImage() {
            return Weka_Segmentation.this.trainingImage;
        }
    }

    private class CustomCanvas
    extends OverlayedImageCanvas {
        private static final long serialVersionUID = 1L;

        CustomCanvas(ImagePlus imp) {
            super(imp);
            Dimension dim = new Dimension(Math.min(512, imp.getWidth()), Math.min(512, imp.getHeight()));
            this.setMinimumSize(dim);
            this.setSize(dim.width, dim.height);
            this.setDstDimensions(dim.width, dim.height);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent ke) {
                    CustomCanvas.this.repaint();
                }
            });
        }

        public void setDrawingSize(int w, int h) {
        }

        public void setDstDimensions(int width, int height) {
            int y;
            this.dstWidth = width;
            this.dstHeight = height;
            int w = Math.min((int)((double)width / this.magnification), this.imp.getWidth());
            int h = Math.min((int)((double)height / this.magnification), this.imp.getHeight());
            int x = this.srcRect.x;
            if (x + w > this.imp.getWidth()) {
                x = w - this.imp.getWidth();
            }
            if ((y = this.srcRect.y) + h > this.imp.getHeight()) {
                y = h - this.imp.getHeight();
            }
            this.srcRect.setRect(x, y, w, h);
            this.repaint();
        }

        public void paint(Graphics g) {
            Rectangle srcRect = this.getSrcRect();
            double mag = this.getMagnification();
            int dw = (int)((double)srcRect.width * mag);
            int dh = (int)((double)srcRect.height * mag);
            g.setClip(0, 0, dw, dh);
            super.paint(g);
            int w = this.getWidth();
            int h = this.getHeight();
            g.setClip(0, 0, w, h);
            g.setColor(this.getBackground());
            g.fillRect(dw, 0, w - dw, h);
            g.fillRect(0, dh, w, h - dh);
        }

        public void setImagePlus(ImagePlus imp) {
            this.imp = imp;
        }
    }
}

