/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripteditor.scala;

import dotty.tools.repl.State;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.jline.reader.Candidate;
import org.scijava.log.LogService;
import org.scijava.plugins.scripteditor.scala.AutoCompleteReplDriver;
import org.scijava.plugins.scripteditor.scala.ScalaReplCompleter$;
import scala.Console$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;

public class ScalaReplCompleter {
    private final LogService logService;
    private final AutoCompleteReplDriver driver;
    private final State state;

    public static String classPath() {
        return ScalaReplCompleter$.MODULE$.classPath();
    }

    public ScalaReplCompleter(LogService logService) {
        this.logService = logService;
        PrintStream out = new PrintStream(new LevelOutputStream(logService));
        Some loader = Some$.MODULE$.apply((Object)this.getClass().getClassLoader());
        this.driver = new AutoCompleteReplDriver(new String[]{"-classpath", ScalaReplCompleter$.MODULE$.classPath(), "-usejavacp", "-color:never", "-Xrepl-disable-display", "-explain"}, out, (Option<ClassLoader>)loader);
        this.state = this.driver.initialState();
    }

    public Seq<Completion> completionsFor(CompletionProvider provider, String codeWithoutLastLine, String lastLine, String alreadyEnteredText) {
        this.logService.trace((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(164).append("|ScalaReplCompleter.completionsFor(\n         |  codeWithoutLastLine: \n         |    ").append(codeWithoutLastLine).append("\n         |  lastLine: ").append(lastLine).append("\n         |  alreadyEnteredText:  ").append(alreadyEnteredText).append("\n         |)\n         |").toString())));
        State state1 = this.driver.run(codeWithoutLastLine, this.state);
        List<Candidate> candidates = this.driver.complete(lastLine.length(), lastLine, state1);
        return candidates.map((Function1 & Serializable)c -> new BasicCompletion(provider, c.value()));
    }

    public static final class LevelOutputStream
    extends OutputStream {
        private final LogService logService;
        private final PrintStream writer;
        private final int logLevel;

        public LevelOutputStream(LogService logService) {
            this.logService = logService;
            this.writer = Console$.MODULE$.out();
            this.logLevel = 5;
        }

        @Override
        public void write(int b) {
            if (this.logService.isLevel(this.logLevel)) {
                this.writer.write(new byte[]{(byte)b}, 0, 1);
                return;
            }
        }

        @Override
        public void write(byte[] b, int off, int len) {
            if (this.logService.isLevel(this.logLevel)) {
                this.writer.write(b, off, len);
                return;
            }
        }
    }
}

