/*
 * Decompiled with CFR 0.152.
 */
package FlowJ;

import FlowJ.FlowJDynamicColor;
import FlowJ.FlowJFlow;
import FlowJ.FlowJMapper;
import FlowJ.FlowJSpotNoise;
import ij.process.ImageProcessor;

public class Flow3JColorNoiseMapper
extends FlowJMapper {
    public static final double chance = (double)0.01f;
    public static final double minMagnitude = (double)0.05f;
    private FlowJSpotNoise colornoise;

    public Flow3JColorNoiseMapper(ImageProcessor impr, float[][][] flow, int axes, int maxp, int maxq, double pScaling, double qScaling, double rho) {
        super(impr, flow, axes, maxp, maxq, pScaling, qScaling, rho);
        this.colornoise = new FlowJSpotNoise((int[])impr.getPixels(), maxp, maxq, (double)0.4f);
    }

    @Override
    public void pixel(int ip, int iq, int ix, int iy, double dx, double dy) {
        double r = Math.random();
        if (r > (double)0.01f) {
            float[] v = this.pScaling == 1.0 && this.qScaling == 1.0 ? new float[]{this.flow[iy][ix][0], this.flow[iy][ix][1]} : Flow3JColorNoiseMapper.bl(this.flow, ix, iy, dx, dy);
            float[] pv = new float[3];
            FlowJFlow.polar3D(pv, v[0], v[2], Math.abs(v[1]));
            if ((double)pv[0] / this.rho > (double)0.05f) {
                byte[] rgb = new byte[3];
                FlowJDynamicColor.map3D(rgb, (double)pv[0] / this.rho, pv[1], pv[2]);
                double rnd = (float)Math.random();
                int rrnd = (int)(rnd * (double)(rgb[0] & 0xFF));
                int grnd = (int)(rnd * (double)(rgb[1] & 0xFF));
                int brnd = (int)(rnd * (double)(rgb[2] & 0xFF));
                this.colornoise.spot(ip, iq, (double)0.4f + 2.0 * (double)pv[0] / this.rho, rrnd, grnd, brnd, v);
            }
        }
    }
}

