/*
 * Decompiled with CFR 0.152.
 */
package FlowJ;

import FlowJ.FlowJException;
import FlowJ.FlowJFlow;
import ij.IJ;
import ij.ImageStack;
import volume.Beaudetx;
import volume.CentralDiff;
import volume.Gaussian;
import volume.VolumeFloat;

public class FlowJUras {
    public final boolean debug = false;
    private float tau;
    private int region = 1;
    private float sigmat;
    private float sigmas;
    private float density;
    private int width;
    private int height;
    private int depth;
    private VolumeFloat v;
    private VolumeFloat dx;
    private VolumeFloat dy;
    private VolumeFloat dxt;
    private VolumeFloat dyt;
    private VolumeFloat dxx;
    private VolumeFloat dyy;
    private VolumeFloat dxy;
    private int edge;
    private final int EDGE = 2;
    private final int NRADIUS = 4;
    private final float MAX_COND = 10000.0f;
    private int support;

    public String toString() {
        return "U s" + this.sigmas + " t" + this.sigmat + " tau" + this.tau + " region" + this.region + " (" + IJ.d2s((double)(this.density * 100.0f), (int)2) + "%) (support=" + this.support + ")";
    }

    public void filterAll(ImageStack is, int center, float sigmat, float sigmas) throws FlowJException {
        this.width = is.getWidth();
        this.height = is.getHeight();
        this.depth = 5;
        this.edge = 0;
        this.sigmat = sigmat;
        this.sigmas = sigmas;
        Gaussian tGaussian = null;
        if (sigmat > 0.0f) {
            tGaussian = new Gaussian(sigmat);
        }
        this.v = new VolumeFloat(this.width, this.height, this.depth);
        this.support = tGaussian.support() + this.depth - 1;
        if (is.getSize() < this.support) {
            FlowJException e = new FlowJException("Need at least " + this.support + " slices in stack.");
            throw e;
        }
        if (center - 1 < this.support / 2 || center - 1 > is.getSize() - this.support / 2) {
            FlowJException e = new FlowJException("Please select the frame  > " + this.support / 2 + " and < " + (is.getSize() + 1 - this.support / 2));
            throw e;
        }
        if (sigmat > 0.0f) {
            this.v.convolvet(is, center, tGaussian);
        } else {
            this.v.load(is, center - this.depth / 2);
        }
        if (sigmas > 0.0f) {
            Gaussian sGaussian = new Gaussian(sigmas);
            this.edge = this.v.discreteSupport(sGaussian) / 2;
            this.v.convolvexy(sGaussian);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void gradients() {
        IJ.showStatus((String)"computing derivatives...");
        CentralDiff cd4p = new CentralDiff();
        this.dx = new VolumeFloat(this.v.getWidth(), this.v.getHeight(), 5);
        this.dx.convolvex(this.v, cd4p);
        this.dy = new VolumeFloat(this.v.getWidth(), this.v.getHeight(), 5);
        this.dy.convolvey(this.v, cd4p);
        this.dxt = new VolumeFloat(this.v.getWidth(), this.v.getHeight(), 1);
        this.dxt.convolvez(this.dx, cd4p);
        this.dyt = new VolumeFloat(this.v.getWidth(), this.v.getHeight(), 1);
        this.dyt.convolvez(this.dy, cd4p);
        this.dxx = new VolumeFloat(this.v.getWidth(), this.v.getHeight(), 1);
        this.dxx.convolvex(this.dx, cd4p);
        this.dyy = new VolumeFloat(this.v.getWidth(), this.v.getHeight(), 1);
        this.dyy.convolvey(this.dy, cd4p);
        this.dxy = new VolumeFloat(this.v.getWidth(), this.v.getHeight(), 1);
        this.dxy.convolvex(this.dy, cd4p);
        this.dxx.setEdge(this.v.discreteSupport(cd4p) / 2 + 4);
    }

    public void computeFull(FlowJFlow flow, int region, float tau) {
        this.tau = tau;
        this.region = region;
        flow.v.setEdge(this.edge);
        int total = 0;
        int fulls = 0;
        for (int y = 0; y < this.height; ++y) {
            IJ.showProgress((double)((float)y / (float)this.height));
            for (int x = 0; x < this.width; ++x) {
                flow.set(x, y, 0.0f, 0.0f, false);
                if (!this.dxx.valid(x, y)) continue;
                float xx = this.dxx.v[0][y][x];
                float yy = this.dyy.v[0][y][x];
                float xy = this.dxy.v[0][y][x];
                float xt = this.dxt.v[0][y][x];
                float yt = this.dyt.v[0][y][x];
                float amp = xx * yy - xy * xy;
                if (amp != 0.0f) {
                    float[] vv = new float[]{(yt * xy - xt * yy) / amp, -(xt * xy - yt * xx) / amp};
                    float mag = (float)Math.sqrt(Math.pow(vv[0], 2.0) + Math.pow(vv[1], 2.0));
                    if (mag > 20.0f) {
                        vv[0] = vv[0] / mag * 20.0f;
                        vv[1] = vv[1] / mag * 20.0f;
                    }
                    flow.set(x, y, vv[0], vv[1], true);
                    ++fulls;
                }
                ++total;
            }
        }
        if (region > 0) {
            float[][] cond = new float[this.height][this.width];
            float[][] gauss = new float[this.height][this.width];
            float[][] discr = new float[this.height][this.width];
            this.discriminant(flow, cond, gauss, discr);
            this.regularize(flow, cond, gauss, discr);
        }
        this.density = (float)fulls / (float)total;
    }

    private void regularize(FlowJFlow flow, float[][] cond, float[][] gauss, float[][] discr) {
        int xf = (int)((double)((this.width - 4 - 4 - 8) % this.region) / 2.0 + 0.5);
        int yf = (int)((double)((this.height - 4 - 4 - 8) % this.region) / 2.0 + 0.5);
        for (int y = 6 + yf; y < this.height - 4 - 4 - yf; y += this.region) {
            for (int x = 6 + xf; x < this.width - 4 - 4 - xf; x += this.region) {
                int[][] sample = new int[this.region * this.region][2];
                int n = this.min(x, y, discr, sample);
                int m = this.minCond(sample, cond, n);
                if (m >= 0) {
                    int m1 = sample[m][1];
                    int m0 = sample[m][0];
                    if (gauss[m1][m0] > this.tau) {
                        float g = gauss[m1][m0];
                        float cn = cond[m1][m0];
                        this.propagate(flow, cond, gauss, x, y, flow.getX(m0, m1), flow.getY(m0, m1), cn, g, true);
                        continue;
                    }
                    this.propagate(flow, cond, gauss, x, y, 0.0f, 0.0f, 0.0f, 0.0f, false);
                    continue;
                }
                this.propagate(flow, cond, gauss, x, y, 0.0f, 0.0f, 0.0f, 0.0f, false);
            }
        }
    }

    private void propagate(FlowJFlow flow, float[][] cond, float[][] gauss, int x, int y, float vx, float vy, float cn, float g, boolean fullFlow) {
        for (int k = 0; k < this.region; ++k) {
            for (int l = 0; l < this.region; ++l) {
                flow.set(x + l, y + k, vx, vy, fullFlow);
                gauss[y + k][x + l] = g;
                cond[y + k][x + l] = cn;
            }
        }
    }

    public void discriminant(FlowJFlow flow, float[][] cond, float[][] gauss, float[][] discr) {
        flow.v.setEdge(flow.v.getEdge() + 2);
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (!this.dx.valid(x, y)) continue;
                Beaudetx bx = new Beaudetx();
                float ux = this.dx.ux(y, x, bx);
                float uy = this.dx.uy(y, x, bx);
                float vx = this.dy.ux(y, x, bx);
                float vy = this.dy.uy(y, x, bx);
                float MtU = (float)(Math.pow(this.dx.v[2][y][x] * ux + this.dy.v[2][y][x] * vx, 2.0) + Math.pow(this.dx.v[2][y][x] * uy + this.dy.v[2][y][x] * vy, 2.0));
                float It = (float)(Math.pow(this.dxt.v[0][y][x], 2.0) + Math.pow(this.dyt.v[0][y][x], 2.0));
                discr[y][x] = (float)Math.sqrt(MtU / It);
                float xx = this.dxx.v[0][y][x];
                float yy = this.dyy.v[0][y][x];
                float xy = this.dxy.v[0][y][x];
                gauss[y][x] = (float)Math.abs((double)(xx * yy) - Math.pow(xy, 2.0));
                float cmax = (float)(0.5 * ((double)(xx + yy) + Math.sqrt(Math.pow(xx - yy, 2.0) + 4.0 * (double)xy * (double)xy)));
                float cmin = (float)(0.5 * ((double)(xx + yy) - Math.sqrt(Math.pow(xx - yy, 2.0) + 4.0 * (double)xy * (double)xy)));
                if (Math.abs(cmin) < Math.abs(cmax)) {
                    if (cmin != 0.0f) {
                        cond[y][x] = Math.abs(cmax / cmin);
                        continue;
                    }
                    cond[y][x] = 10000.0f;
                    continue;
                }
                cond[y][x] = cmax != 0.0f ? Math.abs(cmin / cmax) : 10000.0f;
            }
        }
        flow.v.setEdge(flow.v.getEdge() - 2);
    }

    private void sort(float[] sampleDiscr, int[][] sample, int n) {
        int m = this.region;
        if (n < m) {
            m = n;
        }
        for (int i = 0; i < m - 1; ++i) {
            int index = i;
            for (int j = index + 1; j < n; ++j) {
                if (!(sampleDiscr[index] > sampleDiscr[j])) continue;
                index = j;
            }
            float td = sampleDiscr[index];
            sampleDiscr[index] = sampleDiscr[i];
            sampleDiscr[i] = td;
            int[] t = sample[index];
            sample[index] = sample[i];
            sample[i] = t;
        }
    }

    public int min(int x, int y, float[][] discr, int[][] sample) {
        float[] sampleDiscr = new float[this.region * this.region];
        int n = 0;
        for (int k = 0; k < this.region; ++k) {
            for (int l = 0; l < this.region; ++l) {
                sample[n][0] = x + l;
                sample[n][1] = y + k;
                sampleDiscr[n++] = discr[y + k][x + l];
            }
        }
        this.sort(sampleDiscr, sample, n);
        return n;
    }

    public int minCond(int[][] sample, float[][] cond, int n) {
        float minCon = 10001.0f;
        if (n < this.region) {
            n = this.region;
        }
        int m = -1;
        for (int l = 0; l < n; ++l) {
            int l1 = sample[l][1];
            int l0 = sample[l][0];
            if (!(cond[l1][l0] < minCon)) continue;
            minCon = cond[l1][l0];
            m = l;
        }
        return m;
    }
}

