/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJProjection;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import java.awt.Frame;
import volume.VolumeFloat;

public class VJBackprojection {
    private static float deltaAngle = 0.0f;
    private static float scale = 0.0f;
    private static int n = 0;
    private static int width = 0;
    private static int height = 0;
    private static int depth = 0;
    private static double aspectx = 1.0;
    private static double aspecty = 1.0;
    private static double aspectz = 1.0;
    protected VolumeFloat v;

    public VJBackprojection() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp instanceof ImagePlus && imp.getStackSize() > 1) {
            Calibration c = imp.getCalibration();
            aspectx = 1.0;
            aspecty = 1.0;
            aspectz = c.pixelDepth / c.pixelWidth;
            deltaAngle = 45.0f;
            height = width = imp.getStack().getWidth();
            depth = imp.getStack().getHeight();
            n = imp.getStack().getSize();
            GenericDialog gd = new GenericDialog("Backprojection (" + n + " projections)", (Frame)IJ.getInstance());
            gd.addMessage("Allows reconstruction of a volume from any number of projections of that volume, as done for CT or MR scanning.\nImplements the inverse Radon transform. The more projections the better the quality of the reconstruction");
            gd.addNumericField("Delta angle (between projections)", (double)deltaAngle, 2);
            gd.addNumericField("width", (double)width, 2);
            gd.addNumericField("height", (double)height, 2);
            gd.addNumericField("depth", (double)depth, 2);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            deltaAngle = (float)gd.getNextNumber();
            width = (int)gd.getNextNumber();
            height = (int)gd.getNextNumber();
            depth = (int)gd.getNextNumber();
            this.v = new VolumeFloat(width, height, depth, 1.0, 1.0, 1.0);
            VJProjection vjp = new VJProjection(deltaAngle, imp.getStack().getImageArray(), n, width, height);
            vjp.backproject(this.v);
            new ImagePlus("backprojection ", this.v.getImageStack()).show();
        }
    }
}

