/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJAlphaColor;
import VolumeJ.VJClassifierLNotIndex0;
import VolumeJ.VJGradient;
import VolumeJ.VJValue;
import java.awt.Color;

public class VJClassifierGradientCT
extends VJClassifierLNotIndex0 {
    public VJClassifierGradientCT() {
        this.description = "Gradient CT (indexed)";
    }

    @Override
    public VJAlphaColor alphacolor(VJValue v, VJGradient g) {
        int intensity = v.intvalue;
        int index = v.index;
        int igradient = (int)(g.getmag() * this.fractionMagnitude) & this.maskMagnitude;
        int entry = igradient << this.nrIntensityBits | intensity;
        if (index == 0) {
            return new VJAlphaColor();
        }
        if (index == 128) {
            return new VJAlphaColor((double)0.1f, this.lut[index * 3 + 0] & 0xFF, this.lut[index * 3 + 1] & 0xFF, this.lut[index * 3 + 2] & 0xFF);
        }
        return new VJAlphaColor((double)this.opacityTable[entry], this.lut[index * 3 + 0] & 0xFF, this.lut[index * 3 + 1] & 0xFF, this.lut[index * 3 + 2] & 0xFF);
    }

    @Override
    protected void defaultLUT() {
        if (this.nrIndexBits > 0) {
            this.lut = new byte[(int)Math.pow(2.0, this.nrIndexBits) * 3];
            for (int index = 0; index < (int)Math.pow(2.0, this.nrIndexBits); ++index) {
                if (index == 1 || index == 255) {
                    this.lut[index * 3 + 0] = -1;
                    this.lut[index * 3 + 1] = -1;
                    this.lut[index * 3 + 2] = -1;
                    continue;
                }
                Color c = Color.getHSBColor((float)index / 255.0f, 1.0f, 1.0f);
                this.lut[index * 3 + 0] = (byte)c.getRed();
                this.lut[index * 3 + 1] = (byte)c.getGreen();
                this.lut[index * 3 + 2] = (byte)c.getBlue();
            }
        }
    }

    @Override
    public String toLongString() {
        return "Levoy (" + (this.does() == 4 ? "RGB" : "grays") + ") classifier optimized for CT scans. Uses indexing. Voxel colors  are: index=0 invisible, index=128 semi-transparent blue, index=255 gray.";
    }
}

