/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJCell;
import VolumeJ.VJGradient;
import VolumeJ.VJInterpolator;
import VolumeJ.VJUserInterface;
import VolumeJ.VJValue;
import VolumeJ.VJVoxelLoc;
import volume.Volume;
import volume.VolumeFloat;
import volume.VolumeRGB;
import volume.VolumeShort;

public class VJTrilinear
extends VJInterpolator {
    @Override
    public boolean isValid(VJVoxelLoc vl, Volume v) {
        return vl.ix >= 0 && vl.ix + 1 < v.getWidth() && vl.iy >= 0 && vl.iy + 1 < v.getHeight() && vl.iz >= 0 && vl.iz + 1 < v.getDepth();
    }

    @Override
    public boolean isValidGradient(VJVoxelLoc vl, Volume v) {
        return vl.ix - 1 >= 0 && vl.ix + 2 < v.getWidth() && vl.iy - 1 >= 0 && vl.iy + 2 < v.getHeight() && vl.iz - 1 >= 0 && vl.iz + 2 < v.getDepth();
    }

    @Override
    public boolean isValidGradient(VJCell c, Volume v) {
        boolean p = c.ix >= 2 && c.ix < v.getWidth() - 3;
        boolean q = c.iy >= 2 && c.iy < v.getHeight() - 3;
        boolean r = c.iz >= 2 && c.iz < v.getDepth() - 3;
        return p && q && r;
    }

    @Override
    public VJValue value(VJValue voxel, Volume v, VJVoxelLoc vl) {
        if (v instanceof VolumeShort) {
            if (((VolumeShort)v).getIndexed()) {
                voxel.floatvalue = VJTrilinear.value(((VolumeShort)v).v, 255, vl);
                voxel.index = (((VolumeShort)v).v[vl.iz][vl.iy][vl.ix] & 0xFF00) >> 8;
            } else {
                voxel.floatvalue = VJTrilinear.value(((VolumeShort)v).v, vl);
            }
        } else if (v instanceof VolumeFloat) {
            voxel.floatvalue = VJTrilinear.value(((VolumeFloat)v).v, vl);
        } else if (v instanceof VolumeRGB) {
            voxel.floatvalue = VJTrilinear.value(((VolumeRGB)v).b, v.getHeight(), v.getWidth(), vl);
        } else {
            VJUserInterface.error("unknown Volume type v");
            return null;
        }
        voxel.intvalue = (int)voxel.floatvalue;
        return voxel;
    }

    @Override
    public VJGradient gradient(Volume v, VJVoxelLoc vl) {
        if (v instanceof VolumeShort) {
            if (((VolumeShort)v).getIndexed()) {
                return VJTrilinear.gradient(((VolumeShort)v).v, 255, vl);
            }
            return VJTrilinear.gradient(((VolumeShort)v).v, vl);
        }
        if (v instanceof VolumeFloat) {
            return VJTrilinear.gradient(((VolumeFloat)v).v, vl);
        }
        if (v instanceof VolumeRGB) {
            return VJTrilinear.gradient(((VolumeRGB)v).b, v.getHeight(), v.getWidth(), vl);
        }
        VJUserInterface.error("unknown Volume type v");
        return null;
    }

    protected static float value(float[][][] v, VJVoxelLoc vl) {
        vl.getWeights();
        return v[vl.iz][vl.iy][vl.ix] * vl.tlf + v[vl.iz][vl.iy + 1][vl.ix] * vl.blf + v[vl.iz][vl.iy][vl.ix + 1] * vl.trf + v[vl.iz][vl.iy + 1][vl.ix + 1] * vl.brf + v[vl.iz + 1][vl.iy][vl.ix] * vl.tlb + v[vl.iz + 1][vl.iy + 1][vl.ix] * vl.blb + v[vl.iz + 1][vl.iy][vl.ix + 1] * vl.trb + v[vl.iz + 1][vl.iy + 1][vl.ix + 1] * vl.brb;
    }

    protected static float value(short[][][] v, VJVoxelLoc vl) {
        vl.getWeights();
        float f = (float)(v[vl.iz][vl.iy][vl.ix] & 0xFFFF) * vl.tlf + (float)(v[vl.iz][vl.iy + 1][vl.ix] & 0xFFFF) * vl.blf + (float)(v[vl.iz][vl.iy][vl.ix + 1] & 0xFFFF) * vl.trf + (float)(v[vl.iz][vl.iy + 1][vl.ix + 1] & 0xFFFF) * vl.brf + (float)(v[vl.iz + 1][vl.iy][vl.ix] & 0xFFFF) * vl.tlb + (float)(v[vl.iz + 1][vl.iy + 1][vl.ix] & 0xFFFF) * vl.blb + (float)(v[vl.iz + 1][vl.iy][vl.ix + 1] & 0xFFFF) * vl.trb + (float)(v[vl.iz + 1][vl.iy + 1][vl.ix + 1] & 0xFFFF) * vl.brb;
        return f;
    }

    private static int value(short[][][] v, int mask, VJVoxelLoc vl) {
        vl.getWeights();
        return (int)((float)(v[vl.iz][vl.iy][vl.ix] & mask) * vl.tlf + (float)(v[vl.iz][vl.iy + 1][vl.ix] & mask) * vl.blf + (float)(v[vl.iz][vl.iy][vl.ix + 1] & mask) * vl.trf + (float)(v[vl.iz][vl.iy + 1][vl.ix + 1] & mask) * vl.brf + (float)(v[vl.iz + 1][vl.iy][vl.ix] & mask) * vl.tlb + (float)(v[vl.iz + 1][vl.iy + 1][vl.ix] & mask) * vl.blb + (float)(v[vl.iz + 1][vl.iy][vl.ix + 1] & mask) * vl.trb + (float)(v[vl.iz + 1][vl.iy + 1][vl.ix + 1] & mask) * vl.brb);
    }

    protected static float value(float[][][][] v, int dimension, VJVoxelLoc vl) {
        vl.getWeights();
        return v[vl.iz][vl.iy][vl.ix][dimension] * vl.tlf + v[vl.iz][vl.iy + 1][vl.ix][dimension] * vl.blf + v[vl.iz][vl.iy][vl.ix + 1][dimension] * vl.trf + v[vl.iz][vl.iy + 1][vl.ix + 1][dimension] * vl.brf + v[vl.iz + 1][vl.iy][vl.ix][dimension] * vl.tlb + v[vl.iz + 1][vl.iy + 1][vl.ix][dimension] * vl.blb + v[vl.iz + 1][vl.iy][vl.ix + 1][dimension] * vl.trb + v[vl.iz + 1][vl.iy + 1][vl.ix + 1][dimension] * vl.brb;
    }

    protected static float value(byte[] v, int height, int width, VJVoxelLoc vl) {
        vl.getWeights();
        return (int)((float)(v[vl.iz * height * width + vl.iy * width + vl.ix] & 0xFF) * vl.tlf + (float)(v[vl.iz * height * width + (vl.iy + 1) * width + vl.ix] & 0xFF) * vl.blf + (float)(v[vl.iz * height * width + vl.iy * width + (vl.ix + 1)] & 0xFF) * vl.trf + (float)(v[vl.iz * height * width + (vl.iy + 1) * width + (vl.ix + 1)] & 0xFF) * vl.brf + (float)(v[(vl.iz + 1) * height * width + vl.iy * width + vl.ix] & 0xFF) * vl.tlb + (float)(v[(vl.iz + 1) * height * width + (vl.iy + 1) * width + vl.ix] & 0xFF) * vl.blb + (float)(v[(vl.iz + 1) * height * width + vl.iy * width + (vl.ix + 1)] & 0xFF) * vl.trb + (float)(v[(vl.iz + 1) * height * width + (vl.iy + 1) * width + (vl.ix + 1)] & 0xFF) * vl.brb);
    }

    protected static float[] valueHS(float[] hs, Object[] sliceArray, int width, VJVoxelLoc vl) {
        vl.getWeights();
        int[] slice0 = (int[])sliceArray[vl.iz];
        int[] slice1 = (int[])sliceArray[vl.iz + 1];
        int vtlf = slice0[vl.iy * width + vl.ix];
        int vblf = slice0[(vl.iy + 1) * width + vl.ix];
        int vtrf = slice0[vl.iy * width + (vl.ix + 1)];
        int vbrf = slice0[(vl.iy + 1) * width + (vl.ix + 1)];
        int vtlb = slice1[vl.iy * width + vl.ix];
        int vblb = slice1[(vl.iy + 1) * width + vl.ix];
        int vtrb = slice1[vl.iy * width + (vl.ix + 1)];
        int vbrb = slice1[(vl.iy + 1) * width + (vl.ix + 1)];
        float[] hsb = new float[3];
        hs[0] = 0.0f;
        hs[1] = 0.0f;
        VolumeRGB.intToHSB(hsb, vtlf);
        hs[0] = hs[0] + hsb[0] * vl.tlf;
        hs[1] = hs[1] + hsb[1] * vl.tlf;
        VolumeRGB.intToHSB(hsb, vblf);
        hs[0] = hs[0] + hsb[0] * vl.blf;
        hs[1] = hs[1] + hsb[1] * vl.blf;
        VolumeRGB.intToHSB(hsb, vtrf);
        hs[0] = hs[0] + hsb[0] * vl.trf;
        hs[1] = hs[1] + hsb[1] * vl.trf;
        VolumeRGB.intToHSB(hsb, vbrf);
        hs[0] = hs[0] + hsb[0] * vl.brf;
        hs[1] = hs[1] + hsb[1] * vl.brf;
        VolumeRGB.intToHSB(hsb, vtlb);
        hs[0] = hs[0] + hsb[0] * vl.tlb;
        hs[1] = hs[1] + hsb[1] * vl.tlb;
        VolumeRGB.intToHSB(hsb, vblb);
        hs[0] = hs[0] + hsb[0] * vl.blb;
        hs[1] = hs[1] + hsb[1] * vl.blb;
        VolumeRGB.intToHSB(hsb, vtrb);
        hs[0] = hs[0] + hsb[0] * vl.trb;
        hs[1] = hs[1] + hsb[1] * vl.trb;
        VolumeRGB.intToHSB(hsb, vbrb);
        hs[0] = hs[0] + hsb[0] * vl.brb;
        hs[1] = hs[1] + hsb[1] * vl.brb;
        return hs;
    }

    protected static VJGradient gradient(float[][][] v, VJVoxelLoc vl) {
        vl.getWeights();
        double gx = (v[vl.iz][vl.iy][vl.ix - 1] - v[vl.iz][vl.iy][vl.ix + 1]) * vl.tlf + (v[vl.iz][vl.iy + 1][vl.ix - 1] - v[vl.iz][vl.iy + 1][vl.ix + 1]) * vl.blf + (v[vl.iz][vl.iy][vl.ix] - v[vl.iz][vl.iy][vl.ix + 2]) * vl.trf + (v[vl.iz][vl.iy + 1][vl.ix] - v[vl.iz][vl.iy + 1][vl.ix + 2]) * vl.brf + (v[vl.iz + 1][vl.iy][vl.ix - 1] - v[vl.iz + 1][vl.iy][vl.ix + 1]) * vl.tlb + (v[vl.iz + 1][vl.iy + 1][vl.ix - 1] - v[vl.iz + 1][vl.iy + 1][vl.ix + 1]) * vl.blb + (v[vl.iz + 1][vl.iy][vl.ix] - v[vl.iz + 1][vl.iy][vl.ix + 2]) * vl.trb + (v[vl.iz + 1][vl.iy + 1][vl.ix] - v[vl.iz + 1][vl.iy + 1][vl.ix + 2]) * vl.brb;
        double gy = (v[vl.iz][vl.iy - 1][vl.ix] - v[vl.iz][vl.iy + 1][vl.ix]) * vl.tlf + (v[vl.iz][vl.iy][vl.ix] - v[vl.iz][vl.iy + 2][vl.ix]) * vl.blf + (v[vl.iz][vl.iy - 1][vl.ix + 1] - v[vl.iz][vl.iy + 1][vl.ix + 1]) * vl.trf + (v[vl.iz][vl.iy][vl.ix + 1] - v[vl.iz][vl.iy + 2][vl.ix + 1]) * vl.brf + (v[vl.iz + 1][vl.iy - 1][vl.ix] - v[vl.iz + 1][vl.iy + 1][vl.ix]) * vl.tlb + (v[vl.iz + 1][vl.iy][vl.ix] - v[vl.iz + 1][vl.iy + 2][vl.ix]) * vl.blb + (v[vl.iz + 1][vl.iy - 1][vl.ix + 1] - v[vl.iz + 1][vl.iy + 1][vl.ix + 1]) * vl.trb + (v[vl.iz + 1][vl.iy][vl.ix + 1] - v[vl.iz + 1][vl.iy + 2][vl.ix + 1]) * vl.brb;
        double gz = (v[vl.iz - 1][vl.iy][vl.ix] - v[vl.iz + 1][vl.iy][vl.ix]) * vl.tlf + (v[vl.iz - 1][vl.iy + 1][vl.ix] - v[vl.iz + 1][vl.iy + 1][vl.ix]) * vl.blf + (v[vl.iz - 1][vl.iy][vl.ix + 1] - v[vl.iz + 1][vl.iy][vl.ix + 1]) * vl.trf + (v[vl.iz - 1][vl.iy + 1][vl.ix + 1] - v[vl.iz + 1][vl.iy + 1][vl.ix + 1]) * vl.brf + (v[vl.iz][vl.iy][vl.ix] - v[vl.iz + 2][vl.iy][vl.ix]) * vl.tlb + (v[vl.iz][vl.iy + 1][vl.ix] - v[vl.iz + 2][vl.iy + 1][vl.ix]) * vl.blb + (v[vl.iz][vl.iy][vl.ix + 1] - v[vl.iz + 2][vl.iy][vl.ix + 1]) * vl.trb + (v[vl.iz][vl.iy + 1][vl.ix + 1] - v[vl.iz + 2][vl.iy + 1][vl.ix + 1]) * vl.brb;
        VJGradient g = new VJGradient(gx, gy, gz);
        return g;
    }

    protected static VJGradient gradient(short[][][] v, VJVoxelLoc vl) {
        vl.getWeights();
        VJGradient g = null;
        try {
            double gx = (float)((v[vl.iz][vl.iy][vl.ix - 1] & 0xFFFF) - (v[vl.iz][vl.iy][vl.ix + 1] & 0xFFFF)) * vl.tlf + (float)((v[vl.iz][vl.iy + 1][vl.ix - 1] & 0xFFFF) - (v[vl.iz][vl.iy + 1][vl.ix + 1] & 0xFFFF)) * vl.blf + (float)((v[vl.iz][vl.iy][vl.ix] & 0xFFFF) - (v[vl.iz][vl.iy][vl.ix + 2] & 0xFFFF)) * vl.trf + (float)((v[vl.iz][vl.iy + 1][vl.ix] & 0xFFFF) - (v[vl.iz][vl.iy + 1][vl.ix + 2] & 0xFFFF)) * vl.brf + (float)((v[vl.iz + 1][vl.iy][vl.ix - 1] & 0xFFFF) - (v[vl.iz + 1][vl.iy][vl.ix + 1] & 0xFFFF)) * vl.tlb + (float)((v[vl.iz + 1][vl.iy + 1][vl.ix - 1] & 0xFFFF) - (v[vl.iz + 1][vl.iy + 1][vl.ix + 1] & 0xFFFF)) * vl.blb + (float)((v[vl.iz + 1][vl.iy][vl.ix] & 0xFFFF) - (v[vl.iz + 1][vl.iy][vl.ix + 2] & 0xFFFF)) * vl.trb + (float)((v[vl.iz + 1][vl.iy + 1][vl.ix] & 0xFFFF) - (v[vl.iz + 1][vl.iy + 1][vl.ix + 2] & 0xFFFF)) * vl.brb;
            double gy = (float)((v[vl.iz][vl.iy - 1][vl.ix] & 0xFFFF) - (v[vl.iz][vl.iy + 1][vl.ix] & 0xFFFF)) * vl.tlf + (float)((v[vl.iz][vl.iy][vl.ix] & 0xFFFF) - (v[vl.iz][vl.iy + 2][vl.ix] & 0xFFFF)) * vl.blf + (float)((v[vl.iz][vl.iy - 1][vl.ix + 1] & 0xFFFF) - (v[vl.iz][vl.iy + 1][vl.ix + 1] & 0xFFFF)) * vl.trf + (float)((v[vl.iz][vl.iy][vl.ix + 1] & 0xFFFF) - (v[vl.iz][vl.iy + 2][vl.ix + 1] & 0xFFFF)) * vl.brf + (float)((v[vl.iz + 1][vl.iy - 1][vl.ix] & 0xFFFF) - (v[vl.iz + 1][vl.iy + 1][vl.ix] & 0xFFFF)) * vl.tlb + (float)((v[vl.iz + 1][vl.iy][vl.ix] & 0xFFFF) - (v[vl.iz + 1][vl.iy + 2][vl.ix] & 0xFFFF)) * vl.blb + (float)((v[vl.iz + 1][vl.iy - 1][vl.ix + 1] & 0xFFFF) - (v[vl.iz + 1][vl.iy + 1][vl.ix + 1] & 0xFFFF)) * vl.trb + (float)((v[vl.iz + 1][vl.iy][vl.ix + 1] & 0xFFFF) - (v[vl.iz + 1][vl.iy + 2][vl.ix + 1] & 0xFFFF)) * vl.brb;
            double gz = (float)((v[vl.iz - 1][vl.iy][vl.ix] & 0xFFFF) - (v[vl.iz + 1][vl.iy][vl.ix] & 0xFFFF)) * vl.tlf + (float)((v[vl.iz - 1][vl.iy + 1][vl.ix] & 0xFFFF) - (v[vl.iz + 1][vl.iy + 1][vl.ix] & 0xFFFF)) * vl.blf + (float)((v[vl.iz - 1][vl.iy][vl.ix + 1] & 0xFFFF) - (v[vl.iz + 1][vl.iy][vl.ix + 1] & 0xFFFF)) * vl.trf + (float)((v[vl.iz - 1][vl.iy + 1][vl.ix + 1] & 0xFFFF) - (v[vl.iz + 1][vl.iy + 1][vl.ix + 1] & 0xFFFF)) * vl.brf + (float)((v[vl.iz][vl.iy][vl.ix] & 0xFFFF) - (v[vl.iz + 2][vl.iy][vl.ix] & 0xFFFF)) * vl.tlb + (float)((v[vl.iz][vl.iy + 1][vl.ix] & 0xFFFF) - (v[vl.iz + 2][vl.iy + 1][vl.ix] & 0xFFFF)) * vl.blb + (float)((v[vl.iz][vl.iy][vl.ix + 1] & 0xFFFF) - (v[vl.iz + 2][vl.iy][vl.ix + 1] & 0xFFFF)) * vl.trb + (float)((v[vl.iz][vl.iy + 1][vl.ix + 1] & 0xFFFF) - (v[vl.iz + 2][vl.iy + 1][vl.ix + 1] & 0xFFFF)) * vl.brb;
            g = new VJGradient(gx, gy, gz);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("gradient error: VoxelLoc=" + vl + " error=" + e);
        }
        return g;
    }

    protected static VJGradient gradient(byte[] v, int height, int width, VJVoxelLoc vl) {
        vl.getWeights();
        double gx = (float)((v[vl.iz * height * width + vl.iy * width + (vl.ix - 1)] & 0xFF) - (v[vl.iz * height * width + vl.iy * width + (vl.ix + 1)] & 0xFF)) * vl.tlf + (float)((v[vl.iz * height * width + (vl.iy + 1) * width + (vl.ix - 1)] & 0xFF) - (v[vl.iz * height * width + (vl.iy + 1) * width + (vl.ix + 1)] & 0xFF)) * vl.blf + (float)((v[vl.iz * height * width + vl.iy * width + vl.ix] & 0xFF) - (v[vl.iz * height * width + vl.iy * width + (vl.ix + 2)] & 0xFF)) * vl.trf + (float)((v[vl.iz * height * width + (vl.iy + 1) * width + vl.ix] & 0xFF) - (v[vl.iz * height * width + (vl.iy + 1) * width + (vl.ix + 2)] & 0xFF)) * vl.brf + (float)((v[(vl.iz + 1) * height * width + vl.iy * width + (vl.ix - 1)] & 0xFF) - (v[(vl.iz + 1) * height * width + vl.iy * width + (vl.ix + 1)] & 0xFF)) * vl.tlb + (float)((v[(vl.iz + 1) * height * width + (vl.iy + 1) * width + (vl.ix - 1)] & 0xFF) - (v[(vl.iz + 1) * height * width + (vl.iy + 1) * width + (vl.ix + 1)] & 0xFF)) * vl.blb + (float)((v[(vl.iz + 1) * height * width + vl.iy * width + vl.ix] & 0xFF) - (v[(vl.iz + 1) * height * width + vl.iy * width + (vl.ix + 2)] & 0xFF)) * vl.trb + (float)((v[(vl.iz + 1) * height * width + (vl.iy + 1) * width + vl.ix] & 0xFF) - (v[(vl.iz + 1) * height * width + (vl.iy + 1) * width + (vl.ix + 2)] & 0xFF)) * vl.brb;
        double gy = (float)((v[vl.iz * height * width + (vl.iy - 1) * width + vl.ix] & 0xFF) - (v[vl.iz * height * width + (vl.iy + 1) * width + vl.ix] & 0xFF)) * vl.tlf + (float)((v[vl.iz * height * width + vl.iy * width + vl.ix] & 0xFF) - (v[vl.iz * height * width + (vl.iy + 2) * width + vl.ix] & 0xFF)) * vl.blf + (float)((v[vl.iz * height * width + (vl.iy - 1) * width + (vl.ix + 1)] & 0xFF) - (v[vl.iz * height * width + (vl.iy + 1) * width + (vl.ix + 1)] & 0xFF)) * vl.trf + (float)((v[vl.iz * height * width + vl.iy * width + (vl.ix + 1)] & 0xFF) - (v[vl.iz * height * width + (vl.iy + 2) * width + (vl.ix + 1)] & 0xFF)) * vl.brf + (float)((v[(vl.iz + 1) * height * width + (vl.iy - 1) * width + vl.ix] & 0xFF) - (v[(vl.iz + 1) * height * width + (vl.iy + 1) * width + vl.ix] & 0xFF)) * vl.tlb + (float)((v[(vl.iz + 1) * height * width + vl.iy * width + vl.ix] & 0xFF) - (v[(vl.iz + 1) * height * width + (vl.iy + 2) * width + vl.ix] & 0xFF)) * vl.blb + (float)((v[(vl.iz + 1) * height * width + (vl.iy - 1) * width + (vl.ix + 1)] & 0xFF) - (v[(vl.iz + 1) * height * width + (vl.iy + 1) * width + (vl.ix + 1)] & 0xFF)) * vl.trb + (float)((v[(vl.iz + 1) * height * width + vl.iy * width + (vl.ix + 1)] & 0xFF) - (v[(vl.iz + 1) * height * width + (vl.iy + 2) * width + (vl.ix + 1)] & 0xFF)) * vl.brb;
        double gz = (float)((v[(vl.iz - 1) * height * width + vl.iy * width + vl.ix] & 0xFF) - (v[(vl.iz + 1) * height * width + vl.iy * width + vl.ix] & 0xFF)) * vl.tlf + (float)((v[(vl.iz - 1) * height * width + (vl.iy + 1) * width + vl.ix] & 0xFF) - (v[(vl.iz + 1) * height * width + (vl.iy + 1) * width + vl.ix] & 0xFF)) * vl.blf + (float)((v[(vl.iz - 1) * height * width + vl.iy * width + (vl.ix + 1)] & 0xFF) - (v[(vl.iz + 1) * height * width + vl.iy * width + (vl.ix + 1)] & 0xFF)) * vl.trf + (float)((v[(vl.iz - 1) * height * width + (vl.iy + 1) * width + (vl.ix + 1)] & 0xFF) - (v[(vl.iz + 1) * height * width + (vl.iy + 1) * width + (vl.ix + 1)] & 0xFF)) * vl.brf + (float)((v[vl.iz * height * width + vl.iy * width + vl.ix] & 0xFF) - (v[(vl.iz + 2) * height * width + vl.iy * width + vl.ix] & 0xFF)) * vl.tlb + (float)((v[vl.iz * height * width + (vl.iy + 1) * width + vl.ix] & 0xFF) - (v[(vl.iz + 2) * height * width + (vl.iy + 1) * width + vl.ix] & 0xFF)) * vl.blb + (float)((v[vl.iz * height * width + vl.iy * width + (vl.ix + 1)] & 0xFF) - (v[(vl.iz + 2) * height * width + vl.iy * width + (vl.ix + 1)] & 0xFF)) * vl.trb + (float)((v[vl.iz * height * width + (vl.iy + 1) * width + (vl.ix + 1)] & 0xFF) - (v[(vl.iz + 2) * height * width + (vl.iy + 1) * width + (vl.ix + 1)] & 0xFF)) * vl.brb;
        VJGradient g = new VJGradient(gx, gy, gz);
        return g;
    }

    protected static VJGradient gradient(short[][][] v, int mask, VJVoxelLoc vl) {
        vl.getWeights();
        double gx = (float)((v[vl.iz][vl.iy][vl.ix - 1] & mask) - (v[vl.iz][vl.iy][vl.ix + 1] & mask)) * vl.tlf + (float)((v[vl.iz][vl.iy + 1][vl.ix - 1] & mask) - (v[vl.iz][vl.iy + 1][vl.ix + 1] & mask)) * vl.blf + (float)((v[vl.iz][vl.iy][vl.ix] & mask) - (v[vl.iz][vl.iy][vl.ix + 2] & mask)) * vl.trf + (float)((v[vl.iz][vl.iy + 1][vl.ix] & mask) - (v[vl.iz][vl.iy + 1][vl.ix + 2] & mask)) * vl.brf + (float)((v[vl.iz + 1][vl.iy][vl.ix - 1] & mask) - (v[vl.iz + 1][vl.iy][vl.ix + 1] & mask)) * vl.tlb + (float)((v[vl.iz + 1][vl.iy + 1][vl.ix - 1] & mask) - (v[vl.iz + 1][vl.iy + 1][vl.ix + 1] & mask)) * vl.blb + (float)((v[vl.iz + 1][vl.iy][vl.ix] & mask) - (v[vl.iz + 1][vl.iy][vl.ix + 2] & mask)) * vl.trb + (float)((v[vl.iz + 1][vl.iy + 1][vl.ix] & mask) - (v[vl.iz + 1][vl.iy + 1][vl.ix + 2] & mask)) * vl.brb;
        double gy = (float)((v[vl.iz][vl.iy - 1][vl.ix] & mask) - (v[vl.iz][vl.iy + 1][vl.ix] & mask)) * vl.tlf + (float)((v[vl.iz][vl.iy][vl.ix] & mask) - (v[vl.iz][vl.iy + 2][vl.ix] & mask)) * vl.blf + (float)((v[vl.iz][vl.iy - 1][vl.ix + 1] & mask) - (v[vl.iz][vl.iy + 1][vl.ix + 1] & mask)) * vl.trf + (float)((v[vl.iz][vl.iy][vl.ix + 1] & mask) - (v[vl.iz][vl.iy + 2][vl.ix + 1] & mask)) * vl.brf + (float)((v[vl.iz + 1][vl.iy - 1][vl.ix] & mask) - (v[vl.iz + 1][vl.iy + 1][vl.ix] & mask)) * vl.tlb + (float)((v[vl.iz + 1][vl.iy][vl.ix] & mask) - (v[vl.iz + 1][vl.iy + 2][vl.ix] & mask)) * vl.blb + (float)((v[vl.iz + 1][vl.iy - 1][vl.ix + 1] & mask) - (v[vl.iz + 1][vl.iy + 1][vl.ix + 1] & mask)) * vl.trb + (float)((v[vl.iz + 1][vl.iy][vl.ix + 1] & mask) - (v[vl.iz + 1][vl.iy + 2][vl.ix + 1] & mask)) * vl.brb;
        double gz = (float)((v[vl.iz - 1][vl.iy][vl.ix] & mask) - (v[vl.iz + 1][vl.iy][vl.ix] & mask)) * vl.tlf + (float)((v[vl.iz - 1][vl.iy + 1][vl.ix] & mask) - (v[vl.iz + 1][vl.iy + 1][vl.ix] & mask)) * vl.blf + (float)((v[vl.iz - 1][vl.iy][vl.ix + 1] & mask) - (v[vl.iz + 1][vl.iy][vl.ix + 1] & mask)) * vl.trf + (float)((v[vl.iz - 1][vl.iy + 1][vl.ix + 1] & mask) - (v[vl.iz + 1][vl.iy + 1][vl.ix + 1] & mask)) * vl.brf + (float)((v[vl.iz][vl.iy][vl.ix] & mask) - (v[vl.iz + 2][vl.iy][vl.ix] & mask)) * vl.tlb + (float)((v[vl.iz][vl.iy + 1][vl.ix] & mask) - (v[vl.iz + 2][vl.iy + 1][vl.ix] & mask)) * vl.blb + (float)((v[vl.iz][vl.iy][vl.ix + 1] & mask) - (v[vl.iz + 2][vl.iy][vl.ix + 1] & mask)) * vl.trb + (float)((v[vl.iz][vl.iy + 1][vl.ix + 1] & mask) - (v[vl.iz + 2][vl.iy + 1][vl.ix + 1] & mask)) * vl.brb;
        VJGradient g = new VJGradient(gx, gy, gz);
        return g;
    }

    @Override
    public String toString() {
        return " trilinear ";
    }

    public static float value(float[] i, int width, int ix, int iy, float dx, float dy) {
        float p11 = i[iy * width + ix];
        float p12 = i[iy * width + (ix + 1)];
        float p21 = i[(iy + 1) * width + ix];
        float p22 = i[(iy + 1) * width + (ix + 1)];
        float p1 = (p12 - p11) * dx + p11;
        float p2 = (p22 - p21) * dx + p21;
        float r1 = (p2 - p1) * dy + p1;
        return r1;
    }

    public static float value(byte[] i, int width, int ix, int iy, float dx, float dy) {
        float p11 = i[iy * width + ix] & 0xFF;
        float p12 = i[iy * width + (ix + 1)] & 0xFF;
        float p21 = i[(iy + 1) * width + ix] & 0xFF;
        float p22 = i[(iy + 1) * width + (ix + 1)] & 0xFF;
        float p1 = (p12 - p11) * dx + p11;
        float p2 = (p22 - p21) * dx + p21;
        float r1 = (p2 - p1) * dy + p1;
        return r1;
    }

    public static float value(short[] i, int width, int ix, int iy, float dx, float dy) {
        float p11 = i[iy * width + ix] & 0xFFFF;
        float p12 = i[iy * width + (ix + 1)] & 0xFFFF;
        float p21 = i[(iy + 1) * width + ix] & 0xFFFF;
        float p22 = i[(iy + 1) * width + (ix + 1)] & 0xFFFF;
        float p1 = (p12 - p11) * dx + p11;
        float p2 = (p22 - p21) * dx + p21;
        float r1 = (p2 - p1) * dy + p1;
        return r1;
    }

    public static float value(int[] i, int width, int ix, int iy, float dx, float dy) {
        VJUserInterface.write("RGB not implemented!!!!");
        return 0.0f;
    }

    public static boolean valid(int width, int height, int ix, int iy) {
        return ix >= 0 && ix + 1 < width && iy >= 0 && iy + 1 < height;
    }
}

