/*
 * Decompiled with CFR 0.152.
 */
package bijnum;

import ij.IJ;

public class BIJJacobi {
    public float[][] a;
    public float[][] eigenvectors;
    public float[] eigenvalues;
    protected boolean doFeedback;
    protected int n;
    protected int nrot;
    protected int sweeps;
    protected static final float UNDERFLOW_LIMIT = 1.0E-13f;
    private double g;
    private double h;
    private double sm;

    public BIJJacobi(float[][] m, boolean doFeedback) {
        this.n = m.length;
        if (m.length != m[0].length) {
            throw new IllegalArgumentException("BIJJacobi: not square matrix");
        }
        this.a = new float[this.n][this.n];
        for (int ip = 0; ip < this.n; ++ip) {
            for (int iq = 0; iq < this.n; ++iq) {
                this.a[ip][iq] = m[ip][iq];
            }
        }
        this.eigenvectors = new float[this.n][this.n];
        this.eigenvalues = new float[this.n];
        this.doFeedback = doFeedback;
    }

    public BIJJacobi(float[][] m) {
        this.n = m.length;
        if (m.length != m[0].length) {
            throw new IllegalArgumentException("BIJJacobi: not square matrix");
        }
        this.a = new float[this.n][this.n];
        for (int ip = 0; ip < this.n; ++ip) {
            for (int iq = 0; iq < this.n; ++iq) {
                this.a[ip][iq] = m[ip][iq];
            }
        }
        this.eigenvectors = new float[this.n][this.n];
        this.eigenvalues = new float[this.n];
    }

    public void compute() {
        this.sweeps = 0;
        this.nrot = 0;
        for (int ip = 0; ip < this.n; ++ip) {
            for (int iq = 0; iq < this.n; ++iq) {
                this.eigenvectors[ip][iq] = 0.0f;
            }
            this.eigenvectors[ip][ip] = 1.0f;
        }
        float[] b = new float[this.n];
        float[] z = new float[this.n];
        for (int ip = 0; ip < this.n; ++ip) {
            b[ip] = this.a[ip][ip];
            this.eigenvalues[ip] = this.a[ip][ip];
            z[ip] = 0.0f;
        }
        for (int i = 0; i < 50; ++i) {
            int ip;
            if (this.doFeedback) {
                IJ.showProgress((double)((double)i / 10.0));
            }
            this.sm = 0.0;
            for (int ip2 = 0; ip2 < this.n - 1; ++ip2) {
                for (int iq = ip2 + 1; iq < this.n; ++iq) {
                    this.sm += (double)Math.abs(this.a[ip2][iq]);
                }
            }
            if (this.sm == 0.0) {
                this.sweeps = i;
                return;
            }
            double thresh = 0.0;
            thresh = i < 3 ? 0.2 * this.sm / (double)(this.n * this.n) : 0.0;
            for (ip = 0; ip < this.n - 1; ++ip) {
                for (int iq = ip + 1; iq < this.n; ++iq) {
                    int j;
                    double t;
                    this.g = 100.0 * (double)Math.abs(this.a[ip][iq]);
                    if (i > 3 && (double)Math.abs(this.eigenvalues[ip]) + this.g == (double)Math.abs(this.eigenvalues[ip]) && (double)Math.abs(this.eigenvalues[iq]) + this.g == (double)Math.abs(this.eigenvalues[iq])) {
                        this.a[ip][iq] = 0.0f;
                        continue;
                    }
                    if (!((double)Math.abs(this.a[ip][iq]) > thresh)) continue;
                    this.h = this.eigenvalues[iq] - this.eigenvalues[ip];
                    if (Math.abs(this.h) + this.g == Math.abs(this.h)) {
                        t = (double)this.a[ip][iq] / this.h;
                    } else {
                        double theta = 0.5 * this.h / (double)this.a[ip][iq];
                        t = 1.0 / (Math.abs(theta) + Math.sqrt(1.0 + theta * theta));
                        if (theta < 0.0) {
                            t = -t;
                        }
                    }
                    double c = 1.0 / (double)((float)Math.sqrt(1.0 + t * t));
                    double s = t * c;
                    double tau = s / (1.0 + c);
                    this.h = t * (double)this.a[ip][iq];
                    int n = ip;
                    z[n] = (float)((double)z[n] - this.h);
                    int n2 = iq;
                    z[n2] = (float)((double)z[n2] + this.h);
                    int n3 = ip;
                    this.eigenvalues[n3] = (float)((double)this.eigenvalues[n3] - this.h);
                    int n4 = iq;
                    this.eigenvalues[n4] = (float)((double)this.eigenvalues[n4] + this.h);
                    this.a[ip][iq] = 0.0f;
                    for (j = 0; j < ip - 1; ++j) {
                        this.rotate(this.a, j, ip, j, iq, s, tau);
                    }
                    for (j = ip + 1; j < iq - 1; ++j) {
                        this.rotate(this.a, ip, j, j, iq, s, tau);
                    }
                    for (j = iq + 1; j < this.n; ++j) {
                        this.rotate(this.a, ip, j, iq, j, s, tau);
                    }
                    for (j = 0; j < this.n; ++j) {
                        this.rotate(this.eigenvectors, j, ip, j, iq, s, tau);
                    }
                    ++this.nrot;
                }
            }
            for (ip = 0; ip < this.n; ++ip) {
                int n = ip;
                b[n] = b[n] + z[ip];
                this.eigenvalues[ip] = b[ip];
                z[ip] = 0.0f;
            }
        }
        System.err.println("Too many iterations in BIJJacobi");
    }

    public void sort() {
        for (int i = 0; i < this.n; ++i) {
            int j;
            int k = i;
            float p = this.eigenvalues[k];
            for (j = i + 1; j < this.n; ++j) {
                if (!(this.eigenvalues[j] >= p)) continue;
                k = j;
                p = this.eigenvalues[k];
            }
            if (k == i) continue;
            this.eigenvalues[k] = this.eigenvalues[i];
            this.eigenvalues[i] = p;
            for (j = 0; j < this.n; ++j) {
                p = this.eigenvectors[j][i];
                this.eigenvectors[j][i] = this.eigenvectors[j][k];
                this.eigenvectors[j][k] = p;
            }
        }
    }

    protected void rotate(float[][] a, int i, int j, int k, int l, double s, double tau) {
        this.g = a[i][j];
        this.h = a[k][l];
        a[i][j] = (float)(this.g - s * (this.h + this.g * tau));
        a[k][l] = (float)(this.h + s * (this.g - this.h * tau));
    }

    public int nrot() {
        return this.nrot;
    }

    public int sweeps() {
        return this.sweeps;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("eigenvalues:\teigenvectors:\n");
        for (int i = 0; i < this.n; ++i) {
            sb.append(this.eigenvalues[i]);
            sb.append(" {");
            for (int j = 0; j < this.n; ++j) {
                sb.append(this.eigenvectors[i][j]);
                sb.append(", ");
            }
            sb.append("} \n");
        }
        sb.append("sweeps: ");
        sb.append(this.sweeps);
        sb.append(" sm=");
        sb.append(this.sm);
        return sb.toString();
    }
}

