/*
 * Decompiled with CFR 0.152.
 */
package bijnum;

import bijnum.BIJmatrix;
import bijnum.BIJpca;
import bijnum.BIJstats;

public class BIJgifa
extends BIJpca {
    public float[][] phi;
    public float[][] rho;
    public float[] gamma;
    public float[] snr;
    public int k;

    public float[][] compute(float[][] a, int k) {
        this.a = a;
        this.k = k;
        int N = this.eigenvectors.length;
        int num = this.eigenvectors[0].length;
        int t = N / k;
        float p = 4.0f;
        float[] ev2 = new float[this.eigenvalues.length];
        BIJmatrix.pow(ev2, this.eigenvalues, 0.5);
        float[][] S = BIJmatrix.diag(ev2);
        float[] abar = BIJstats.meanColumn(this.eigenvectors);
        float[][] condavg = this.submean(this.eigenvectors, k);
        float[][] Cs = new float[num][num];
        for (int i = 0; i < k; ++i) {
            float[] r = BIJmatrix.sub(condavg[i], abar);
            float[][] m = BIJmatrix.mulOuter(r, r);
            BIJmatrix.add(Cs, m);
        }
        BIJmatrix.mul(Cs, Cs, 1 / (k - 1));
        float[][] ahat = new float[N][num];
        for (int j = 0; j < N; ++j) {
            for (int i = 0; i < num; ++i) {
                ahat[j][i] = condavg[j / t][i];
            }
        }
        float[][] Cn = new float[num][num];
        for (int i = 0; i < k; ++i) {
            float[][] Cnt = new float[t][num];
            for (int h = 0; h < t; ++h) {
                for (int g = 0; g < num; ++g) {
                    Cnt[h][g] = a[h * t][g] - ahat[h * t][g];
                }
            }
            float[][] Cnp = new float[num][num];
            BIJmatrix.mul(Cnp, BIJmatrix.transpose(Cnt), Cnt, true);
            BIJmatrix.add(Cn, Cnp);
        }
        BIJmatrix.mul(Cn, Cn, 1 / (k * t - k));
        float[][] SCsS = new float[num][num];
        BIJmatrix.mul(SCsS, S, Cs, true);
        BIJmatrix.mul(SCsS, S, true);
        float[][] pSCnS = new float[num][num];
        BIJmatrix.mul(pSCnS, S, Cn, true);
        BIJmatrix.mul(pSCnS, S, true);
        BIJmatrix.mul(pSCnS, pSCnS, p);
        float[][] SCnSminuspSCnS = new float[num][num];
        BIJmatrix.sub(SCnSminuspSCnS, SCsS, pSCnS);
        return null;
    }

    protected float[][] submean(float[][] F, int k) {
        int iM = F.length;
        int iN = F[0].length;
        float avg = (float)iM / (float)k;
        int iavg = Math.round(avg);
        float[][] G = new float[k][iN];
        for (int n = 0; n < k; ++n) {
            int j = 0;
            while (j < G[0].length) {
                G[n][j] = 0.0f;
                for (int i = 0; i < iavg; ++i) {
                    float[] fArray = G[n];
                    int n2 = j;
                    fArray[n2] = fArray[n2] + F[iavg * n + i][j];
                }
                float[] fArray = G[n];
                int n3 = j++;
                fArray[n3] = fArray[n3] / (float)iavg;
            }
        }
        return G;
    }
}

