/*
 * Decompiled with CFR 0.152.
 */
package bijnum;

import ij.IJ;

public class Jacobi {
    public double[][] eigenvectors;
    public double[] eigenvalues;
    private double g;
    private double h;
    private int n;
    private int nrot;
    private int sweeps;
    private static final double UNDERFLOW_LIMIT = 1.0E-25;

    public Jacobi(int n) {
        this.n = n;
        this.eigenvectors = new double[n][n];
        this.eigenvalues = new double[n];
    }

    private void rotate(double[][] a, int i, int j, int k, int l, double s, double tau) {
        this.g = a[i][j];
        this.h = a[k][l];
        a[i][j] = this.g - s * (this.h + this.g * tau);
        a[k][l] = this.h + s * (this.g - this.h * tau);
    }

    public int nrot() {
        return this.nrot;
    }

    public int sweeps() {
        return this.sweeps;
    }

    public void compute(float[][] aa) {
        double[][] daa = new double[aa.length][aa.length];
        for (int i = 0; i < aa.length; ++i) {
            for (int j = 0; j < aa.length; ++j) {
                daa[i][j] = aa[i][j];
            }
        }
        this.compute(daa);
    }

    public void compute(double[][] aa) {
        this.sweeps = 0;
        this.nrot = 0;
        double[][] a = new double[this.n][this.n];
        for (int ip = 0; ip < this.n; ++ip) {
            for (int iq = 0; iq < this.n; ++iq) {
                this.eigenvectors[ip][iq] = 0.0;
                a[ip][iq] = aa[ip][iq];
            }
            this.eigenvectors[ip][ip] = 1.0;
        }
        double[] b = new double[this.n];
        double[] z = new double[this.n];
        for (int ip = 0; ip < this.n; ++ip) {
            b[ip] = this.eigenvalues[ip] = a[ip][ip];
            z[ip] = 0.0;
        }
        for (int i = 0; i < 100; ++i) {
            int iq;
            int ip;
            double sm = 0.0;
            for (ip = 0; ip < this.n - 1; ++ip) {
                for (iq = ip + 1; iq < this.n; ++iq) {
                    sm += Math.abs(a[ip][iq]);
                }
            }
            if (sm == 0.0) {
                this.sweeps = i;
                return;
            }
            double thresh = i < 3 ? 0.2 * sm / (double)(this.n * this.n) : 0.0;
            for (ip = 0; ip < this.n - 1; ++ip) {
                for (iq = ip + 1; iq < this.n; ++iq) {
                    int j;
                    double t;
                    this.g = 100.0 * Math.abs(a[ip][iq]);
                    if (i > 3 && Math.abs(this.eigenvalues[ip]) + this.g == Math.abs(this.eigenvalues[ip]) && Math.abs(this.eigenvalues[iq]) + this.g == Math.abs(this.eigenvalues[iq])) {
                        a[ip][iq] = 0.0;
                        continue;
                    }
                    if (!(Math.abs(a[ip][iq]) > thresh)) continue;
                    this.h = this.eigenvalues[iq] - this.eigenvalues[ip];
                    if (Math.abs(this.h) + this.g == Math.abs(this.h)) {
                        t = a[ip][iq] / this.h;
                    } else {
                        double theta = 0.5 * this.h / a[ip][iq];
                        t = 1.0 / (Math.abs(theta) + Math.sqrt(1.0 + theta * theta));
                        if (theta < 0.0) {
                            t = -t;
                        }
                    }
                    double c = 1.0 / Math.sqrt(1.0 + t * t);
                    double s = t * c;
                    double tau = s / (1.0 + c);
                    this.h = t * a[ip][iq];
                    int n = ip;
                    z[n] = z[n] - this.h;
                    int n2 = iq;
                    z[n2] = z[n2] + this.h;
                    int n3 = ip;
                    this.eigenvalues[n3] = this.eigenvalues[n3] - this.h;
                    int n4 = iq;
                    this.eigenvalues[n4] = this.eigenvalues[n4] + this.h;
                    a[ip][iq] = 0.0;
                    for (j = 0; j < ip - 1; ++j) {
                        this.rotate(a, j, ip, j, iq, s, tau);
                    }
                    for (j = ip + 1; j < iq - 1; ++j) {
                        this.rotate(a, ip, j, j, iq, s, tau);
                    }
                    for (j = iq + 1; j < this.n; ++j) {
                        this.rotate(a, ip, j, iq, j, s, tau);
                    }
                    for (j = 0; j < this.n; ++j) {
                        this.rotate(this.eigenvectors, j, ip, j, iq, s, tau);
                    }
                    ++this.nrot;
                }
            }
            for (ip = 0; ip < this.n; ++ip) {
                int n = ip;
                b[n] = b[n] + z[ip];
                this.eigenvalues[ip] = b[ip];
                z[ip] = 0.0;
            }
            if (i < 50) continue;
            IJ.log((String)("i >= " + i + " in jacobi"));
        }
    }

    public void sort() {
        double t;
        if (this.eigenvalues.length > 2 && this.eigenvalues[0] < this.eigenvalues[2]) {
            t = this.eigenvalues[0];
            this.eigenvalues[0] = this.eigenvalues[2];
            this.eigenvalues[2] = t;
            t = this.eigenvectors[0][0];
            this.eigenvectors[0][0] = this.eigenvectors[0][1];
            this.eigenvectors[0][1] = t;
            t = this.eigenvectors[2][0];
            this.eigenvectors[2][0] = this.eigenvectors[2][1];
            this.eigenvectors[2][1] = t;
        }
        if (this.eigenvalues[0] < this.eigenvalues[1]) {
            t = this.eigenvalues[0];
            this.eigenvalues[0] = this.eigenvalues[1];
            this.eigenvalues[1] = t;
            t = this.eigenvectors[0][0];
            this.eigenvectors[0][0] = this.eigenvectors[0][1];
            this.eigenvectors[0][1] = t;
            t = this.eigenvectors[1][0];
            this.eigenvectors[1][0] = this.eigenvectors[1][1];
            this.eigenvectors[1][1] = t;
        }
        if (this.eigenvalues.length > 2 && this.eigenvalues[1] < this.eigenvalues[2]) {
            t = this.eigenvalues[1];
            this.eigenvalues[1] = this.eigenvalues[2];
            this.eigenvalues[2] = t;
            t = this.eigenvectors[1][0];
            this.eigenvectors[1][0] = this.eigenvectors[1][1];
            this.eigenvectors[1][1] = t;
            t = this.eigenvectors[2][0];
            this.eigenvectors[2][0] = this.eigenvectors[2][1];
            this.eigenvectors[2][1] = t;
        }
    }

    public int check(double[][] mm) {
        double d;
        double d2;
        double[] diff1 = new double[this.n];
        double[] diff2 = new double[this.n];
        double angle = Math.acos((this.eigenvectors[0][0] * this.eigenvectors[0][1] + this.eigenvectors[1][0] * this.eigenvectors[1][1]) / (Math.sqrt(this.eigenvectors[0][0] * this.eigenvectors[0][0] + this.eigenvectors[1][0] * this.eigenvectors[1][0]) * Math.sqrt(this.eigenvectors[0][1] * this.eigenvectors[0][1] + this.eigenvectors[1][1] * this.eigenvectors[1][1]))) * 180.0 / Math.PI;
        if (angle < 89.5 || angle > 90.5) {
            return 1;
        }
        diff1[0] = mm[0][0] * this.eigenvectors[0][0] + mm[0][1] * this.eigenvectors[1][0];
        diff1[1] = mm[1][0] * this.eigenvectors[0][0] + mm[1][1] * this.eigenvectors[1][0];
        diff1[0] = diff1[0] - this.eigenvalues[0] * this.eigenvectors[0][0];
        diff1[1] = diff1[1] - this.eigenvalues[0] * this.eigenvectors[1][0];
        double length = Math.sqrt(diff1[0] * diff1[0] + diff1[1] * diff1[1]);
        if (d2 > 0.1) {
            return 2;
        }
        diff2[0] = mm[0][0] * this.eigenvectors[0][1] + mm[0][1] * this.eigenvectors[1][1];
        diff2[1] = mm[1][0] * this.eigenvectors[0][1] + mm[1][1] * this.eigenvectors[1][1];
        diff2[0] = diff2[0] - this.eigenvalues[1] * this.eigenvectors[0][1];
        diff2[1] = diff2[1] - this.eigenvalues[1] * this.eigenvectors[1][1];
        length = Math.sqrt(diff2[0] * diff2[0] + diff2[1] * diff2[1]);
        if (d > 0.1) {
            return 3;
        }
        if (this.nrot > 50) {
            return 4;
        }
        return 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("eigenvalues:\teigenvectors:\n");
        for (int i = 0; i < this.n; ++i) {
            sb.append(this.eigenvalues[i]);
            sb.append(" {");
            for (int j = 0; j < this.n; ++j) {
                sb.append(this.eigenvectors[i][j]);
                sb.append(", ");
            }
            sb.append("} \n");
        }
        return sb.toString();
    }
}

