/*
 * Decompiled with CFR 0.152.
 */
package io;

import ij.IJ;
import ij.ImageJ;
import ij.Prefs;
import ij.io.OpenDialog;
import io.FileAndString;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Vector;

public class OpenPreviewDialog
implements ActionListener,
ItemListener,
WindowListener {
    protected Dialog dialog;
    protected static String directory;
    protected String[] names;
    protected TextArea textarea;
    protected FileAndString[] validFiles;
    protected FileAndString[] dirs;
    protected List list;
    protected Button open;
    protected Button cancel;
    protected Choice choiceDir;
    protected Object filter;
    protected boolean canListRoots = true;
    protected boolean canceling = true;
    protected Panel panel;
    protected int indexOfCurrentDir;

    public OpenPreviewDialog(String title, Object filter, String directory) {
        this.filter = filter;
        try {
            File.listRoots();
        }
        catch (Exception ignored) {
            this.canListRoots = false;
        }
        catch (Error ignored) {
            this.canListRoots = false;
        }
        if (!this.canListRoots) {
            OpenDialog od = new OpenDialog("Select any OID file to select directory...", null);
            OpenPreviewDialog _tmp = this;
            directory = od.getDirectory();
        }
        OpenPreviewDialog _tmp1 = this;
        if (directory == null && directory == null) {
            OpenPreviewDialog _tmp2 = this;
            directory = Prefs.getString((String)"dir.image");
        } else {
            OpenPreviewDialog _tmp3 = this;
            if (directory == null) {
                OpenPreviewDialog _tmp4 = this;
            }
        }
        ImageJ ij = IJ.getInstance();
        Object parent = ij == null ? new Frame() : ij;
        this.dialog = new Dialog((Frame)parent, title);
        this.dialog.addWindowListener(this);
        this.dialog.setModal(false);
        if (this.canListRoots) {
            Panel paneldir = new Panel();
            paneldir.setLayout(new FlowLayout());
            this.dialog.add((Component)paneldir, "North");
            Label ldir = new Label("Look in:");
            paneldir.add(ldir);
            this.choiceDir = new Choice();
            this.choiceDir.addItemListener(this);
            this.choiceDir.setSize(150, 20);
            paneldir.add(this.choiceDir);
            this.showDirs(this.choiceDir, directory);
            this.choiceDir.add(" _____________________________");
        }
        this.list = new List(30, false);
        this.list.setMultipleMode(true);
        this.list.addItemListener(this);
        this.list.addActionListener(this);
        this.list.setSize(200, 20);
        this.showFiles(this.list, directory, filter);
        this.list.add("________________________________");
        this.dialog.add((Component)this.list, "West");
        this.textarea = new TextArea(30, 40);
        this.dialog.add((Component)this.textarea, "East");
        this.panel = new Panel();
        this.panel.setLayout(new FlowLayout());
        this.dialog.add((Component)this.panel, "South");
        this.open = new Button("Start");
        this.panel.add(this.open);
        this.open.addActionListener(this);
        this.cancel = new Button("Close");
        this.panel.add(this.cancel);
        this.cancel.addActionListener(this);
        this.dialog.pack();
        this.dialog.show();
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        if (ie.getSource() == this.list) {
            File file = this.validFiles[this.list.getSelectedIndex()].file;
            if (!file.isDirectory()) {
                this.showFileHeader(file);
                return;
            }
            directory = file.getAbsolutePath();
            this.showDirs(this.choiceDir, directory);
            this.showFiles(this.list, directory, this.filter);
        } else if (ie.getSource() == this.choiceDir) {
            directory = this.dirs[this.choiceDir.getSelectedIndex()].file.getAbsolutePath();
            this.showDirs(this.choiceDir, directory);
            this.showFiles(this.list, directory, this.filter);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.cancel) {
            this.names = null;
            directory = null;
            this.canceling = true;
            this.dialog.dispose();
        } else if (ae.getSource() == this.open) {
            this.selectedFileNames();
        }
    }

    protected void selectedFileNames() {
        int[] indices = this.list.getSelectedIndexes();
        if (indices == null) {
            this.names[0] = this.validFiles[this.list.getSelectedIndex()].getFile().getName();
        } else {
            this.names = new String[indices.length];
            for (int i = 0; i < indices.length; ++i) {
                this.names[i] = this.validFiles[indices[i]].getFile().getName();
            }
        }
    }

    @Override
    public void windowActivated(WindowEvent windowevent) {
    }

    @Override
    public void windowClosed(WindowEvent windowevent) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.canceling) {
            this.names = null;
            directory = null;
        }
    }

    @Override
    public void windowDeactivated(WindowEvent windowevent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowevent) {
    }

    @Override
    public void windowIconified(WindowEvent windowevent) {
    }

    @Override
    public void windowOpened(WindowEvent windowevent) {
    }

    public String[] getFileNames() {
        return this.names;
    }

    public String getDirectory() {
        return directory;
    }

    protected void showFileHeader(File file) {
        this.textarea.setText("showFileHeader called");
    }

    protected void showFiles(List list, String directory, Object filter) {
        File f = new File(directory);
        File[] files = null;
        if (this.canListRoots) {
            files = f.listFiles((FileFilter)filter);
        } else {
            String[] fileNames = f.list();
            int n = 0;
            for (int i = 0; i < fileNames.length; ++i) {
                if (!((FilenameFilter)filter).accept(new File(directory), fileNames[i])) continue;
                ++n;
            }
            files = new File[n];
            int j = 0;
            for (int i = 0; i < fileNames.length; ++i) {
                if (!((FilenameFilter)filter).accept(new File(directory), fileNames[i])) continue;
                files[j++] = new File(directory, fileNames[i]);
            }
        }
        this.validFiles = new FileAndString[files.length];
        for (int i = 0; i < files.length; ++i) {
            this.validFiles[i] = new FileAndString(files[i], this.validFileDescription(files[i]));
        }
        try {
            Arrays.sort(this.validFiles);
        }
        catch (Exception i) {
            // empty catch block
        }
        list.removeAll();
        for (int i = 0; i < this.validFiles.length; ++i) {
            String name = null;
            if (this.validFiles[i].file.isDirectory()) {
                StringBuffer sb = new StringBuffer();
                sb.append("<DIR> ");
                sb.append(this.validFiles[i].string);
                name = sb.toString();
            } else {
                name = this.validFiles[i].string;
            }
            list.add(name);
        }
    }

    protected String validFileDescription(File file) {
        return file.getName();
    }

    protected void showDirs(Choice choiceDir, String directory) {
        this.dirs = this.getTree(directory);
        choiceDir.removeAll();
        for (int i = 0; i < this.dirs.length; ++i) {
            choiceDir.add(this.dirs[i].string);
        }
        choiceDir.select(this.indexOfCurrentDir);
    }

    protected FileAndString[] getTree(String path) {
        Vector<FileAndString> v = new Vector<FileAndString>();
        File[] roots = File.listRoots();
        File current = new File(path);
        for (int i = 0; i < roots.length; ++i) {
            FileAndString fas = new FileAndString(roots[i], roots[i].getAbsolutePath());
            v.addElement(fas);
            int j = v.size();
            String rootName = roots[i].getAbsolutePath();
            if (rootName == null || !current.getAbsolutePath().startsWith(rootName)) continue;
            this.addPathTree(v, current);
            this.indexOfCurrentDir = v.size() - 1;
        }
        v.addElement(new FileAndString(null, "                          "));
        FileAndString[] tree = new FileAndString[v.size()];
        for (int i = 0; i < tree.length; ++i) {
            tree[i] = (FileAndString)v.elementAt(i);
        }
        return tree;
    }

    protected void addPathTree(Vector v, File current) {
        Vector<File> tv = new Vector<File>();
        while (current != null) {
            tv.insertElementAt(current, 0);
            current = current.getParentFile();
        }
        StringBuffer spaces = new StringBuffer(" ");
        for (int i = 0; i < tv.size(); ++i) {
            File file = (File)tv.elementAt(i);
            FileAndString fas = new FileAndString(file, spaces.toString() + file.getName());
            if (!file.getName().equals("")) {
                v.addElement(fas);
            }
            spaces.append("  ");
        }
    }
}

