/*
 * Decompiled with CFR 0.152.
 */
package io;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.util.StringSorter;
import java.io.File;

public class Open_Different_Sizes_As_Stack
implements PlugIn {
    public void run(String arg) {
        int height = 0;
        int width = 0;
        OpenDialog od = new OpenDialog("Open Different Sizes As Stack", arg);
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        String[] list = new File(directory).list();
        if (list == null) {
            return;
        }
        StringSorter.sort((String[])list);
        if (IJ.debugMode) {
            IJ.log((String)("FolderOpener: " + directory + " (" + list.length + " files)"));
        }
        ImagePlus impl = null;
        for (int i = 0; i < list.length; ++i) {
            ImagePlus imp = new Opener().openImage(directory, list[i]);
            if (imp == null) {
                IJ.log((String)(list[i] + ": unable to open"));
                continue;
            }
            if (width >= imp.getWidth() && height >= imp.getHeight()) continue;
            width = imp.getWidth();
            height = imp.getHeight();
            impl = imp;
        }
        ImageStack stack = new ImageStack(width, height);
        for (int i = 0; i < list.length; ++i) {
            int x;
            int offset;
            int y;
            ImagePlus imp = new Opener().openImage(directory, list[i]);
            String title = imp.getTitle();
            IJ.showStatus((String)(stack.getSize() + 1 + "/" + list.length + ": " + title));
            if (imp == null) {
                IJ.log((String)(list[i] + ": unable to open"));
                continue;
            }
            FloatProcessor ip = new FloatProcessor(width, height);
            imp.getProcessor().flipHorizontal();
            float[] f = (float[])ip.getPixels();
            Object p = imp.getProcessor().getPixels();
            if (p instanceof byte[]) {
                byte[] b = (byte[])p;
                for (y = 0; y < height; ++y) {
                    offset = y * imp.getWidth();
                    for (x = 0; x < width; ++x) {
                        f[y * width + x] = y < imp.getHeight() && x < imp.getWidth() ? (float)(b[offset + x] & 0xFF) : 0.0f;
                    }
                }
            } else if (p instanceof short[]) {
                short[] u = (short[])p;
                for (y = 0; y < height; ++y) {
                    offset = y * imp.getWidth();
                    for (x = 0; x < width; ++x) {
                        f[y * width + x] = y < imp.getHeight() && x < imp.getWidth() ? (float)u[offset + x] : 0.0f;
                    }
                }
            } else if (p instanceof float[]) {
                float[] ff = (float[])p;
                for (y = 0; y < height; ++y) {
                    offset = y * imp.getWidth();
                    for (x = 0; x < width; ++x) {
                        f[y * width + x] = y < imp.getHeight() && x < imp.getWidth() ? ff[offset + x] : 0.0f;
                    }
                }
            } else if (p instanceof int[]) {
                int[] ii = (int[])p;
                for (y = 0; y < height; ++y) {
                    offset = y * imp.getWidth();
                    for (x = 0; x < width; ++x) {
                        if (y < imp.getHeight() && x < imp.getWidth()) {
                            int c = ii[offset + x];
                            int r = (c & 0xFF0000) >> 16;
                            int g = (c & 0xFF00) >> 8;
                            int b = c & 0xFF;
                            f[y * width + x] = (float)((double)r * 0.3 + (double)g * 0.59 + (double)b * 0.11);
                            continue;
                        }
                        f[y * width + x] = 0.0f;
                    }
                }
            }
            stack.addSlice(title, (ImageProcessor)ip);
        }
        stack.setColorModel(impl.getProcessor().getColorModel());
        if (stack.getSize() > 1) {
            ImagePlus imp = new ImagePlus(name, stack);
            imp.show();
        }
        IJ.register(Open_Different_Sizes_As_Stack.class);
    }
}

