/*
 * Decompiled with CFR 0.152.
 */
package knn;

import ij.process.ColorProcessor;
import knn.DOGFilterBank;
import knn.Feature;
import knn.FilterBank;
import knn.StereoFilterBank;
import volume.Hessian;

public class FeatureComputer {
    protected static final float[] scales = new float[]{2.0f, 4.0f, 8.0f, 16.0f};
    protected static final float[] hessian_scales = new float[]{8.0f, 16.0f, 32.0f};
    protected static final float[] shift_scales = new float[]{0.0f};
    protected static final float[] xshifts = new float[]{-6.0f, -5.5f, -5.0f, -4.5f, -4.0f, -3.5f, -3.0f, -2.5f, -2.0f, -1.5f, -1.0f, -0.5f, 0.0f, 0.5f, 1.0f, 1.5f, 2.0f, 2.5f, 3.0f, 3.5f, 4.0f, 4.5f, 5.0f, 5.5f, 6.0f, 6.5f, 7.0f};
    protected static final float[] dog_scales = new float[]{1.0f, 2.0f, 4.0f};
    protected static final float[] dog_xshifts = new float[]{-8.0f, -6.0f, -4.0f, -2.0f, 0.0f, 2.0f, 4.0f, 6.0f, 8.0f};
    protected static FilterBank filterBank;
    protected static StereoFilterBank stereoFilter;
    protected static DOGFilterBank dogFilter;

    public static Feature compute(int featurenumber, ColorProcessor lp, ColorProcessor rp, float[] lequalized) throws Exception {
        Feature feature = null;
        float[] pixels = null;
        pixels = lequalized;
        switch (featurenumber) {
            case 0: {
                feature = new Feature(FeatureComputer.name(featurenumber), pixels);
                break;
            }
            case 1: {
                byte[] h = new byte[lp.getWidth() * lp.getHeight()];
                byte[] s = new byte[lp.getWidth() * lp.getHeight()];
                byte[] b = new byte[lp.getWidth() * lp.getHeight()];
                lp.getHSB(h, s, b);
                feature = new Feature(FeatureComputer.name(featurenumber), h);
                break;
            }
            case 2: {
                byte[] h = new byte[lp.getWidth() * lp.getHeight()];
                byte[] s = new byte[lp.getWidth() * lp.getHeight()];
                byte[] b = new byte[lp.getWidth() * lp.getHeight()];
                lp.getHSB(h, s, b);
                feature = new Feature(FeatureComputer.name(featurenumber), s);
                break;
            }
            case 3: {
                byte[] h = new byte[lp.getWidth() * lp.getHeight()];
                byte[] s = new byte[lp.getWidth() * lp.getHeight()];
                byte[] b = new byte[lp.getWidth() * lp.getHeight()];
                lp.getHSB(h, s, b);
                feature = new Feature(FeatureComputer.name(featurenumber), b);
                break;
            }
            case 4: {
                pixels = FeatureComputer.distanceToCenterHorizontal(lp.getWidth(), lp.getHeight());
                feature = new Feature(FeatureComputer.name(featurenumber), pixels);
                break;
            }
            case 5: {
                pixels = FeatureComputer.distanceToCenterVertical(lp.getWidth(), lp.getHeight());
                feature = new Feature(FeatureComputer.name(featurenumber), pixels);
                break;
            }
            case 6: {
                Hessian.largest(pixels, pixels, lp.getWidth(), hessian_scales[0]);
                feature = new Feature(FeatureComputer.name(featurenumber), pixels);
                break;
            }
            case 7: {
                Hessian.largest(pixels, pixels, lp.getWidth(), hessian_scales[1]);
                feature = new Feature(FeatureComputer.name(featurenumber), pixels);
                break;
            }
            case 8: {
                if (stereoFilter == null) {
                    stereoFilter = new StereoFilterBank(shift_scales, xshifts);
                }
                feature = stereoFilter.depth((float[])lp.convertToFloat().getPixels(), (float[])rp.convertToFloat().getPixels(), lp.getWidth(), StereoFilterBank.toString(FeatureComputer.featureNamePrefix(featurenumber)));
                break;
            }
            default: {
                if (filterBank == null) {
                    filterBank = new FilterBank(scales, 3);
                }
                if (stereoFilter == null) {
                    stereoFilter = new StereoFilterBank(shift_scales, xshifts);
                }
                if (dogFilter == null) {
                    dogFilter = new DOGFilterBank(dog_scales, dog_xshifts);
                }
                int filternumber = featurenumber - 9;
                int stereofilternumber = filternumber - filterBank.getNumber();
                int dogfilternumber = stereofilternumber - stereoFilter.getNumber();
                if (filternumber >= 0 && filternumber < filterBank.getNumber()) {
                    feature = filterBank.filter(filternumber, pixels, lp.getWidth(), filterBank.toString(filternumber, FeatureComputer.featureNamePrefix(featurenumber)));
                    break;
                }
                if (stereofilternumber >= 0 && stereofilternumber < stereoFilter.getNumber()) {
                    feature = stereoFilter.filter(stereofilternumber, (float[])lp.convertToFloat().getPixels(), (float[])rp.convertToFloat().getPixels(), lp.getWidth(), stereoFilter.toString(stereofilternumber, FeatureComputer.featureNamePrefix(featurenumber)));
                    break;
                }
                if (dogfilternumber < 0 || dogfilternumber >= dogFilter.getNumber()) break;
                feature = dogFilter.filter(dogfilternumber, (float[])lp.convertToFloat().getPixels(), (float[])rp.convertToFloat().getPixels(), lp.getWidth(), dogFilter.toString(dogfilternumber, FeatureComputer.featureNamePrefix(featurenumber)));
                break;
            }
        }
        if (feature != null) {
            feature.unitvar();
        }
        return feature;
    }

    public static String featureNamePrefix(int featurenumber) {
        return "" + featurenumber + "_";
    }

    public static String name(int featurenumber) {
        String name = FeatureComputer.featureNamePrefix(featurenumber) + "unknown feature";
        switch (featurenumber) {
            case 0: {
                name = FeatureComputer.featureNamePrefix(featurenumber) + "intensity left";
                break;
            }
            case 1: {
                name = FeatureComputer.featureNamePrefix(featurenumber) + "Hue left";
                break;
            }
            case 2: {
                name = FeatureComputer.featureNamePrefix(featurenumber) + "Saturation left";
                break;
            }
            case 3: {
                name = FeatureComputer.featureNamePrefix(featurenumber) + "Brightness left";
                break;
            }
            case 4: {
                name = FeatureComputer.featureNamePrefix(featurenumber) + "Distance center x";
                break;
            }
            case 5: {
                name = FeatureComputer.featureNamePrefix(featurenumber) + "Distance center y";
                break;
            }
            case 6: 
            case 7: {
                name = FeatureComputer.featureNamePrefix(featurenumber) + "Hessian eigenvalues scale=" + hessian_scales[featurenumber - 6];
                break;
            }
            case 8: {
                name = FeatureComputer.featureNamePrefix(featurenumber) + "Simple depth map";
                break;
            }
            default: {
                int filternumber = featurenumber - 9;
                int stereofilternumber = filternumber - filterBank.getNumber();
                int dogfilternumber = stereofilternumber - stereoFilter.getNumber();
                if (filternumber >= 0 && filternumber < filterBank.getNumber()) {
                    name = filterBank.toString(filternumber, FeatureComputer.featureNamePrefix(featurenumber));
                    break;
                }
                if (stereofilternumber >= 0 && stereofilternumber < stereoFilter.getNumber()) {
                    name = stereoFilter.toString(stereofilternumber, FeatureComputer.featureNamePrefix(featurenumber));
                    break;
                }
                if (dogfilternumber >= 0 && dogfilternumber < dogFilter.getNumber()) {
                    name = dogFilter.toString(dogfilternumber, FeatureComputer.featureNamePrefix(featurenumber));
                    break;
                }
                name = "unknown feature " + featurenumber;
                System.err.println("Error trying to create incorrect featurenumber " + featurenumber + " " + filternumber + " " + stereofilternumber + " " + dogfilternumber);
            }
        }
        return name;
    }

    public static float[] distanceToCenterHorizontal(int width, int height) {
        float xmax = (float)width / 2.0f;
        float ymax = (float)height / 2.0f;
        float[] t = new float[width * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float xd = (float)x - (float)width / 2.0f;
                t[y * width + x] = xd / xmax;
            }
        }
        return t;
    }

    public static float[] distanceToCenterVertical(int width, int height) {
        float xmax = (float)width / 2.0f;
        float ymax = (float)height / 2.0f;
        float[] t = new float[width * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float yd = (float)y - (float)height / 2.0f;
                t[y * width + x] = yd / ymax;
            }
        }
        return t;
    }
}

