/*
 * Decompiled with CFR 0.152.
 */
package knn;

import bijnum.BIJmatrix;
import java.util.Enumeration;
import java.util.Vector;
import knn.Feature;

public class Features
extends Vector {
    public Features() {
    }

    public Features(float[][] fts, int startindex, String name) {
        for (int i = startindex; i < fts.length; ++i) {
            Feature f = new Feature(name + " " + i, fts[i]);
            this.addElement(f);
        }
    }

    public float[][] toMatrix() {
        float[][] matrix = new float[this.size()][];
        int i = 0;
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            matrix[i++] = (float[])e.nextElement();
        }
        return matrix;
    }

    public void add(Feature[] newfeatures) {
        for (int i = 0; i < newfeatures.length; ++i) {
            this.addElement(newfeatures[i]);
        }
    }

    public void add(Feature newfeature) {
        this.addElement(newfeature);
    }

    public void add(Vector newfeatures) {
        Enumeration e = newfeatures.elements();
        while (e.hasMoreElements()) {
            this.addElement(e.nextElement());
        }
    }

    public float[][] subset(int[] indices) {
        float[][] matrix = new float[indices.length][];
        for (int i = 0; i < indices.length; ++i) {
            Feature f = (Feature)this.elementAt(indices[i]);
            matrix[i] = f.toVector();
        }
        return BIJmatrix.transpose(matrix);
    }

    public Features sample(int[] indices) {
        Features nf = new Features();
        int i = 0;
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Feature f = (Feature)e.nextElement();
            ++i;
            float[] v = f.toVector();
            float[] nv = BIJmatrix.subset(v, indices);
            nf.add(new Feature(f.toString(), nv));
        }
        return nf;
    }

    public int length() {
        Feature f = (Feature)this.elementAt(0);
        return f.toVector().length;
    }

    public String toString(int i) {
        Feature f = (Feature)this.elementAt(i);
        return f.toString();
    }

    public float[] toVector(int i) {
        Feature f = (Feature)this.elementAt(i);
        return f.toVector();
    }
}

