/*
 * Decompiled with CFR 0.152.
 */
package registration;

import bijnum.BIJutil;
import ij.ImagePlus;
import ij.gui.OvalRoi;
import ij.gui.Roi;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.util.Enumeration;
import java.util.Vector;

public class LocatedCircle {
    protected float x;
    protected float y;
    protected float radius;
    protected float confidence;

    public LocatedCircle(double x, double y, double radius, double confidence) {
        this.x = (float)x;
        this.y = (float)y;
        this.radius = (float)radius;
        this.confidence = (float)confidence;
    }

    public LocatedCircle(double x, double y, double radius) {
        this.x = (float)x;
        this.y = (float)y;
        this.radius = (float)radius;
        this.confidence = 0.0f;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = (float)radius;
    }

    public void drawOutline(ImagePlus imp) {
        OvalRoi circleroi = new OvalRoi((int)(this.x - this.radius), (int)(this.y - this.radius), (int)(2.0f * this.radius), (int)(2.0f * this.radius), imp);
        circleroi.drawPixels();
    }

    public void drawCenter(ImageProcessor ip) {
        int k;
        int i = (int)this.x;
        int j = (int)this.y;
        for (k = -10; k <= 10; ++k) {
            ip.putPixel(i, j + k, 255);
            ip.putPixel(i + k, j, 255);
        }
        for (k = -2; k <= 2; ++k) {
            ip.putPixel(i + k, j - 2, 255);
            ip.putPixel(i + k, j + 2, 255);
            ip.putPixel(i + 2, j + k, 255);
            ip.putPixel(i - 2, j + k, 255);
        }
    }

    public OvalRoi getRoi(int width, int height) {
        int fitDiameter = (int)Math.min((float)width, Math.min((float)height, 2.0f * this.radius));
        OvalRoi roi = new OvalRoi((int)Math.min(Math.max(0.0f, this.x - this.radius), (float)(width - fitDiameter)), (int)Math.min(Math.max(0.0f, this.y - this.radius), (float)(height - fitDiameter)), fitDiameter, fitDiameter);
        return roi;
    }

    public ImageProcessor getCircleCentersImageProcessor(ImagePlus imp, Vector circles) {
        ImageProcessor ip = imp.getProcessor();
        int width = imp.getWidth();
        int height = imp.getHeight();
        byte[] plane = (byte[])ip.getPixels();
        Enumeration e = circles.elements();
        while (e.hasMoreElements()) {
            int k;
            LocatedCircle hc = (LocatedCircle)e.nextElement();
            OvalRoi circleroi = new OvalRoi((int)(hc.getX() - hc.getRadius()), (int)(hc.getY() - hc.getRadius()), (int)(2.0 * hc.getRadius()), (int)(2.0 * hc.getRadius()), imp);
            circleroi.drawPixels();
            int i = (int)hc.getX();
            int j = (int)hc.getY();
            for (k = -10; k <= 10; ++k) {
                if (j + k >= 0 && j + k < height && i >= 0 && i < width) {
                    plane[(j + k) * width + i] = -1;
                }
                if (j < 0 || j >= height || i + k < 0 || i + k >= width) continue;
                plane[j * width + i + k] = -1;
            }
            for (k = -2; k <= 2; ++k) {
                if (j - 2 >= 0 && j - 2 < height && i + k >= 0 && i + k < width) {
                    plane[(j - 2) * width + i + k] = -1;
                }
                if (j + 2 >= 0 && j + 2 < height && i + k >= 0 && i + k < width) {
                    plane[(j + 2) * width + i + k] = -1;
                }
                if (j + k >= 0 && j + k < height && i - 2 >= 0 && i - 2 < width) {
                    plane[(j + k) * width + i - 2] = -1;
                }
                if (j + k < 0 || j + k >= height || i + 2 < 0 || i + 2 >= width) continue;
                plane[(j + k) * width + i + 2] = -1;
            }
        }
        return ip;
    }

    public float[] getMask(int width, int height) {
        ByteProcessor mp = new ByteProcessor(width, height);
        ImagePlus np = new ImagePlus("mask", (ImageProcessor)mp);
        int fitDiameter = (int)Math.min((float)width, Math.min((float)height, 2.0f * this.radius));
        OvalRoi roi = new OvalRoi((int)Math.min(Math.max(0.0f, this.x - this.radius), (float)(width - fitDiameter)), (int)Math.min(Math.max(0.0f, this.y - this.radius), (float)(height - fitDiameter)), fitDiameter, fitDiameter);
        return BIJutil.getMask((Roi)roi, width, height);
    }

    public static float[] getMask(LocatedCircle c, float[] reference, int width) {
        float[] mask = c.getMask(width, reference.length / width);
        float[] clone = new float[reference.length];
        for (int i = 0; i < clone.length; ++i) {
            clone[i] = reference[i];
        }
        ImagePlus overlay = new ImagePlus("Can be discarded, confirmation only: reference FOV", (ImageProcessor)new FloatProcessor(width, reference.length / width, clone, null));
        c.drawCenter(overlay.getProcessor());
        c.drawOutline(overlay);
        overlay.show();
        return mask;
    }

    public String toString() {
        return "Center at " + this.x + ", " + this.y + ", radius " + this.radius + " at " + this.confidence;
    }
}

