/*
 * Decompiled with CFR 0.152.
 */
package volume;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import java.awt.Frame;
import volume.HyperVolume;
import volume.VolumeFloat;

public class Diffusion3D {
    protected static int iterations = 10;
    protected static double k = 2.0;
    protected static double lambda = 1.0;
    protected int depth = 23;
    protected boolean scaleSpaceContrast = false;
    protected VolumeFloat v;
    protected HyperVolume hv;

    public boolean params(ImagePlus imp, VolumeFloat v) {
        this.v = v;
        GenericDialog gd = new GenericDialog("3D diffusion", (Frame)imp.getWindow());
        gd.addNumericField("lambda", lambda, 2);
        gd.addNumericField("iterations", (double)iterations, 0);
        gd.addNumericField("k", k, 2);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        lambda = gd.getNextNumber();
        iterations = (int)gd.getNextNumber();
        k = gd.getNextNumber();
        return true;
    }

    public void compute3D() {
        VolumeFloat nv = new VolumeFloat(this.v.getWidth(), this.v.getHeight(), this.v.getDepth());
        nv.setEdge(1);
        this.v.setEdge(1);
        VolumeFloat v1 = this.v;
        VolumeFloat v2 = nv;
        IJ.showStatus((String)("3D Nonlinear diffusion (lambda " + lambda + " k " + k + " n " + iterations + ")"));
        for (int i = 0; i < iterations; ++i) {
            IJ.showProgress((double)((double)i / (double)iterations));
            for (int z = 0; z < this.v.getDepth(); ++z) {
                for (int y = 0; y < this.v.getHeight(); ++y) {
                    for (int x = 0; x < this.v.getWidth(); ++x) {
                        if (v1.valid(x, y, z)) {
                            double cD;
                            double cU;
                            double cW;
                            double cE;
                            double cS;
                            double cN;
                            double n = Diffusion3D.dN(v1, x, y, z);
                            double s = Diffusion3D.dS(v1, x, y, z);
                            double e = Diffusion3D.dE(v1, x, y, z);
                            double w = Diffusion3D.dW(v1, x, y, z);
                            double u = Diffusion3D.dU(v1, x, y, z);
                            double d = Diffusion3D.dD(v1, x, y, z);
                            if (this.scaleSpaceContrast) {
                                cN = Diffusion3D.gScaleSpace(Math.abs(n), k);
                                cS = Diffusion3D.gScaleSpace(Math.abs(s), k);
                                cE = Diffusion3D.gScaleSpace(Math.abs(e), k);
                                cW = Diffusion3D.gScaleSpace(Math.abs(w), k);
                                cU = Diffusion3D.gScaleSpace(Math.abs(u), k);
                                cD = Diffusion3D.gScaleSpace(Math.abs(d), k);
                            } else {
                                cN = Diffusion3D.g(Math.abs(n), k);
                                cS = Diffusion3D.g(Math.abs(s), k);
                                cE = Diffusion3D.g(Math.abs(e), k);
                                cW = Diffusion3D.g(Math.abs(w), k);
                                cU = Diffusion3D.g(Math.abs(u), k);
                                cD = Diffusion3D.g(Math.abs(d), k);
                            }
                            v2.v[z][y][x] = (float)((double)v1.v[z][y][x] + lambda * (cN * n + cS * s + cE * e + cW * w + cU * u + cD * d));
                            continue;
                        }
                        v2.v[z][y][x] = 0.0f;
                    }
                }
            }
            VolumeFloat t = v1;
            v1 = v2;
            v2 = t;
        }
        if (iterations % 2 != 0) {
            for (int z = 0; z < this.v.getDepth(); ++z) {
                for (int y = 0; y < this.v.getHeight(); ++y) {
                    for (int x = 0; x < this.v.getWidth(); ++x) {
                        this.v.v[z][y][x] = v1.v[z][y][x];
                    }
                }
            }
        }
    }

    public boolean params4D(ImagePlus imp) {
        GenericDialog gd = new GenericDialog("4D diffusion", (Frame)imp.getWindow());
        iterations = 100;
        gd.addNumericField("lambda", lambda, 2);
        gd.addNumericField("iterations", (double)iterations, 0);
        gd.addNumericField("k", k, 2);
        gd.addNumericField("3D depth", (double)this.depth, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        lambda = gd.getNextNumber();
        iterations = (int)gd.getNextNumber();
        k = gd.getNextNumber();
        this.depth = (int)gd.getNextNumber();
        this.hv = new HyperVolume(imp.getStack(), this.depth);
        return true;
    }

    public void compute4D() {
        HyperVolume nv = new HyperVolume(this.hv.getWidth(), this.hv.getHeight(), this.hv.getDepth(), this.hv.getLength());
        nv.setEdge(1);
        this.hv.setEdge(1);
        HyperVolume v1 = this.hv;
        HyperVolume v2 = nv;
        IJ.showStatus((String)("4D Nonlinear diffusion (lambda " + lambda + " k " + k + " n " + iterations + ")"));
        for (int i = 0; i < iterations; ++i) {
            IJ.showProgress((double)((double)i / (double)iterations));
            for (int t = 0; t < this.hv.getLength(); ++t) {
                for (int z = 0; z < this.hv.getDepth(); ++z) {
                    for (int y = 0; y < this.hv.getHeight(); ++y) {
                        for (int x = 0; x < this.hv.getWidth(); ++x) {
                            if (v1.valid(x, y, z, t)) {
                                double cA;
                                double cB;
                                double cD;
                                double cU;
                                double cW;
                                double cE;
                                double cS;
                                double cN;
                                double n = Diffusion3D.dN(v1, x, y, z, t);
                                double s = Diffusion3D.dS(v1, x, y, z, t);
                                double e = Diffusion3D.dE(v1, x, y, z, t);
                                double w = Diffusion3D.dW(v1, x, y, z, t);
                                double u = Diffusion3D.dU(v1, x, y, z, t);
                                double d = Diffusion3D.dD(v1, x, y, z, t);
                                double b = Diffusion3D.dB(v1, x, y, z, t);
                                double a = Diffusion3D.dA(v1, x, y, z, t);
                                if (this.scaleSpaceContrast) {
                                    cN = Diffusion3D.gScaleSpace(Math.abs(n), k);
                                    cS = Diffusion3D.gScaleSpace(Math.abs(s), k);
                                    cE = Diffusion3D.gScaleSpace(Math.abs(e), k);
                                    cW = Diffusion3D.gScaleSpace(Math.abs(w), k);
                                    cU = Diffusion3D.gScaleSpace(Math.abs(u), k);
                                    cD = Diffusion3D.gScaleSpace(Math.abs(d), k);
                                    cB = Diffusion3D.gScaleSpace(Math.abs(b), k);
                                    cA = Diffusion3D.gScaleSpace(Math.abs(a), k);
                                } else {
                                    cN = Diffusion3D.g(Math.abs(n), k);
                                    cS = Diffusion3D.g(Math.abs(s), k);
                                    cE = Diffusion3D.g(Math.abs(e), k);
                                    cW = Diffusion3D.g(Math.abs(w), k);
                                    cU = Diffusion3D.g(Math.abs(u), k);
                                    cD = Diffusion3D.g(Math.abs(d), k);
                                    cB = Diffusion3D.g(Math.abs(b), k);
                                    cA = Diffusion3D.g(Math.abs(a), k);
                                }
                                v2.hv[t][z][y][x] = (float)((double)v1.hv[t][z][y][x] + lambda * (cN * n + cS * s + cE * e + cW * w + cU * u + cD * d + cB * b + cA * a));
                                continue;
                            }
                            v2.hv[t][z][y][x] = 0.0f;
                        }
                    }
                }
            }
            HyperVolume vt = v1;
            v1 = v2;
            v2 = vt;
        }
        if (iterations % 2 != 0) {
            for (int t = 0; t < this.hv.getLength(); ++t) {
                for (int z = 0; z < this.hv.getDepth(); ++z) {
                    for (int y = 0; y < this.hv.getHeight(); ++y) {
                        for (int x = 0; x < this.hv.getWidth(); ++x) {
                            this.hv.hv[t][z][y][x] = v1.hv[t][z][y][x];
                        }
                    }
                }
            }
        }
    }

    public void intoStack(ImageStack is) {
        if (this.v instanceof VolumeFloat) {
            this.v.intoStack(is);
        } else if (this.hv instanceof HyperVolume) {
            this.hv.intoStack(is);
        }
    }

    protected static double gScaleSpace(double a, double k) {
        return Math.exp(-Math.pow(a / k, 2.0));
    }

    protected static double g(double grad, double k) {
        return 1.0 / (1.0 + Math.pow(grad / k, 2.0));
    }

    protected static double dN(VolumeFloat v, int x, int y, int z) {
        return v.v[z][y - 1][x] - v.v[z][y][x];
    }

    protected static double dS(VolumeFloat v, int x, int y, int z) {
        return v.v[z][y + 1][x] - v.v[z][y][x];
    }

    protected static double dE(VolumeFloat v, int x, int y, int z) {
        return v.v[z][y][x + 1] - v.v[z][y][x];
    }

    protected static double dW(VolumeFloat v, int x, int y, int z) {
        return v.v[z][y][x - 1] - v.v[z][y][x];
    }

    protected static double dU(VolumeFloat v, int x, int y, int z) {
        return v.v[z - 1][y][x] - v.v[z][y][x];
    }

    protected static double dD(VolumeFloat v, int x, int y, int z) {
        return v.v[z + 1][y][x] - v.v[z][y][x];
    }

    protected static double dN(HyperVolume v, int x, int y, int z, int t) {
        return v.hv[t][z][y - 1][x] - v.hv[t][z][y][x];
    }

    protected static double dS(HyperVolume v, int x, int y, int z, int t) {
        return v.hv[t][z][y + 1][x] - v.hv[t][z][y][x];
    }

    protected static double dE(HyperVolume v, int x, int y, int z, int t) {
        return v.hv[t][z][y][x + 1] - v.hv[t][z][y][x];
    }

    protected static double dW(HyperVolume v, int x, int y, int z, int t) {
        return v.hv[t][z][y][x - 1] - v.hv[t][z][y][x];
    }

    protected static double dU(HyperVolume v, int x, int y, int z, int t) {
        return v.hv[t][z - 1][y][x] - v.hv[t][z][y][x];
    }

    protected static double dD(HyperVolume v, int x, int y, int z, int t) {
        return v.hv[t][z + 1][y][x] - v.hv[t][z][y][x];
    }

    protected static double dB(HyperVolume v, int x, int y, int z, int t) {
        return v.hv[t - 1][z][y][x] - v.hv[t][z][y][x];
    }

    protected static double dA(HyperVolume v, int x, int y, int z, int t) {
        return v.hv[t + 1][z][y][x] - v.hv[t][z][y][x];
    }
}

