/*
 * Decompiled with CFR 0.152.
 */
package volume;

import bijnum.BIJmatrix;
import bijnum.BIJtransform;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;

public class Transformer {
    public static float[] transform(float[] image, int width, float[] p) throws Exception {
        return Transformer.transform(image, width, p, width / 2, image.length / width / 2);
    }

    public static float[] transform(float[] image, int width, float[] p, float xcenter, float ycenter) throws Exception {
        float[][] m = Transformer.convertParametersIntoTransformationMatrix(p, xcenter, ycenter);
        return Transformer.transform(image, width, m);
    }

    public static float[] transform(float[] image, int width, float[][] m) throws Exception {
        float[][] mi = null;
        mi = BIJmatrix.inverse(m);
        int height = image.length / width;
        float[] tr = new float[image.length];
        float[] v = new float[3];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                v[0] = x;
                v[1] = y;
                v[2] = 1.0f;
                float[] tv = null;
                tv = BIJmatrix.mul(mi, v);
                tr[y * width + x] = Transformer.bilinearExtend(image, width, height, tv[0], tv[1]);
            }
        }
        return tr;
    }

    public static float[][] convertParametersIntoTransformationMatrix(float[] p, float xcenter, float ycenter) {
        float[][] m = BIJtransform.newMatrix(2);
        if (p.length == 2) {
            m = BIJtransform.translate(m, p[0], p[1]);
        }
        if (p.length == 3) {
            m = BIJtransform.rotatez(BIJtransform.translate(BIJtransform.translate(m, xcenter, ycenter), p[0], p[1]), p[2]);
            m = BIJtransform.translate(m, -xcenter, -ycenter);
        }
        if (p.length == 5) {
            m = BIJtransform.scale(BIJtransform.rotatez(BIJtransform.translate(m, p[0], p[1]), p[2]), p[3], p[4]);
        }
        return m;
    }

    public static float[][] convertParametersIntoTransformationMatrix(float[] p) {
        return Transformer.convertParametersIntoTransformationMatrix(p, 0.0f, 0.0f);
    }

    public static float[][] convertParametersIntoTransformationMatrix(double[] p) {
        float[][] m = BIJtransform.newMatrix(2);
        if (p.length == 2) {
            m = BIJtransform.translate(m, p[0], p[1]);
        }
        if (p.length == 3) {
            m = BIJtransform.rotatez(BIJtransform.translate(m, p[0], p[1]), p[2]);
        }
        if (p.length == 5) {
            m = BIJtransform.scale(BIJtransform.rotatez(BIJtransform.translate(m, p[0], p[1]), p[2]), p[3], p[4]);
        }
        return m;
    }

    public static float bilinearExtend(float[] image, int width, int height, float x, float y) {
        if (x < 0.0f) {
            x = 0.0f;
        }
        if (x >= (float)(width - 1)) {
            x = (float)width - 1.001f;
        }
        if (y < 0.0f) {
            y = 0.0f;
        }
        if (y >= (float)(height - 1)) {
            y = (float)height - 1.001f;
        }
        return Transformer.bilinear(image, width, x, y);
    }

    public static float bilinear(float[] image, int width, float x, float y) {
        int xbase = (int)x;
        int ybase = (int)y;
        float xFraction = x - (float)xbase;
        float yFraction = y - (float)ybase;
        int offset = ybase * width + xbase;
        float lowerLeft = image[offset];
        float lowerRight = image[offset + 1];
        float upperRight = image[offset + width + 1];
        float upperLeft = image[offset + width];
        if (lowerLeft == Float.NaN || lowerRight == Float.NaN || upperRight == Float.NaN || upperLeft == Float.NaN) {
            return Float.NaN;
        }
        float upperAverage = upperLeft + xFraction * (upperRight - upperLeft);
        float lowerAverage = lowerLeft + xFraction * (lowerRight - lowerLeft);
        return lowerAverage + yFraction * (upperAverage - lowerAverage);
    }

    public static ImageProcessor transform(ImageProcessor ip, float[] p) {
        ImageProcessor regip = ip.duplicate();
        int width = ip.getWidth();
        int height = ip.getHeight();
        if (ip instanceof ColorProcessor) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    regip.putPixel(x, y, ((ColorProcessor)ip).getInterpolatedRGBPixel((double)((float)x - p[0]), (double)((float)y - p[1])));
                }
            }
        } else {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    regip.putPixelValue(x, y, ip.getInterpolatedPixel((double)((float)x - p[0]), (double)((float)y - p[1])));
                }
            }
        }
        return regip;
    }

    public static float[] quick(float[] image, int width, int xshift, int yshift) {
        int height = image.length / width;
        float[] tr = new float[image.length];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int nx = x + xshift;
                int ny = y + yshift;
                if (nx < 0) {
                    nx = 0;
                }
                if (nx >= width) {
                    nx = width - 1;
                }
                if (ny < 0) {
                    ny = 0;
                }
                if (ny >= height) {
                    y = height - 1;
                }
                tr[y * width + x] = image[ny * width + nx];
            }
        }
        return tr;
    }

    public static float[] extract(float[] image, int width, int newx, int newy, int newwidth, int newheight) {
        float[] newimage = new float[newwidth * newheight];
        for (int y = 0; y < newheight; ++y) {
            for (int x = 0; x < newwidth; ++x) {
                newimage[y * newwidth + x] = image[(newy + y) * width + (newx + x)];
            }
        }
        return newimage;
    }
}

