/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij;

import ij.CompositeImage;
import ij.IJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import mpicbg.ij.InverseTransformMapping;
import mpicbg.ij.MappingThread;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.InverseCoordinateTransform;
import mpicbg.models.InvertibleCoordinateTransform;
import mpicbg.models.Model;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;

public abstract class InteractiveInvertibleCoordinateTransform<M extends Model<M> & InvertibleCoordinateTransform>
implements PlugIn,
MouseListener,
MouseMotionListener,
KeyListener,
ImageListener {
    protected InverseTransformMapping<M> mapping;
    protected ImagePlus imp;
    protected final ArrayList<Tuple> tuples = new ArrayList();
    protected Point[] p;
    protected Point[] q;
    protected final ArrayList<PointMatch> m = new ArrayList();
    protected PointRoi handles;
    protected int targetIndex = -1;

    protected static final void useRoi(float[] x, float[] y) {
    }

    protected abstract M myModel();

    protected abstract void setHandles();

    protected abstract void updateHandles(int var1, int var2);

    protected void onReturn() {
    }

    public void run(String arg) {
        this.m.clear();
        this.tuples.clear();
        this.imp = IJ.getImage();
        if (this.imp.isComposite() && ((CompositeImage)this.imp).getMode() == 1) {
            int z = this.imp.getSlice();
            int t = this.imp.getFrame();
            for (int c = 1; c <= this.imp.getNChannels(); ++c) {
                int i = this.imp.getStackIndex(c, z, t);
                ImageProcessor target = this.imp.getStack().getProcessor(i);
                ImageProcessor source = target.duplicate();
                source.setInterpolationMethod(1);
                this.tuples.add(new Tuple(source, target));
            }
        } else {
            ImageProcessor target = this.imp.getProcessor();
            ImageProcessor source = target.duplicate();
            source.setInterpolationMethod(1);
            this.tuples.add(new Tuple(source, target));
        }
        this.mapping = new InverseTransformMapping<InverseCoordinateTransform>((InverseCoordinateTransform)this.myModel());
        for (Tuple tuple : this.tuples) {
            tuple.painter = new MappingThread(this.imp, tuple.source, tuple.target, tuple.pleaseRepaint, this.mapping, false, this.imp.getStackIndex(this.imp.getChannel(), this.imp.getSlice(), this.imp.getFrame()));
            tuple.painter.start();
        }
        this.setHandles();
        Toolbar.getInstance().setTool(Toolbar.getInstance().addTool("Drag_the_handles."));
        this.imp.getCanvas().addMouseListener((MouseListener)this);
        this.imp.getCanvas().addMouseMotionListener((MouseMotionListener)this);
        this.imp.getCanvas().addKeyListener((KeyListener)this);
    }

    public void imageClosed(ImagePlus imp2) {
        if (imp2 == this.imp) {
            for (Tuple tuple : this.tuples) {
                tuple.painter.interrupt();
            }
        }
    }

    public void imageOpened(ImagePlus imp2) {
    }

    public void imageUpdated(ImagePlus imp2) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27 || e.getKeyCode() == 10) {
            for (Tuple tuple : this.tuples) {
                tuple.painter.interrupt();
            }
            if (this.imp != null) {
                this.imp.getCanvas().removeMouseListener((MouseListener)this);
                this.imp.getCanvas().removeMouseMotionListener((MouseMotionListener)this);
                this.imp.getCanvas().removeKeyListener((KeyListener)this);
                this.imp.getCanvas().setDisplayList(null);
                this.imp.setRoi((Roi)null);
            }
            int z = this.imp.getSlice();
            int t = this.imp.getFrame();
            if (this.imp.isComposite() && ((CompositeImage)this.imp).getMode() == 1) {
                for (int c = 1; c <= this.imp.getNChannels(); ++c) {
                    int i = this.imp.getStackIndex(c, z, t);
                    ImageProcessor ip = this.tuples.get((int)(c - 1)).source;
                    this.imp.getStack().setPixels(ip.getPixels(), i);
                    if (c != this.imp.getChannel()) continue;
                    this.imp.setProcessor(ip);
                }
            } else {
                ImageProcessor ip = this.tuples.get((int)0).source;
                this.imp.setProcessor(ip);
                this.imp.getStack().setPixels(ip.getPixels(), this.imp.getStackIndex(this.imp.getChannel(), z, t));
            }
            if (e.getKeyCode() == 10) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int si = InteractiveInvertibleCoordinateTransform.this.imp.getStackIndex(InteractiveInvertibleCoordinateTransform.this.imp.getChannel(), InteractiveInvertibleCoordinateTransform.this.imp.getSlice(), InteractiveInvertibleCoordinateTransform.this.imp.getFrame());
                        ImageStack stack = InteractiveInvertibleCoordinateTransform.this.imp.getStack();
                        for (int i = 1; i <= stack.getSize(); ++i) {
                            ImageProcessor source = stack.getProcessor(i).duplicate();
                            ImageProcessor target = source.createProcessor(source.getWidth(), source.getHeight());
                            source.setInterpolationMethod(1);
                            InteractiveInvertibleCoordinateTransform.this.mapping.mapInterpolated(source, target);
                            if (i == si) {
                                InteractiveInvertibleCoordinateTransform.this.imp.getProcessor().setPixels(target.getPixels());
                            }
                            stack.setPixels(target.getPixels(), i);
                            IJ.showProgress((int)i, (int)stack.getSize());
                        }
                        if (InteractiveInvertibleCoordinateTransform.this.imp.isComposite()) {
                            ((CompositeImage)InteractiveInvertibleCoordinateTransform.this.imp).setChannelsUpdated();
                        }
                        InteractiveInvertibleCoordinateTransform.this.imp.updateAndDraw();
                    }
                });
                thread.start();
                this.onReturn();
            }
        } else if (e.getKeyCode() != 112 || e.getSource() instanceof TextField) {
            // empty if block
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.targetIndex = -1;
        if (e.getButton() == 1) {
            ImageWindow win = WindowManager.getCurrentWindow();
            int x = win.getCanvas().offScreenX(e.getX());
            int y = win.getCanvas().offScreenY(e.getY());
            double target_d = Double.MAX_VALUE;
            for (int i = 0; i < this.q.length; ++i) {
                double dy;
                double dx = win.getCanvas().getMagnification() * (this.q[i].getW()[0] - (double)x);
                double d = dx * dx + (dy = win.getCanvas().getMagnification() * (this.q[i].getW()[1] - (double)y)) * dy;
                if (!(d < 64.0) || !(d < target_d)) continue;
                this.targetIndex = i;
                target_d = d;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.targetIndex < 0) return;
        ImageWindow win = WindowManager.getCurrentWindow();
        int x = win.getCanvas().offScreenX(e.getX());
        int y = win.getCanvas().offScreenY(e.getY());
        this.updateHandles(x, y);
        try {
            this.myModel().fit(this.m);
            Iterator<Tuple> iterator = this.tuples.iterator();
            while (iterator.hasNext()) {
                Tuple tuple = iterator.next();
                MappingThread mappingThread = tuple.painter;
                synchronized (mappingThread) {
                    tuple.pleaseRepaint.set(true);
                    tuple.painter.notify();
                }
            }
            return;
        }
        catch (NotEnoughDataPointsException ex) {
            ex.printStackTrace();
            return;
        }
        catch (IllDefinedDataPointsException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public static String modifiers(int flags) {
        String s = " [ ";
        if (flags == 0) {
            return "";
        }
        if ((flags & 1) != 0) {
            s = s + "Shift ";
        }
        if ((flags & 2) != 0) {
            s = s + "Control ";
        }
        if ((flags & 4) != 0) {
            s = s + "Meta (right button) ";
        }
        if ((flags & 8) != 0) {
            s = s + "Alt ";
        }
        if ((s = s + "]").equals(" [ ]")) {
            s = " [no modifiers]";
        }
        return s;
    }

    public static class Tuple {
        public final ImageProcessor source;
        public final ImageProcessor target;
        public final AtomicBoolean pleaseRepaint = new AtomicBoolean(false);
        public MappingThread painter = null;

        Tuple(ImageProcessor source, ImageProcessor target) {
            this.source = source;
            this.target = target;
        }
    }
}

