/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.integral;

import ij.IJ;
import ij.gui.Roi;
import ij.gui.Toolbar;
import java.awt.Polygon;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import mpicbg.ij.integral.AbstractInteractiveBlockFilter;
import mpicbg.ij.integral.Tilt;

public class InteractiveTilt
extends AbstractInteractiveBlockFilter {
    protected int x1;
    protected int y1;
    protected int x2;
    protected int y2;
    protected Tilt tilt;

    @Override
    protected final void init() {
        this.tilt = Tilt.create(this.imp.getProcessor());
    }

    @Override
    protected final void draw() {
        this.tilt.render(this.x1, this.y1, this.x2, this.y2);
    }

    @Override
    public final void showHelp() {
        IJ.showMessage((String)"Interactive Tilt Shift", (String)("Use the line tool to specify location and orientation of the tilt axis and the tilt angle." + NL + "ENTER - Apply" + NL + "ESC - Cancel"));
    }

    @Override
    public void run(String arg) {
        this.ij = IJ.getInstance();
        this.imp = IJ.getImage();
        this.window = this.imp.getWindow();
        this.canvas = this.imp.getCanvas();
        this.canvas.addKeyListener(this);
        this.window.addKeyListener((KeyListener)this);
        this.canvas.addMouseMotionListener(this);
        this.canvas.addMouseListener(this);
        this.ij.addKeyListener((KeyListener)this);
        this.init();
        this.imp.getProcessor().snapshot();
        Toolbar.getInstance().setTool(4);
        this.painter = new AbstractInteractiveBlockFilter.PaintThread();
        this.painter.start();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Roi roi = this.imp.getRoi();
        if (roi != null) {
            Polygon poly = roi.getPolygon();
            if (roi.isLine()) {
                this.x1 = poly.xpoints[0];
                this.y1 = poly.ypoints[0];
                this.x2 = poly.xpoints[poly.xpoints.length - 1];
                this.y2 = poly.ypoints[poly.ypoints.length - 1];
            }
        } else {
            this.x1 = this.x2 = this.imp.getWidth() / 2;
            this.y1 = this.y2 = this.imp.getHeight() / 2;
        }
        this.painter.repaint();
    }
}

