/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.stack;

import ij.ImageStack;
import ij.process.ImageProcessor;
import mpicbg.ij.stack.AbstractTransformMapping;
import mpicbg.models.InverseCoordinateTransform;
import mpicbg.models.NoninvertibleModelException;

public class InverseTransformMapping<T extends InverseCoordinateTransform>
extends AbstractTransformMapping<T> {
    public InverseTransformMapping(T t) {
        super(t);
    }

    @Override
    public void map(ImageStack source, ImageProcessor target) {
        double[] t = new double[3];
        int sw = source.getWidth() - 1;
        int sh = source.getHeight() - 1;
        int sd = source.getSize();
        int tw = target.getWidth();
        int th = target.getHeight();
        ImageProcessor slice = source.getProcessor(1);
        for (int y = 0; y < th; ++y) {
            for (int x = 0; x < tw; ++x) {
                t[0] = x;
                t[1] = y;
                t[2] = this.z;
                try {
                    ((InverseCoordinateTransform)this.transform).applyInverseInPlace(t);
                    int tx = (int)(t[0] + 0.5);
                    int ty = (int)(t[1] + 0.5);
                    int tz = (int)(t[2] + 1.5);
                    if (tx < 0 || tx > sw || ty < 0 || ty > sh || tz < 1 || tz > sd) continue;
                    slice.setPixels(source.getPixels(tz));
                    target.putPixel(x, y, slice.getPixel(tx, ty));
                    continue;
                }
                catch (NoninvertibleModelException noninvertibleModelException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void mapInterpolated(ImageStack source, ImageProcessor target) {
        double[] t = new double[3];
        int sw = source.getWidth() - 1;
        int sh = source.getHeight() - 1;
        int sd = source.getSize();
        int tw = target.getWidth();
        int th = target.getHeight();
        ImageProcessor slice = source.getProcessor(1);
        slice.setInterpolationMethod(1);
        AbstractTransformMapping.Interpolator interpolator = InverseTransformMapping.pickInterpolator(slice);
        for (int y = 0; y < th; ++y) {
            for (int x = 0; x < tw; ++x) {
                t[0] = x;
                t[1] = y;
                t[2] = this.z;
                try {
                    ((InverseCoordinateTransform)this.transform).applyInverseInPlace(t);
                    int tza = (int)(t[2] + 1.0);
                    int tzb = (int)(t[2] + 2.0);
                    if (!(t[0] >= 0.0) || !(t[0] <= (double)sw) || !(t[1] >= 0.0) || !(t[1] <= (double)sh) || tza < 1 || tzb > sd) continue;
                    slice.setPixels(source.getPixels(tza));
                    int a = slice.getPixelInterpolated(t[0], t[1]);
                    slice.setPixels(source.getPixels(tzb));
                    int b = slice.getPixelInterpolated(t[0], t[1]);
                    target.putPixel(x, y, interpolator.interpolate(a, b, t[2] - (double)tza + 1.0));
                    continue;
                }
                catch (NoninvertibleModelException noninvertibleModelException) {
                    // empty catch block
                }
            }
        }
    }
}

