/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imagefeatures;

import java.io.Serializable;
import java.util.List;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;

public class Feature
implements Comparable<Feature>,
Serializable {
    private static final long serialVersionUID = 551364650592173605L;
    public double scale;
    public double orientation;
    public double[] location;
    public float[] descriptor;

    public Feature() {
    }

    public Feature(double s, double o, double[] l, float[] d) {
        this.scale = s;
        this.orientation = o;
        this.location = l;
        this.descriptor = d;
    }

    @Override
    public final int compareTo(Feature f) {
        return this.scale < f.scale ? 1 : (this.scale == f.scale ? 0 : -1);
    }

    public final double descriptorDistance(Feature f) {
        double d = 0.0;
        for (int i = 0; i < this.descriptor.length; ++i) {
            double a = this.descriptor[i] - f.descriptor[i];
            d += a * a;
        }
        return Math.sqrt(d);
    }

    public static final int matchFeatures(List<Feature> fs1, List<Feature> fs2, List<PointMatch> matches, double rod) {
        for (Feature f1 : fs1) {
            Feature best = null;
            double best_d = Double.MAX_VALUE;
            double second_best_d = Double.MAX_VALUE;
            for (Feature f2 : fs2) {
                double d = f1.descriptorDistance(f2);
                if (d < best_d) {
                    second_best_d = best_d;
                    best_d = d;
                    best = f2;
                    continue;
                }
                if (!(d < second_best_d)) continue;
                second_best_d = d;
            }
            if (best == null || !(second_best_d < Double.MAX_VALUE) || !(best_d / second_best_d < rod)) continue;
            matches.add(new PointMatch(new Point(new double[]{f1.location[0], f1.location[1]}), new Point(new double[]{best.location[0], best.location[1]})));
        }
        int i = 0;
        while (i < matches.size()) {
            boolean amb = false;
            PointMatch m = matches.get(i);
            double[] m_p2 = m.getP2().getL();
            int j = i + 1;
            while (j < matches.size()) {
                PointMatch n = matches.get(j);
                double[] n_p2 = n.getP2().getL();
                if (m_p2[0] == n_p2[0] && m_p2[1] == n_p2[1]) {
                    amb = true;
                    matches.remove(j);
                    continue;
                }
                ++j;
            }
            if (amb) {
                matches.remove(i);
                continue;
            }
            ++i;
        }
        return matches.size();
    }
}

