/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.i5d;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.PlotWindow;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import java.awt.Rectangle;

public class ChannelImagePlus
extends ImagePlus {
    public ChannelImagePlus(String title, ImageProcessor ip) {
        super(title, ip);
    }

    public void setTitle(String title) {
    }

    public String getValueAsStringI5d(int x, int y) {
        if (this.win != null && this.win instanceof PlotWindow) {
            return "";
        }
        Calibration cal = this.getCalibration();
        int v = this.getProcessor().getPixel(x, y);
        int type = this.getType();
        switch (type) {
            case 0: 
            case 1: {
                double cValue = cal.getCValue(v);
                if (cValue == (double)v) {
                    return "" + v;
                }
                return "" + IJ.d2s((double)cValue) + " (" + v + ")";
            }
            case 2: {
                return "" + Float.intBitsToFloat(v);
            }
        }
        return "";
    }

    public void putRoi(Roi newRoi) {
        Rectangle bounds = new Rectangle();
        if (newRoi != null) {
            bounds = newRoi.getBounds();
            if (bounds.width == 0 && bounds.height == 0 && newRoi.getType() != 10) {
                newRoi = null;
            }
        }
        this.roi = newRoi;
        if (this.roi != null) {
            if (this.ip != null) {
                this.ip.setMask(null);
                if (this.roi.isArea()) {
                    this.ip.setRoi(bounds);
                } else {
                    this.ip.resetRoi();
                }
            }
            this.roi.setImage((ImagePlus)this);
        }
        this.draw();
    }
}

